/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.charms;

import chylex.hee.mechanics.charms.CharmRecipe;
import chylex.hee.mechanics.charms.RuneType;
import chylex.hee.system.util.DragonUtil;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.tuple.Pair;

public enum CharmType {
    BASIC_POWER(15, 0, new CharmRecipe[]{new CharmRecipe(0).rune(RuneType.POWER, 3).prop("dmg", 1.25f), new CharmRecipe(1).rune(RuneType.POWER, 4).prop("dmg", 1.45f), new CharmRecipe(2).rune(RuneType.POWER, 5).prop("dmg", 1.6f)}, new String[]{"perc-1,dmg"}),
    BASIC_AGILITY(2, 1, new CharmRecipe[]{new CharmRecipe(3).rune(RuneType.AGILITY, 3).prop("spd", 1.15f), new CharmRecipe(4).rune(RuneType.AGILITY, 4).prop("spd", 1.28f), new CharmRecipe(5).rune(RuneType.AGILITY, 5).prop("spd", 1.4f)}, new String[]{"perc-1,spd"}),
    BASIC_VIGOR(4, 2, new CharmRecipe[]{new CharmRecipe(6).rune(RuneType.VIGOR, 3).prop("regenspd", 0.2f), new CharmRecipe(7).rune(RuneType.VIGOR, 4).prop("regenspd", 0.4f), new CharmRecipe(8).rune(RuneType.VIGOR, 5).prop("regenspd", 0.55f)}, new String[]{"perc,regenspd"}),
    BASIC_DEFENSE(8, 3, new CharmRecipe[]{new CharmRecipe(9).rune(RuneType.DEFENSE, 3).prop("reducedmg", 0.1f), new CharmRecipe(10).rune(RuneType.DEFENSE, 4).prop("reducedmg", 0.2f), new CharmRecipe(11).rune(RuneType.DEFENSE, 5).prop("reducedmg", 0.3f)}, new String[]{"perc,reducedmg"}),
    BASIC_MAGIC(11, 7, new CharmRecipe[]{new CharmRecipe(12).rune(RuneType.MAGIC, 3).prop("exp", 1.1f), new CharmRecipe(13).rune(RuneType.MAGIC, 4).prop("exp", 1.2f), new CharmRecipe(14).rune(RuneType.MAGIC, 5).prop("exp", 1.3f)}, new String[]{"perc-1,exp"}),
    EQUALITY(16, 9, new CharmRecipe[]{new CharmRecipe(18).rune(RuneType.POWER).rune(RuneType.AGILITY).rune(RuneType.VIGOR).rune(RuneType.DEFENSE).rune(RuneType.MAGIC).prop("dmg", 1.08f).prop("spd", 1.05f).prop("regenspd", 0.06f).prop("reducedmg", 0.03f).prop("exp", 1.03f)}, new String[]{"perc-1,dmg", "perc-1,spd", "perc,regenspd", "perc,reducedmg", "perc-1,exp"}),
    BLOCKING(0, 10, new CharmRecipe[]{new CharmRecipe(19).rune(RuneType.POWER).rune(RuneType.DEFENSE).rune(RuneType.VOID).prop("reducedmgblock", 0.2f), new CharmRecipe(20).rune(RuneType.POWER).rune(RuneType.DEFENSE, 2).rune(RuneType.VOID).prop("reducedmgblock", 0.32f), new CharmRecipe(21).rune(RuneType.POWER).rune(RuneType.DEFENSE, 3).rune(RuneType.VOID).prop("reducedmgblock", 0.45f)}, new String[]{"perc,reducedmgblock"}),
    BLOCKING_REFLECTION(1, 10, new CharmRecipe[]{new CharmRecipe(22).rune(RuneType.POWER).rune(RuneType.DEFENSE).rune(RuneType.VOID).rune(RuneType.MAGIC).prop("reducedmgblock", 0.2f).prop("blockreflectdmg", 0.1f), new CharmRecipe(23).rune(RuneType.POWER).rune(RuneType.DEFENSE).rune(RuneType.DEFENSE).rune(RuneType.VOID).rune(RuneType.MAGIC).prop("reducedmgblock", 0.32f).prop("blockreflectdmg", 0.1f), new CharmRecipe(24).rune(RuneType.POWER).rune(RuneType.POWER).rune(RuneType.DEFENSE).rune(RuneType.VOID).rune(RuneType.MAGIC).prop("reducedmgblock", 0.2f).prop("blockreflectdmg", 0.2f)}, new String[]{"perc,reducedmgblock", "perc,blockreflectdmg"}),
    BLOCKING_REPULSION(2, 10, new CharmRecipe[]{new CharmRecipe(71).rune(RuneType.POWER).rune(RuneType.DEFENSE).rune(RuneType.VOID).rune(RuneType.AGILITY).prop("reducedmgblock", 0.2f).prop("blockrepulsepower", 1.0f), new CharmRecipe(72).rune(RuneType.POWER).rune(RuneType.DEFENSE, 2).rune(RuneType.VOID).rune(RuneType.AGILITY).prop("reducedmgblock", 0.32f).prop("blockrepulsepower", 1.0f), new CharmRecipe(73).rune(RuneType.POWER).rune(RuneType.DEFENSE).rune(RuneType.VOID).rune(RuneType.AGILITY, 2).prop("reducedmgblock", 0.2f).prop("blockrepulsepower", 2.0f)}, new String[]{"perc,reducedmgblock", "int,blockrepulsepower"}),
    DIGESTIVE_RECOVER(3, 5, new CharmRecipe[]{new CharmRecipe(25).rune(RuneType.POWER).rune(RuneType.VIGOR).rune(RuneType.VOID).prop("healthperhunger", 0.5f), new CharmRecipe(26).rune(RuneType.POWER).rune(RuneType.VIGOR, 2).rune(RuneType.VOID).prop("healthperhunger", 1.0f), new CharmRecipe(27).rune(RuneType.POWER).rune(RuneType.VIGOR, 3).rune(RuneType.VOID).prop("healthperhunger", 2.0f)}, new String[]{"flopb,healthperhunger"}),
    LIFE_STEAL(5, 11, new CharmRecipe[]{new CharmRecipe(28).rune(RuneType.POWER).rune(RuneType.VIGOR).rune(RuneType.MAGIC).rune(RuneType.VOID).prop("stealhealth", 2.0f).prop("stealdealt", 16.0f), new CharmRecipe(29).rune(RuneType.POWER).rune(RuneType.VIGOR, 2).rune(RuneType.MAGIC).rune(RuneType.VOID).prop("stealhealth", 4.0f).prop("stealdealt", 16.0f), new CharmRecipe(30).rune(RuneType.POWER, 2).rune(RuneType.VIGOR, 2).rune(RuneType.VOID).prop("stealhealth", 2.0f).prop("stealdealt", 10.0f)}, new String[]{"int,stealhealth", "int,stealdealt"}),
    DAMAGE_REDIRECTION(14, 3, new CharmRecipe[]{new CharmRecipe(31).rune(RuneType.AGILITY).rune(RuneType.DEFENSE).rune(RuneType.MAGIC).prop("rediramt", 0.15f).prop("redirmobs", 1.0f), new CharmRecipe(32).rune(RuneType.AGILITY, 2).rune(RuneType.DEFENSE).rune(RuneType.MAGIC).prop("rediramt", 0.12f).prop("redirmobs", 2.0f), new CharmRecipe(33).rune(RuneType.AGILITY, 3).rune(RuneType.DEFENSE).rune(RuneType.MAGIC).prop("rediramt", 0.14f).prop("redirmobs", 3.0f), new CharmRecipe(34).rune(RuneType.AGILITY).rune(RuneType.DEFENSE, 2).rune(RuneType.MAGIC).prop("rediramt", 0.2f).prop("redirmobs", 1.0f), new CharmRecipe(35).rune(RuneType.AGILITY, 2).rune(RuneType.DEFENSE, 2).rune(RuneType.MAGIC).prop("rediramt", 0.18f).prop("redirmobs", 2.0f), new CharmRecipe(36).rune(RuneType.AGILITY).rune(RuneType.DEFENSE, 3).rune(RuneType.MAGIC).prop("rediramt", 0.3f).prop("redirmobs", 1.0f)}, new String[]{"perc,rediramt", "int,redirmobs"}),
    MAGIC_PENETRATION(13, 4, new CharmRecipe[]{new CharmRecipe(37).rune(RuneType.POWER, 2).rune(RuneType.MAGIC).prop("dmgtomagic", 0.1f), new CharmRecipe(38).rune(RuneType.POWER, 3).rune(RuneType.MAGIC).prop("dmgtomagic", 0.15f), new CharmRecipe(39).rune(RuneType.POWER, 4).rune(RuneType.MAGIC).prop("dmgtomagic", 0.2f), new CharmRecipe(40).rune(RuneType.POWER, 3).rune(RuneType.MAGIC, 2).prop("dmgtomagic", 0.25f), new CharmRecipe(41).rune(RuneType.POWER).rune(RuneType.MAGIC, 2).prop("dmgtomagic", 0.15f), new CharmRecipe(42).rune(RuneType.POWER).rune(RuneType.MAGIC, 3).prop("dmgtomagic", 0.25f), new CharmRecipe(43).rune(RuneType.POWER).rune(RuneType.MAGIC, 4).prop("dmgtomagic", 0.32f)}, new String[]{"perc,dmgtomagic"}),
    WITCHERY_HARM(12, 4, new CharmRecipe[]{new CharmRecipe(44).rune(RuneType.POWER).rune(RuneType.MAGIC).rune(RuneType.VIGOR).rune(RuneType.VOID).prop("badeffchance", 0.08f).prop("badefflvl", 1.0f).prop("badefftime", 5.0f), new CharmRecipe(45).rune(RuneType.POWER).rune(RuneType.MAGIC).rune(RuneType.VIGOR, 2).rune(RuneType.VOID).prop("badeffchance", 0.09f).prop("badefflvl", 2.0f).prop("badefftime", 5.0f), new CharmRecipe(46).rune(RuneType.POWER).rune(RuneType.MAGIC, 2).rune(RuneType.VIGOR).rune(RuneType.VOID).prop("badeffchance", 0.14f).prop("badefflvl", 1.0f).prop("badefftime", 5.0f), new CharmRecipe(65).rune(RuneType.POWER, 2).rune(RuneType.MAGIC).rune(RuneType.VIGOR).rune(RuneType.VOID).prop("badeffchance", 0.09f).prop("badefflvl", 1.0f).prop("badefftime", 10.0f)}, new String[]{"perc,badeffchance", "int,badefflvl", "int,badefftime"}),
    MAGIC_DEFENSE(10, 3, new CharmRecipe[]{new CharmRecipe(74).rune(RuneType.DEFENSE).rune(RuneType.MAGIC).rune(RuneType.VOID).prop("reducemagicdmg", 0.3f), new CharmRecipe(75).rune(RuneType.DEFENSE, 2).rune(RuneType.MAGIC).rune(RuneType.VOID).prop("reducemagicdmg", 0.5f), new CharmRecipe(76).rune(RuneType.DEFENSE, 3).rune(RuneType.MAGIC).rune(RuneType.VOID).prop("reducemagicdmg", 0.7f)}, new String[]{"perc,reducemagicdmg"}),
    FALLING_PROTECTION(10, 6, new CharmRecipe[]{new CharmRecipe(49).rune(RuneType.AGILITY, 3).rune(RuneType.DEFENSE).prop("fallblocks", 3.0f), new CharmRecipe(50).rune(RuneType.AGILITY, 4).rune(RuneType.DEFENSE).prop("fallblocks", 6.0f)}, new String[]{"int,fallblocks"}),
    HASTE(1, 8, new CharmRecipe[]{new CharmRecipe(51).rune(RuneType.AGILITY, 2).rune(RuneType.VOID).prop("breakspd", 1.1f), new CharmRecipe(52).rune(RuneType.AGILITY, 3).rune(RuneType.VOID).prop("breakspd", 1.18f), new CharmRecipe(53).rune(RuneType.AGILITY, 4).rune(RuneType.VOID).prop("breakspd", 1.25f)}, new String[]{"perc-1,breakspd"}),
    CRITICAL_STRIKE(14, 12, new CharmRecipe[]{new CharmRecipe(54).rune(RuneType.POWER, 2).rune(RuneType.AGILITY).prop("critchance", 0.1f).prop("critdmg", 1.5f), new CharmRecipe(55).rune(RuneType.POWER, 3).rune(RuneType.AGILITY).prop("critchance", 0.1f).prop("critdmg", 2.0f), new CharmRecipe(56).rune(RuneType.POWER, 4).rune(RuneType.AGILITY).prop("critchance", 0.1f).prop("critdmg", 2.6f), new CharmRecipe(57).rune(RuneType.POWER, 2).rune(RuneType.AGILITY, 2).prop("critchance", 0.15f).prop("critdmg", 1.5f), new CharmRecipe(58).rune(RuneType.POWER, 2).rune(RuneType.AGILITY, 3).prop("critchance", 0.22f).prop("critdmg", 1.5f), new CharmRecipe(59).rune(RuneType.POWER, 3).rune(RuneType.AGILITY, 3).prop("critchance", 0.15f).prop("critdmg", 2.0f)}, new String[]{"perc,critchance", "perc,critdmg"}),
    SECOND_DURABILITY(12, 8, new CharmRecipe[]{new CharmRecipe(60).rune(RuneType.VIGOR).rune(RuneType.MAGIC).rune(RuneType.VOID).prop("recdurabilitychance", 0.28f).prop("recdurabilityamt", 0.1f), new CharmRecipe(61).rune(RuneType.VIGOR, 2).rune(RuneType.MAGIC).rune(RuneType.VOID).prop("recdurabilitychance", 0.25f).prop("recdurabilityamt", 0.18f), new CharmRecipe(62).rune(RuneType.VIGOR, 3).rune(RuneType.MAGIC).rune(RuneType.VOID).prop("recdurabilitychance", 0.22f).prop("recdurabilityamt", 0.25f), new CharmRecipe(63).rune(RuneType.VIGOR).rune(RuneType.MAGIC, 2).rune(RuneType.VOID).prop("recdurabilitychance", 0.32f).prop("recdurabilityamt", 0.16f), new CharmRecipe(64).rune(RuneType.VIGOR).rune(RuneType.MAGIC, 3).rune(RuneType.VOID).prop("recdurabilitychance", 0.44f).prop("recdurabilityamt", 0.12f)}, new String[]{"perc,recdurabilitychance", "perc,recdurabilityamt"}),
    SLAUGHTER_IMPACT(15, 12, new CharmRecipe[]{new CharmRecipe(17).rune(RuneType.POWER).rune(RuneType.MAGIC).rune(RuneType.VOID).prop("impactamt", 0.6f).prop("impactrad", 4.0f), new CharmRecipe(66).rune(RuneType.POWER, 2).rune(RuneType.MAGIC).rune(RuneType.VOID).prop("impactamt", 0.9f).prop("impactrad", 4.0f), new CharmRecipe(67).rune(RuneType.POWER, 3).rune(RuneType.MAGIC).rune(RuneType.VOID).prop("impactamt", 1.4f).prop("impactrad", 4.0f), new CharmRecipe(68).rune(RuneType.POWER).rune(RuneType.MAGIC, 2).rune(RuneType.VOID).prop("impactamt", 0.7f).prop("impactrad", 6.0f), new CharmRecipe(69).rune(RuneType.POWER).rune(RuneType.MAGIC, 3).rune(RuneType.VOID).prop("impactamt", 0.7f).prop("impactrad", 8.0f), new CharmRecipe(70).rune(RuneType.POWER, 2).rune(RuneType.MAGIC, 2).rune(RuneType.VOID).prop("impactamt", 1.0f).prop("impactrad", 6.0f)}, new String[]{"perc,impactamt", "int,impactrad"}),
    LAST_RESORT(9, 7, new CharmRecipe[]{new CharmRecipe(77).rune(RuneType.DEFENSE).rune(RuneType.AGILITY).rune(RuneType.MAGIC).rune(RuneType.VOID).prop("lastresortblocks", 6.0f).prop("lastresortcooldown", 10.0f), new CharmRecipe(78).rune(RuneType.DEFENSE).rune(RuneType.AGILITY, 2).rune(RuneType.MAGIC).rune(RuneType.VOID).prop("lastresortblocks", 6.0f).prop("lastresortcooldown", 6.0f), new CharmRecipe(79).rune(RuneType.DEFENSE).rune(RuneType.AGILITY).rune(RuneType.MAGIC, 2).rune(RuneType.VOID).prop("lastresortblocks", 12.0f).prop("lastresortcooldown", 10.0f)}, new String[]{"int,lastresortblocks", "int,lastresortcooldown"});

    public final CharmRecipe[] recipes;
    public final byte backIcon;
    public final byte foregroundIcon;
    private final String[] tooltipArgs;

    public static Pair<CharmType, CharmRecipe> getFromDamage(int damage) {
        for (CharmType type : CharmType.values()) {
            for (CharmRecipe recipe : type.recipes) {
                if (recipe.id != damage) continue;
                return Pair.of((Object)((Object)type), (Object)recipe);
            }
        }
        return Pair.of(null, null);
    }

    public static Pair<CharmType, CharmRecipe> findRecipe(RuneType[] runes) {
        if (runes.length < 3 || runes.length > 5) {
            return null;
        }
        for (CharmType type : CharmType.values()) {
            for (CharmRecipe recipe : type.recipes) {
                if (!recipe.checkRunes(runes)) continue;
                return Pair.of((Object)((Object)type), (Object)recipe);
            }
        }
        return Pair.of(null, null);
    }

    public static String getTooltip(int damage) {
        for (CharmType type : CharmType.values()) {
            for (CharmRecipe recipe : type.recipes) {
                if (recipe.id != damage) continue;
                String tooltip = StatCollector.func_74838_a((String)("item.charm." + type.name().toLowerCase().replace("_", "") + ".tooltip"));
                block20: for (int arg = 0; arg < type.tooltipArgs.length; ++arg) {
                    String replacement;
                    String[] args = type.tooltipArgs[arg].split(",");
                    if (args.length < 2) continue;
                    switch (args[0]) {
                        case "float": {
                            replacement = DragonUtil.formatTwoPlaces.format(recipe.getProp(args[1]));
                            break;
                        }
                        case "floatnf": {
                            replacement = String.valueOf(recipe.getProp(args[1]));
                            break;
                        }
                        case "flopb": {
                            float val = recipe.getProp(args[1]);
                            replacement = val < 1.0f ? DragonUtil.formatOnePlace.format(val) : String.valueOf(Math.round(val));
                            break;
                        }
                        case "perc": {
                            replacement = Math.round(100.0f * recipe.getProp(args[1])) + "%";
                            break;
                        }
                        case "perc1-": {
                            replacement = Math.round(100.0f * (1.0f - recipe.getProp(args[1]))) + "%";
                            break;
                        }
                        case "perc-1": {
                            replacement = Math.round(100.0f * (recipe.getProp(args[1]) - 1.0f)) + "%";
                            break;
                        }
                        case "int": {
                            replacement = String.valueOf(Math.round(recipe.getProp(args[1])));
                            break;
                        }
                        default: {
                            continue block20;
                        }
                    }
                    tooltip = tooltip.replace("$" + arg, replacement);
                }
                if (!type.canBeStacked()) {
                    tooltip = tooltip + "\\n" + EnumChatFormatting.DARK_GRAY + StatCollector.func_74838_a((String)"item.charm.cannotstack");
                }
                return tooltip;
            }
        }
        return "";
    }

    private CharmType(int backIcon, int foregroundIcon, CharmRecipe[] recipes, String[] tooltipArgs) {
        this.recipes = recipes;
        this.backIcon = (byte)backIcon;
        this.foregroundIcon = (byte)foregroundIcon;
        this.tooltipArgs = tooltipArgs;
    }

    public boolean canBeStacked() {
        return this != LIFE_STEAL && this != LAST_RESORT;
    }
}

