/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.dimension;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.TreeMap;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.planets.asteroids.AsteroidsModule;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.AsteroidSaveData;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.ChunkProviderAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.WorldChunkManagerAsteroids;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldProviderAsteroids
extends WorldProviderSpace
implements ISolarLevel {
    private HashSet<BlockVec3> asteroidCentres = new HashSet();
    private boolean dataNotLoaded = true;
    private AsteroidSaveData datafile;
    private double solarMultiplier = -1.0;

    public CelestialBody getCelestialBody() {
        return AsteroidsModule.planetAsteroids;
    }

    public Vector3 getFogColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public Vector3 getSkyColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public boolean canRainOrSnow() {
        return false;
    }

    public boolean hasSunset() {
        return false;
    }

    public long getDayLength() {
        return 0L;
    }

    public boolean isDaytime() {
        return true;
    }

    public Class<? extends IChunkProvider> getChunkProviderClass() {
        return ChunkProviderAsteroids.class;
    }

    public Class<? extends WorldChunkManager> getWorldChunkManagerClass() {
        return WorldChunkManagerAsteroids.class;
    }

    public boolean shouldForceRespawn() {
        return !ConfigManagerCore.forceOverworldRespawn;
    }

    public float func_76563_a(long par1, float par3) {
        return 0.25f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        return 1.0f;
    }

    public double getHorizon() {
        return 44.0;
    }

    public int func_76557_i() {
        return 44;
    }

    public boolean func_76566_a(int var1, int var2) {
        return true;
    }

    public float getGravity() {
        return 0.072f;
    }

    public double getMeteorFrequency() {
        return 10.0;
    }

    public double getFuelUsageMultiplier() {
        return 0.9;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= 3;
    }

    public float getFallDamageModifier() {
        return 0.1f;
    }

    public float getSoundVolReductionAmount() {
        return 10.0f;
    }

    public boolean hasBreathableAtmosphere() {
        return false;
    }

    public float getThermalLevelModifier() {
        return -1.5f;
    }

    public void addAsteroid(int x, int y, int z) {
        BlockVec3 coords = new BlockVec3(x, y, z);
        if (!this.asteroidCentres.contains(coords)) {
            if (this.dataNotLoaded) {
                this.loadAsteroidSavedData();
            }
            if (!this.asteroidCentres.contains(coords)) {
                this.addToNBT(this.datafile.datacompound, coords);
                this.asteroidCentres.add(coords);
            }
        }
    }

    public void removeAsteroid(int x, int y, int z) {
        BlockVec3 coords = new BlockVec3(x, y, z);
        if (this.asteroidCentres.contains(coords)) {
            this.asteroidCentres.remove(coords);
            if (this.dataNotLoaded) {
                this.loadAsteroidSavedData();
            }
            this.writeToNBT(this.datafile.datacompound);
        }
    }

    private void loadAsteroidSavedData() {
        this.datafile = (AsteroidSaveData)this.field_76579_a.func_72943_a(AsteroidSaveData.class, "GCAsteroidData");
        if (this.datafile == null) {
            this.datafile = new AsteroidSaveData("");
            this.field_76579_a.func_72823_a("GCAsteroidData", (WorldSavedData)this.datafile);
            this.writeToNBT(this.datafile.datacompound);
        } else {
            this.readFromNBT(this.datafile.datacompound);
        }
        this.dataNotLoaded = false;
    }

    private void readFromNBT(NBTTagCompound nbt) {
        NBTTagList coordList = nbt.func_150295_c("coords", 10);
        if (coordList.func_74745_c() > 0) {
            for (int j = 0; j < coordList.func_74745_c(); ++j) {
                NBTTagCompound tag1 = coordList.func_150305_b(j);
                if (tag1 == null) continue;
                this.asteroidCentres.add(BlockVec3.readFromNBT((NBTTagCompound)tag1));
            }
        }
    }

    private void writeToNBT(NBTTagCompound nbt) {
        NBTTagList coordList = new NBTTagList();
        for (BlockVec3 coords : this.asteroidCentres) {
            NBTTagCompound tag = new NBTTagCompound();
            coords.writeToNBT(tag);
            coordList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("coords", (NBTBase)coordList);
        this.datafile.func_76185_a();
    }

    private void addToNBT(NBTTagCompound nbt, BlockVec3 coords) {
        NBTTagList coordList = nbt.func_150295_c("coords", 10);
        NBTTagCompound tag = new NBTTagCompound();
        coords.writeToNBT(tag);
        coordList.func_74742_a((NBTBase)tag);
        nbt.func_74782_a("coords", (NBTBase)coordList);
        this.datafile.func_76185_a();
    }

    public BlockVec3 getClosestAsteroidXZ(int x, int y, int z) {
        if (this.dataNotLoaded) {
            this.loadAsteroidSavedData();
        }
        if (this.asteroidCentres.size() == 0) {
            return null;
        }
        BlockVec3 result = null;
        int lowestDistance = Integer.MAX_VALUE;
        for (BlockVec3 test : this.asteroidCentres) {
            int dx = x - test.x;
            int dz = z - test.z;
            int a = dx * dx + dz * dz;
            if (a >= lowestDistance) continue;
            lowestDistance = a;
            result = test;
        }
        return result.clone();
    }

    public ArrayList<BlockVec3> getClosestAsteroidsXZ(int x, int y, int z, int facing, int count) {
        if (this.dataNotLoaded) {
            this.loadAsteroidSavedData();
        }
        if (this.asteroidCentres.size() == 0) {
            return null;
        }
        TreeMap<Integer, BlockVec3> targets = new TreeMap<Integer, BlockVec3>();
        block12: for (BlockVec3 test : this.asteroidCentres) {
            int dz;
            int dx;
            int a;
            switch (facing) {
                case 2: {
                    if (z - 16 >= test.z) break;
                    continue block12;
                }
                case 3: {
                    if (z + 16 <= test.z) break;
                    continue block12;
                }
                case 4: {
                    if (x - 16 >= test.x) break;
                    continue block12;
                }
                case 5: {
                    if (x + 16 <= test.x) break;
                    continue block12;
                }
            }
            if ((a = (dx = x - test.x) * dx + (dz = z - test.z) * dz) >= 262144) continue;
            targets.put(a, test);
        }
        int max = Math.max(count, targets.size());
        if (max <= 0) {
            return null;
        }
        ArrayList<BlockVec3> returnValues = new ArrayList<BlockVec3>();
        int i = 0;
        int offset = 6;
        for (BlockVec3 target : targets.values()) {
            BlockVec3 coords = target.clone();
            System.out.println("Found nearby asteroid at " + target.toString());
            switch (facing) {
                case 2: {
                    coords.z += offset;
                    break;
                }
                case 3: {
                    coords.z -= offset;
                    break;
                }
                case 4: {
                    coords.x += offset;
                    break;
                }
                case 5: {
                    coords.x -= offset;
                }
            }
            returnValues.add(coords);
            if (++i < count) continue;
            break;
        }
        return returnValues;
    }

    public float getWindLevel() {
        return 0.05f;
    }

    public int getActualHeight() {
        return 256;
    }

    public void func_76572_b() {
        super.func_76572_b();
        this.field_76576_e = true;
    }

    public double getSolarEnergyMultiplier() {
        if (this.solarMultiplier < 0.0) {
            double s = this.getSolarSize();
            this.solarMultiplier = s * s * s * ConfigManagerCore.spaceStationEnergyScalar;
        }
        return this.solarMultiplier;
    }
}

