/*
 * Decompiled with CFR 0.152.
 */
package neresources.registry;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import neresources.api.utils.PlantDrop;
import neresources.entries.PlantEntry;
import neresources.utils.MapKeys;
import net.minecraft.item.ItemStack;

public class PlantRegistry {
    private Map<String, PlantEntry> registry = new LinkedHashMap<String, PlantEntry>();
    private Map<String, List<String>> dropLinks = new LinkedHashMap<String, List<String>>();
    private static PlantRegistry instance = null;

    public static PlantRegistry getInstance() {
        if (instance == null) {
            instance = new PlantRegistry();
            return instance;
        }
        return instance;
    }

    public PlantRegistry() {
        this.registerPlant(PlantEntry.registerGrass());
    }

    public boolean registerPlant(PlantEntry entry) {
        String key = MapKeys.getKey(entry.getPlant());
        if (this.contains(key)) {
            return false;
        }
        this.registry.put(key, entry);
        for (PlantDrop drop : entry.getDrops()) {
            String dropKey = MapKeys.getKey(drop.getDrop());
            if (this.dropLinks.containsKey(key)) {
                this.dropLinks.get(key).add(key);
                continue;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(key);
            this.dropLinks.put(dropKey, list);
        }
        return true;
    }

    public boolean contains(ItemStack itemStack) {
        return this.contains(MapKeys.getKey(itemStack));
    }

    private boolean contains(String key) {
        return this.registry.containsKey(key);
    }

    public boolean containsDrop(ItemStack itemStack) {
        return this.containsDrop(MapKeys.getKey(itemStack));
    }

    private boolean containsDrop(String key) {
        return this.dropLinks.containsKey(key);
    }

    public List<PlantEntry> getEntriesForDrop(ItemStack itemStack) {
        String key = MapKeys.getKey(itemStack);
        if (!this.containsDrop(key)) {
            return null;
        }
        ArrayList<PlantEntry> list = new ArrayList<PlantEntry>();
        for (String plantKey : this.dropLinks.get(key)) {
            if (!this.registry.containsKey(plantKey)) continue;
            list.add(this.registry.get(plantKey));
        }
        return list;
    }

    public PlantEntry getEntry(ItemStack itemStack) {
        String key = MapKeys.getKey(itemStack);
        if (!this.contains(key)) {
            return null;
        }
        return this.registry.get(key);
    }

    public List<PlantEntry> getAllPlants() {
        return new ArrayList<PlantEntry>(this.registry.values());
    }

    public Map<ItemStack, Float> getDrops(PlantEntry entry) {
        LinkedHashMap<ItemStack, Float> map = new LinkedHashMap<ItemStack, Float>();
        float totalWeight = entry.getTotalWeight();
        for (PlantDrop drop : entry.getDrops()) {
            map.put(drop.getDrop(), Float.valueOf((float)drop.getWeight() / totalWeight));
        }
        return map;
    }

    public void clear() {
        instance = new PlantRegistry();
    }
}

