/*
 * Decompiled with CFR 0.152.
 */
package neresources.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.List;
import neresources.api.utils.conditionals.Conditional;
import neresources.config.Settings;
import neresources.entries.OreMatchEntry;
import neresources.reference.Resources;
import neresources.registry.OreRegistry;
import neresources.utils.Font;
import neresources.utils.RenderHelper;
import neresources.utils.TranslationHelper;
import net.minecraft.item.ItemStack;

public class NEIOreHandler
extends TemplateRecipeHandler {
    private static final int X_OFFSPRING = 59;
    private static final int Y_OFFSPRING = 52;
    private static final int X_AXIS_SIZE = 90;
    private static final int Y_AXIS_SIZE = 40;
    private static final int X_ITEM = 8;
    private static final int Y_ITEM = 6;
    private static int CYCLE_TIME = (int)(20.0f * Settings.CYCLE_TIME);

    public static void reloadSettings() {
        CYCLE_TIME = (int)(20.0f * Settings.CYCLE_TIME);
    }

    public String getGuiTexture() {
        return Resources.Gui.Nei.ORE.toString();
    }

    public String getRecipeName() {
        return TranslationHelper.translateToLocal("ner.ore.title");
    }

    public int recipiesPerPage() {
        return 2;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(60, -12, 45, 10), "neresources.ore", new Object[]{new Object()}));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("neresources.ore")) {
            for (OreMatchEntry entry : OreRegistry.getOres()) {
                this.arecipes.add(new CachedOre(entry));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (OreMatchEntry entry : OreRegistry.getRegistryMatches(result)) {
            if (entry == null) continue;
            this.arecipes.add(new CachedOre(entry));
        }
    }

    public void drawExtras(int recipe) {
        CachedOre cachedOre = (CachedOre)((Object)this.arecipes.get(recipe));
        float[] array = cachedOre.oreMatchEntry.getChances();
        double max = 0.0;
        float[] arr$ = array;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double d = arr$[i$];
            if (!(d > max)) continue;
            max = d;
        }
        double xPrev = 59.0;
        double yPrev = 52.0;
        double space = 90.0 / ((double)array.length * 1.0);
        int precision = array.length / 2 < 1 ? 1 : array.length / 2;
        float[] arr$2 = array;
        int len$2 = arr$2.length;
        for (int i$ = 0; i$ < len$2; ++i$) {
            double value = arr$2[i$];
            double x = xPrev + space;
            int y = 52 - (int)(value / max * 40.0);
            RenderHelper.drawLine(xPrev, yPrev, x, y, cachedOre.getLineColor(), precision);
            xPrev = x;
            yPrev = y;
        }
        Font font = new Font(true);
        font.print("0%", 49, 45);
        font.print(String.format("%.2f", max * 100.0) + "%", 39, 12);
        int minY = cachedOre.oreMatchEntry.getMinY() - Settings.EXTRA_RANGE;
        font.print(minY < 0 ? 0 : minY, 56, 54);
        int maxY = cachedOre.oreMatchEntry.getMaxY() + Settings.EXTRA_RANGE;
        font.print(maxY > 255 ? 255 : maxY, 149, 54);
        font.print(TranslationHelper.translateToLocal("ner.ore.bestY") + ": " + cachedOre.oreMatchEntry.getBestY(), 6, 26);
        cachedOre.cycleItemStack(this.cycleticks);
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> currenttip, int recipe) {
        CachedOre cachedOre = (CachedOre)((Object)this.arecipes.get(recipe));
        if (stack != null && cachedOre.contains(stack)) {
            if (cachedOre.oreMatchEntry.isSilkTouchNeeded(stack)) {
                currenttip.add(Conditional.silkTouch.toString());
            }
            if (gui.isMouseOver(cachedOre.getResult(), recipe)) {
                currenttip.addAll(cachedOre.getRestrictions());
            }
        }
        return currenttip;
    }

    public class CachedOre
    extends TemplateRecipeHandler.CachedRecipe {
        private OreMatchEntry oreMatchEntry;
        private List<ItemStack> oresAndDrops;
        private int current;
        private int last;
        private long cycleAt;

        public CachedOre(OreMatchEntry oreMatchEntry) {
            super((TemplateRecipeHandler)NEIOreHandler.this);
            this.oreMatchEntry = oreMatchEntry;
            this.oresAndDrops = oreMatchEntry.getOresAndDrops();
            this.current = 0;
            this.last = this.oresAndDrops.size() - 1;
            this.cycleAt = -1L;
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.oresAndDrops.get(this.current), 8, 6);
        }

        public int getLineColor() {
            return this.oreMatchEntry.getColour();
        }

        public List<String> getRestrictions() {
            return this.oreMatchEntry.getRestrictions();
        }

        public boolean contains(ItemStack itemStack) {
            for (ItemStack listStack : this.oresAndDrops) {
                if (!listStack.func_77969_a(itemStack)) continue;
                return true;
            }
            return false;
        }

        public void cycleItemStack(long tick) {
            if (this.cycleAt == -1L) {
                this.cycleAt = tick + (long)CYCLE_TIME;
            }
            if (tick >= this.cycleAt) {
                if (++this.current > this.last) {
                    this.current = 0;
                }
                this.cycleAt += (long)CYCLE_TIME;
            }
        }
    }
}

