/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.blocks.Blocks;
import emasher.items.Items;
import emasher.util.Config;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class ModInternalClock
extends SocketModule {
    public static final int[] settings = new int[]{20, 40, 80, 160, 200, 600, 1200, 2400};

    public ModInternalClock(int id) {
        super(id, "eng_toolbox:clock");
    }

    @Override
    public String getLocalizedName() {
        return "Internal Clock";
    }

    public void getToolTip(List l) {
        l.add("Creates an internal redstone pulse periodically");
    }

    public void getIndicatorKey(List l) {
        l.add(Config.PREF_RED() + "Output Channel");
        l.add(Config.PREF_WHITE() + "Modify length of delay");
    }

    @Override
    public void addRecipe() {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Items.module(), 1, this.moduleID), (Object[])new Object[]{"b", Character.valueOf('b'), new ItemStack(Items.module(), 1, 35)});
    }

    @Override
    public boolean hasRSIndicator() {
        return true;
    }

    @Override
    public boolean hasLatchIndicator() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getInternalTexture(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        int timer = config.meta & 7;
        if (timer == 0) {
            return "eng_toolbox:inner_latch_inactive";
        }
        return "eng_toolbox:inner_latch_active";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String[] getAllInternalTextures() {
        return new String[]{"eng_toolbox:inner_latch_inactive", "eng_toolbox:inner_latch_active"};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon[] getAdditionalOverlays(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        int setting = 0;
        int time = 0;
        int on = 0;
        setting = config.meta >> 3;
        on = config.meta & 7;
        time = config.meta >> 6;
        time = (int)Math.ceil(time * 7 / settings[setting &= 7]);
        if (on > 0) {
            time = 7;
        }
        return new IIcon[]{Blocks.socket().bar1[setting], Blocks.socket().bar2[time]};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean flipBottomOverlay() {
        return true;
    }

    @Override
    public void updateSide(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        int i;
        int setting = 0;
        int oldTime = 0;
        int reBuild = 0;
        int on = config.meta & 7;
        boolean reRender = false;
        boolean updateAdj = false;
        boolean allOff = true;
        setting = config.meta >> 3;
        setting &= 7;
        int time = oldTime = config.meta >> 6;
        boolean doInc = false;
        for (i = 0; i < 3; ++i) {
            if (config.rsLatch[i]) {
                allOff = false;
                if (ts.getRSLatch(i)) {
                    doInc = true;
                }
            }
            if (!allOff) continue;
            doInc = true;
        }
        if (doInc) {
            int timeDisp;
            if ((oldTime = (int)Math.ceil(oldTime * 7 / settings[setting])) != (timeDisp = (int)Math.ceil(++time * 7 / settings[setting]))) {
                reRender = true;
            }
            if (time >= settings[setting]) {
                time = 0;
                on = 1;
                reRender = true;
                updateAdj = true;
                for (int i2 = 0; i2 < 3; ++i2) {
                    if (!config.rsControl[i2]) continue;
                    ts.modifyRS(i2, true);
                }
            }
        }
        if (on != 0) {
            ++on;
        }
        if (on >= 5) {
            on = 0;
            reRender = true;
            updateAdj = true;
            for (i = 0; i < 3; ++i) {
                if (!config.rsControl[i]) continue;
                ts.modifyRS(i, false);
            }
        }
        reBuild = time;
        reBuild <<= 3;
        reBuild |= setting;
        reBuild <<= 3;
        config.meta = reBuild |= on;
        if (reRender) {
            ts.sendClientSideState(side.ordinal());
        }
        if (updateAdj) {
            ts.updateAdj(side);
        }
    }

    @Override
    public void onGenericRemoteSignal(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        int on = config.meta & 7;
        int setting = config.meta >> 3;
        setting &= 7;
        int time = config.meta >> 6;
        int reBuild = 0;
        if (++setting >= 8) {
            setting = 0;
        }
        reBuild = 0;
        reBuild <<= 3;
        reBuild |= setting;
        reBuild <<= 3;
        config.meta = reBuild |= on;
        ts.sendClientSideState(side.ordinal());
    }
}

