/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import cpw.mods.fml.common.registry.GameRegistry;
import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModEnergyOutput
extends SocketModule {
    public ModEnergyOutput(int id) {
        super(id, "eng_toolbox:energyOutput");
    }

    @Override
    public String getLocalizedName() {
        return "Energy Output";
    }

    public void getToolTip(List l) {
        l.add("Outputs Redstone Flux Energy");
        l.add("to adjacent cables/machines/etc.");
    }

    @Override
    public void addRecipe() {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(emasher.items.Items.module(), 1, this.moduleID), (Object[])new Object[]{" g ", " b ", Character.valueOf('g'), Items.field_151074_bl, Character.valueOf('p'), emasher.items.Items.psu(), Character.valueOf('b'), emasher.items.Items.blankSide()});
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(emasher.items.Items.module(), 1, this.moduleID), new Object[]{" g ", " b ", Character.valueOf('g'), "ingotCopper", Character.valueOf('p'), emasher.items.Items.psu(), Character.valueOf('b'), emasher.items.Items.blankSide()}));
    }

    @Override
    public boolean hasRSIndicator() {
        return true;
    }

    @Override
    public boolean hasLatchIndicator() {
        return true;
    }

    @Override
    public boolean isEnergyInterface(SideConfig config) {
        return true;
    }

    @Override
    public void updateSide(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        boolean allOff = true;
        for (int i = 0; i < 3; ++i) {
            if (config.rsControl[i]) {
                if (ts.getRSControl(i)) {
                    ts.outputEnergy(1000, side);
                    return;
                }
                allOff = false;
            }
            if (!config.rsLatch[i]) continue;
            if (ts.getRSLatch(i)) {
                ts.outputEnergy(1000, side);
                return;
            }
            allOff = false;
        }
        if (allOff) {
            ts.outputEnergy(1000, side);
        }
    }

    @Override
    public int extractEnergy(int amount, boolean simulate, SideConfig config, SocketTileAccess ts) {
        boolean allOff = true;
        for (int i = 0; i < 3; ++i) {
            if (config.rsControl[i]) {
                if (ts.getRSControl(i)) {
                    return ts.useEnergy(amount, simulate);
                }
                allOff = false;
            }
            if (!config.rsLatch[i]) continue;
            if (ts.getRSLatch(i)) {
                return ts.useEnergy(amount, simulate);
            }
            allOff = false;
        }
        if (allOff) {
            return ts.useEnergy(amount, simulate);
        }
        return 0;
    }
}

