/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.mfr.machines;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.mc164.util.MineTweakerPlatformUtils;
import minetweaker.mods.mfr.MFRHacks;
import net.minecraft.item.ItemStack;
import powercrystals.minefactoryreloaded.api.FactoryRegistry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mfr.Breeder")
@ModOnly(value={"MineFactoryReloaded"})
public class Breeder {
    @ZenMethod
    public static void addFood(String entityClassName, IItemStack item) {
        Class entityClass = MineTweakerPlatformUtils.getLivingEntityClass((String)entityClassName);
        MineTweakerAPI.apply(new BreederAddFoodAction(entityClass, item));
    }

    @ZenMethod
    public static void removeFood(String entityClassName, IIngredient item) {
        Class entityClass = MineTweakerPlatformUtils.getLivingEntityClass((String)entityClassName);
        if (MFRHacks.breederFoods == null) {
            MineTweakerAPI.logWarning("Breeder.removeFood is unavailable");
        } else {
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            List<ItemStack> foods = MFRHacks.breederFoods.get(entityClass);
            for (int i = foods.size() - 1; i >= 0; --i) {
                if (!item.matches(MineTweakerMC.getIItemStack(foods.get(i)))) continue;
                toRemove.add(i);
            }
            Iterator iterator = toRemove.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                MineTweakerAPI.apply(new BreederRemoveFoodAction(entityClass, i));
            }
        }
    }

    private static class BreederRemoveFoodAction
    implements IUndoableAction {
        private final Class<?> entityClass;
        private final int index;
        private final ItemStack item;

        public BreederRemoveFoodAction(Class<?> entityClass, int index) {
            this.entityClass = entityClass;
            this.index = index;
            this.item = MFRHacks.breederFoods.get(entityClass).get(index);
        }

        @Override
        public void apply() {
            MFRHacks.breederFoods.get(this.entityClass).remove(this.index);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            MFRHacks.breederFoods.get(this.entityClass).add(this.index, this.item);
        }

        @Override
        public String describe() {
            return "Removing breeder food " + this.item.func_82833_r() + " for " + this.entityClass.getCanonicalName();
        }

        @Override
        public String describeUndo() {
            return "Restoring breeder food " + this.item.func_82833_r() + " for " + this.entityClass.getCanonicalName();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class BreederAddFoodAction
    implements IUndoableAction {
        private final Class<?> entityClass;
        private final IItemStack item;

        public BreederAddFoodAction(Class<?> entityClass, IItemStack item) {
            this.entityClass = entityClass;
            this.item = item;
        }

        @Override
        public void apply() {
            FactoryRegistry.registerBreederFood(this.entityClass, (ItemStack)MineTweakerMC.getItemStack(this.item));
        }

        @Override
        public boolean canUndo() {
            return MFRHacks.breederFoods != null;
        }

        @Override
        public void undo() {
            List<ItemStack> list = MFRHacks.breederFoods.get(this.entityClass);
            list.remove(list.size() - 1);
        }

        @Override
        public String describe() {
            return "Adding breeder food " + this.item.getDisplayName() + " for " + this.entityClass.getCanonicalName();
        }

        @Override
        public String describeUndo() {
            return "Removing breeder food " + this.item.getDisplayName() + " for " + this.entityClass.getCanonicalName();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }
}

