/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.buildcraft;

import buildcraft.api.recipes.BuildcraftRecipes;
import buildcraft.core.recipes.RefineryRecipeManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.buildcraft.Refinery")
@ModOnly(value={"BuildCraft|Core"})
public class Refinery {
    private static final Constructor CONSTRUCT_REFINERYRECIPE;
    private static final Field REFINERYRECIPEMANAGER_RECIPES;

    @ZenMethod
    public static void addRecipe(ILiquidStack output, int energyPerMB, int ticksPerMB, ILiquidStack input1, @Optional ILiquidStack input2) {
        MineTweakerAPI.apply(new AddRecipeAction(output, energyPerMB, ticksPerMB, input1, input2));
    }

    @ZenMethod
    public static void remove(ILiquidStack output) {
        Fluid fluid = MineTweakerMC.getLiquidStack(output).getFluid();
        ArrayList<RefineryRecipeManager.RefineryRecipe> toRemove = new ArrayList<RefineryRecipeManager.RefineryRecipe>();
        for (RefineryRecipeManager.RefineryRecipe recipe : ((RefineryRecipeManager)BuildcraftRecipes.refinery).getRecipes()) {
            if (recipe.getResult().getFluid() != fluid) continue;
            toRemove.add(recipe);
        }
        for (RefineryRecipeManager.RefineryRecipe recipe : toRemove) {
            MineTweakerAPI.apply(new RemoveRecipeAction(recipe));
        }
    }

    private static SortedSet<RefineryRecipeManager.RefineryRecipe> getRecipes() {
        try {
            return (SortedSet)REFINERYRECIPEMANAGER_RECIPES.get((RefineryRecipeManager)BuildcraftRecipes.refinery);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(Refinery.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Refinery.class.getName()).log(Level.SEVERE, null, ex);
        }
        throw new RuntimeException("Refinery recipes unavailable");
    }

    static {
        Constructor constructor = null;
        try {
            constructor = RefineryRecipeManager.RefineryRecipe.class.getDeclaredConstructor(FluidStack.class, FluidStack.class, FluidStack.class, Integer.TYPE, Integer.TYPE);
            constructor.setAccessible(true);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(Refinery.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(Refinery.class.getName()).log(Level.SEVERE, null, ex);
        }
        Field recipes = null;
        try {
            recipes = RefineryRecipeManager.class.getDeclaredField("recipes");
            recipes.setAccessible(true);
        }
        catch (NoSuchFieldException ex) {
            Logger.getLogger(Refinery.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(Refinery.class.getName()).log(Level.SEVERE, null, ex);
        }
        CONSTRUCT_REFINERYRECIPE = constructor;
        REFINERYRECIPEMANAGER_RECIPES = recipes;
    }

    private static class RemoveRecipeAction
    implements IUndoableAction {
        private final RefineryRecipeManager.RefineryRecipe recipe;

        public RemoveRecipeAction(RefineryRecipeManager.RefineryRecipe recipe) {
            this.recipe = recipe;
        }

        @Override
        public void apply() {
            Refinery.getRecipes().remove(this.recipe);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            Refinery.getRecipes().add(this.recipe);
        }

        @Override
        public String describe() {
            return "Removing refinery recipe for " + this.recipe.getResult().getFluid().getLocalizedName(this.recipe.getResult());
        }

        @Override
        public String describeUndo() {
            return "Restoring refinery recipe for " + this.recipe.getResult().getFluid().getLocalizedName(this.recipe.getResult());
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddRecipeAction
    implements IUndoableAction {
        private final ILiquidStack output;
        private final RefineryRecipeManager.RefineryRecipe recipe;

        public AddRecipeAction(ILiquidStack output, int energyPerMB, int ticksPerMB, ILiquidStack input1, ILiquidStack input2) {
            this.output = output;
            RefineryRecipeManager.RefineryRecipe rrecipe = null;
            try {
                rrecipe = (RefineryRecipeManager.RefineryRecipe)CONSTRUCT_REFINERYRECIPE.newInstance(MineTweakerMC.getLiquidStack(input1), MineTweakerMC.getLiquidStack(input2), MineTweakerMC.getLiquidStack(output), energyPerMB, ticksPerMB);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(Refinery.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(Refinery.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(Refinery.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(Refinery.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.recipe = rrecipe;
        }

        @Override
        public void apply() {
            Refinery.getRecipes().add(this.recipe);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            Refinery.getRecipes().add(this.recipe);
        }

        @Override
        public String describe() {
            return "Adding refinery recipe for " + this.output;
        }

        @Override
        public String describeUndo() {
            return "Removing refinery recipe for " + this.output;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }
}

