/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.buildcraft;

import buildcraft.api.recipes.BuildcraftRecipes;
import buildcraft.core.recipes.AssemblyRecipeManager;
import java.util.ArrayList;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.buildcraft.AssemblyTable")
@ModOnly(value={"BuildCraft|Core"})
public class AssemblyTable {
    @ZenMethod
    public static void addRecipe(IItemStack output, double energy, IIngredient[] ingredients) {
        MineTweakerAPI.apply(new AddRecipeAction(output, energy, ingredients));
    }

    @ZenMethod
    public static void remove(IIngredient output) {
        AssemblyTable.removeRecipe(output, null, false);
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output, @Optional IIngredient[] ingredients, @Optional boolean wildcard) {
        ArrayList<AssemblyRecipeManager.AssemblyRecipe> toRemove = new ArrayList<AssemblyRecipeManager.AssemblyRecipe>();
        for (AssemblyRecipeManager.AssemblyRecipe recipe : ((AssemblyRecipeManager)BuildcraftRecipes.assemblyTable).getRecipes()) {
            if (!output.matches(MineTweakerMC.getIItemStack(recipe.getOutput())) || !AssemblyTable.ingredientsMatch(recipe, ingredients, wildcard)) continue;
            toRemove.add(recipe);
        }
        for (AssemblyRecipeManager.AssemblyRecipe recipe : toRemove) {
            MineTweakerAPI.apply(new RemoveRecipeAction(recipe));
        }
    }

    private static boolean ingredientsMatch(AssemblyRecipeManager.AssemblyRecipe recipe, IIngredient[] ingredients, boolean wildcard) {
        if (ingredients == null) {
            return true;
        }
        int matchedIngredients = 0;
        boolean[] matched = new boolean[ingredients.length];
        block0: for (int i = 0; i < recipe.getInputs().length; ++i) {
            Object ingredientObject = recipe.getInputs()[i];
            if (ingredientObject instanceof Number) continue;
            IIngredient recipeIngredient = MineTweakerMC.getIIngredient(recipe.getInputs()[i]);
            for (int j = 0; j < ingredients.length; ++j) {
                if (matched[j] || !ingredients[j].contains(recipeIngredient)) continue;
                matched[j] = true;
                ++matchedIngredients;
                continue block0;
            }
            if (wildcard) continue;
            return false;
        }
        return matchedIngredients == ingredients.length;
    }

    private static class RemoveRecipeAction
    implements IUndoableAction {
        private final AssemblyRecipeManager.AssemblyRecipe recipe;

        public RemoveRecipeAction(AssemblyRecipeManager.AssemblyRecipe recipe) {
            this.recipe = recipe;
        }

        @Override
        public void apply() {
            BuildcraftRecipes.assemblyTable.getRecipes().remove(this.recipe);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            ((AssemblyRecipeManager)BuildcraftRecipes.assemblyTable).getRecipes().add(this.recipe);
        }

        @Override
        public String describe() {
            return "Removing assembly table recipe for " + MineTweakerMC.getIItemStack(this.recipe.getOutput());
        }

        @Override
        public String describeUndo() {
            return "Restoring assembly table recipe for " + MineTweakerMC.getIItemStack(this.recipe.getOutput());
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddRecipeAction
    implements IUndoableAction {
        private final IItemStack output;
        private final AssemblyRecipeManager.AssemblyRecipe recipe;

        public AddRecipeAction(IItemStack output, double energy, IIngredient[] ingredients) {
            this.output = output;
            Object[] mcIngredients = new Object[ingredients.length];
            for (int i = 0; i < ingredients.length; ++i) {
                mcIngredients[i] = ingredients[i].getInternal();
                if (mcIngredients[i] != null) continue;
                throw new IllegalArgumentException("Not a valid assembly table ingredient");
            }
            this.recipe = new AssemblyRecipeManager.AssemblyRecipe(MineTweakerMC.getItemStack(output), energy, mcIngredients);
        }

        @Override
        public void apply() {
            ((AssemblyRecipeManager)BuildcraftRecipes.assemblyTable).getRecipes().add(this.recipe);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            BuildcraftRecipes.assemblyTable.getRecipes().remove(this.recipe);
        }

        @Override
        public String describe() {
            return "Adding assembly table recipe for " + this.output;
        }

        @Override
        public String describeUndo() {
            return "Removing assembly table recipe for " + this.output;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }
}

