/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IDamagableItem;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.internal.IGT_Mod;
import gregtech.api.interfaces.internal.IGT_RecipeAdder;
import gregtech.api.interfaces.internal.IThaumcraftCompat;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.items.GT_Generic_Item;
import gregtech.api.items.GT_Tool_Item;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.net.IGT_NetworkHandler;
import gregtech.api.objects.GT_Cover_Default;
import gregtech.api.objects.GT_Cover_None;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.threads.GT_Runnable_MachineBlockUpdate;
import gregtech.api.util.GT_CircuitryBehavior;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_CreativeTab;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.api.world.GT_Worldgen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class GregTech_API {
    public static volatile int VERSION = 503;
    public static IGT_Mod gregtech;
    public static IGT_NetworkHandler sNetworkHandler;
    public static IGT_RecipeAdder sRecipeAdder;
    public static IThaumcraftCompat sThaumcraftCompat;
    public static List<Runnable> sBeforeGTPreload;
    public static List<Runnable> sAfterGTPreload;
    public static List<Runnable> sBeforeGTLoad;
    public static List<Runnable> sAfterGTLoad;
    public static List<Runnable> sBeforeGTPostload;
    public static List<Runnable> sAfterGTPostload;
    public static List<Runnable> sBeforeGTServerstart;
    public static List<Runnable> sAfterGTServerstart;
    public static List<Runnable> sBeforeGTServerstop;
    public static List<Runnable> sAfterGTServerstop;
    public static List<Runnable> sGTBlockIconload;
    public static List<Runnable> sGTItemIconload;
    public static List<Map<GT_ItemStack, ?>> sItemStackMappings;
    @SideOnly(value=Side.CLIENT)
    public static IIconRegister sBlockIcons;
    @SideOnly(value=Side.CLIENT)
    public static IIconRegister sItemIcons;
    public static boolean DEBUG_MODE;
    public static boolean SECONDARY_DEBUG_MODE;
    public static boolean UE_ENERGY_COMPATIBILITY;
    public static GT_Config sRecipeFile;
    public static GT_Config sMachineFile;
    public static GT_Config sWorldgenFile;
    public static GT_Config sMaterialProperties;
    public static GT_Config sUnification;
    public static GT_Config sSpecialFile;
    public static GT_Config sClientDataFile;
    public static GT_Config sOPStuff;
    public static final short ITEM_WILDCARD_DAMAGE = Short.MAX_VALUE;
    public static final short MAXIMUM_METATILE_IDS = 32766;
    public static final CreativeTabs TAB_GREGTECH;
    public static final CreativeTabs TAB_GREGTECH_MATERIALS;
    public static final CreativeTabs TAB_GREGTECH_ORES;
    public static int TICKS_FOR_LAG_AVERAGING;
    public static int MILLISECOND_THRESHOLD_UNTIL_LAG_WARNING;
    public static final IMetaTileEntity[] METATILEENTITIES;
    public static final String MOD_ID = "gregtech";
    public static final String TEXTURE_FOLDER = "textures/";
    public static final String TEXTURE_PATH_ITEM = "gregtech:";
    public static final String TEXTURE_PATH_BLOCK = "gregtech:";
    public static final String GUI_PATH = "gregtech:textures/gui/";
    public static final String TC_MOD_ID = "Thaumcraft";
    public static final String RC_MOD_ID = "Railcraft";
    public static final String TE_MOD_ID = "ThermalExpansion";
    public static final String FR_MOD_ID = "Forestry";
    public static final String AE_MOD_ID = "appliedenergistics2";
    public static final String PFAA_MOD_ID = "PFAAGeologica";
    public static final String IC2_MOD_ID = "IC2";
    public static final String IC2_TEXTURE_PATH;
    public static Block sBlockMachines;
    public static Block sBlockOres1;
    public static Block sBlockGranites;
    public static Block sBlockConcretes;
    public static Block sBlockCasings1;
    public static Block sBlockCasings2;
    public static Block sBlockCasings3;
    public static Block sBlockCasings4;
    public static boolean sMultiThreadedSounds;
    public static boolean sDoShowAllItemsInCreative;
    public static boolean sColoredGUI;
    public static boolean sConstantEnergy;
    public static boolean sMachineExplosions;
    public static boolean sMachineFlammable;
    public static boolean sMachineNonWrenchExplosions;
    public static boolean sMachineRainExplosions;
    public static boolean sMachineThunderExplosions;
    public static boolean sMachineFireExplosions;
    public static boolean sMachineWireFire;
    public static boolean sPreloadStarted;
    public static boolean sPreloadFinished;
    public static boolean sLoadStarted;
    public static boolean sLoadFinished;
    public static boolean sPostloadStarted;
    public static boolean sPostloadFinished;
    public static final Map<GT_ItemStack, ITexture> sCovers;
    public static final Map<Integer, GT_CircuitryBehavior> sCircuitryBehaviors;
    public static final Map<GT_ItemStack, GT_CoverBehavior> sCoverBehaviors;
    public static final Map<Block, Integer> sMachineIDs;
    public static final Map<Integer, Byte> sWirelessRedstone;
    public static final Map<Integer, Integer> sIDSUList;
    public static final Map<String, ItemStack> sBookList;
    public static final Map<Integer, String> sSoundList;
    public static final List<GT_ItemStack> sToolList;
    public static final List<GT_ItemStack> sCrowbarList;
    public static final List<GT_ItemStack> sScrewdriverList;
    public static final List<GT_ItemStack> sWrenchList;
    public static final List<GT_ItemStack> sSoftHammerList;
    public static final List<GT_ItemStack> sHardHammerList;
    public static final List<GT_ItemStack> sSolderingToolList;
    public static final List<GT_ItemStack> sSolderingMetalList;
    public static final List<GT_ItemStack> sGasHazmatList;
    public static final List<GT_ItemStack> sBioHazmatList;
    public static final List<GT_ItemStack> sFrostHazmatList;
    public static final List<GT_ItemStack> sHeatHazmatList;
    public static final List<GT_ItemStack> sRadioHazmatList;
    public static final List<GT_ItemStack> sElectroHazmatList;
    public static final List<ItemStack> sCharcoalableWoodenLogs;
    public static final List<Integer> sDimensionalList;
    public static final List<GT_Worldgen> sWorldgenList;
    public static final long VOLTAGE_ULTRALOW = 8L;
    public static final long VOLTAGE_LOW = 32L;
    public static final long VOLTAGE_MEDIUM = 128L;
    public static final long VOLTAGE_HIGH = 512L;
    public static final long VOLTAGE_EXTREME = 2048L;
    public static final long VOLTAGE_INSANE = 8192L;
    public static final long VOLTAGE_LUDICROUS = 32768L;
    public static final long VOLTAGE_ZPM = 131072L;
    public static final long VOLTAGE_ULTIMATE = 524288L;
    public static final long VOLTAGE_MAXIMUM = Integer.MAX_VALUE;
    public static final long[] VOLTAGES;
    public static final Materials[] sGeneratedMaterials;
    public static final long MATERIAL_UNIT = 3628800L;
    public static final long FLUID_MATERIAL_UNIT = 144L;
    public static World sDummyWorld;
    private static Class sBaseMetaTileEntityClass;
    public static final GT_CoverBehavior sDefaultBehavior;
    public static final GT_CoverBehavior sNoBehavior;

    public static ItemStack getGregTechComponent(int aComponentIndex, int aAmount) {
        return null;
    }

    public static ItemStack getUnificatedOreDictStack(ItemStack aOreStack) {
        if (!sPreloadFinished) {
            GT_Log.err.println("GregTech_API ERROR: " + aOreStack.func_77973_b() + "." + aOreStack.func_77960_j() + " - OreDict Unification Entries are not registered now, please call it in the postload phase.");
        }
        return GT_OreDictUnificator.get((boolean)true, (ItemStack)aOreStack);
    }

    public static boolean causeMachineUpdate(World aWorld, int aX, int aY, int aZ) {
        if (!aWorld.field_72995_K) {
            new Thread((Runnable)new GT_Runnable_MachineBlockUpdate(aWorld, aX, aY, aZ), "Machine Block Updating").start();
        }
        return true;
    }

    public static boolean registerMachineBlock(Block aBlock, int aMeta) {
        if (GT_Utility.isBlockInvalid((Object)aBlock)) {
            return false;
        }
        if (sThaumcraftCompat != null) {
            sThaumcraftCompat.registerPortholeBlacklistedBlock(aBlock);
        }
        sMachineIDs.put(aBlock, aMeta);
        return true;
    }

    public static boolean registerMachineBlock(Block aBlock, boolean ... aMeta) {
        if (GT_Utility.isBlockInvalid((Object)aBlock) || aMeta == null || aMeta.length == 0) {
            return false;
        }
        if (sThaumcraftCompat != null) {
            sThaumcraftCompat.registerPortholeBlacklistedBlock(aBlock);
        }
        int rMeta = 0;
        for (int i = 0; i < aMeta.length && i < 16; i = (int)((byte)(i + 1))) {
            if (!aMeta[i]) continue;
            rMeta |= 1 << i;
        }
        sMachineIDs.put(aBlock, rMeta);
        return true;
    }

    public static boolean isMachineBlock(Block aBlock, int aMeta) {
        if (GT_Utility.isBlockInvalid((Object)aBlock)) {
            return false;
        }
        return sMachineIDs.containsKey(aBlock) && (sMachineIDs.get(aBlock) & 1 << aMeta) != 0;
    }

    public static Item constructCoolantCellItem(String aUnlocalized, String aEnglish, int aMaxStore) {
        try {
            return (Item)Class.forName("gregtechmod.api.items.GT_CoolantCellIC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxStore);
        }
        catch (Throwable e) {
            try {
                return (Item)Class.forName("gregtechmod.api.items.GT_CoolantCell_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxStore);
            }
            catch (Throwable throwable) {
                return new GT_Generic_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", false);
            }
        }
    }

    public static Item constructElectricArmorItem(String aUnlocalized, String aEnglish, int aCharge, int aTransfer, int aTier, int aDamageEnergyCost, int aSpecials, double aArmorAbsorbtionPercentage, boolean aChargeProvider, int aType, int aArmorIndex) {
        try {
            return (Item)Class.forName("gregtechmod.api.items.GT_EnergyArmorIC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aCharge, aTransfer, aTier, aDamageEnergyCost, aSpecials, aArmorAbsorbtionPercentage, aChargeProvider, aType, aArmorIndex);
        }
        catch (Throwable e) {
            try {
                return (Item)Class.forName("gregtechmod.api.items.GT_EnergyArmor_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aCharge, aTransfer, aTier, aDamageEnergyCost, aSpecials, aArmorAbsorbtionPercentage, aChargeProvider, aType, aArmorIndex);
            }
            catch (Throwable e2) {
                return new GT_Generic_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", false);
            }
        }
    }

    public static Item constructElectricEnergyStorageItem(String aUnlocalized, String aEnglish, int aCharge, int aTransfer, int aTier, int aEmptyID, int aFullID) {
        try {
            return (Item)Class.forName("gregtechmod.api.items.GT_EnergyStoreIC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aCharge, aTransfer, aTier, aEmptyID, aFullID);
        }
        catch (Throwable e) {
            try {
                return (Item)Class.forName("gregtechmod.api.items.GT_EnergyStore_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aCharge, aTransfer, aTier, aEmptyID, aFullID);
            }
            catch (Throwable e2) {
                return new GT_Generic_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", false);
            }
        }
    }

    public static GT_Tool_Item constructHardHammerItem(String aUnlocalized, String aEnglish, int aMaxDamage, int aEntityDamage) {
        try {
            return (GT_Tool_Item)((Object)Class.forName("gregtechmod.api.items.GT_HardHammer_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aEntityDamage));
        }
        catch (Throwable e) {
            return new GT_Tool_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", aMaxDamage, aEntityDamage, false);
        }
    }

    public static GT_Tool_Item constructCrowbarItem(String aUnlocalized, String aEnglish, int aMaxDamage, int aEntityDamage) {
        try {
            return (GT_Tool_Item)((Object)Class.forName("gregtechmod.api.items.GT_CrowbarRC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aEntityDamage));
        }
        catch (Throwable e) {
            try {
                return (GT_Tool_Item)((Object)Class.forName("gregtechmod.api.items.GT_Crowbar_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aEntityDamage));
            }
            catch (Throwable e2) {
                return new GT_Tool_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", aMaxDamage, aEntityDamage, false);
            }
        }
    }

    public static GT_Tool_Item constructWrenchItem(String aUnlocalized, String aEnglish, int aMaxDamage, int aEntityDamage, int aDisChargedGTID) {
        try {
            return (GT_Tool_Item)((Object)Class.forName("gregtechmod.api.items.GT_Wrench_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aEntityDamage, aDisChargedGTID));
        }
        catch (Throwable e) {
            return new GT_Tool_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", aMaxDamage, aEntityDamage, false);
        }
    }

    public static GT_Tool_Item constructElectricScrewdriverItem(String aUnlocalized, String aEnglish, int aMaxDamage, int aEntityDamage, int aDisChargedGTID) {
        try {
            return (GT_Tool_Item)((Object)Class.forName("gregtechmod.api.items.GT_ScrewdriverIC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aEntityDamage, aDisChargedGTID));
        }
        catch (Throwable e) {
            return new GT_Tool_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", aMaxDamage, aEntityDamage, false);
        }
    }

    public static GT_Tool_Item constructElectricWrenchItem(String aUnlocalized, String aEnglish, int aMaxDamage, int aEntityDamage, int aDisChargedGTID) {
        try {
            return (GT_Tool_Item)((Object)Class.forName("gregtechmod.api.items.GT_WrenchIC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aEntityDamage, aDisChargedGTID));
        }
        catch (Throwable e) {
            return new GT_Tool_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", aMaxDamage, aEntityDamage, false);
        }
    }

    public static GT_Tool_Item constructElectricSawItem(String aUnlocalized, String aEnglish, int aMaxDamage, int aEntityDamage, int aToolQuality, float aToolStrength, int aEnergyConsumptionPerBlockBreak, int aDisChargedGTID) {
        try {
            return (GT_Tool_Item)((Object)Class.forName("gregtechmod.api.items.GT_SawIC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aEntityDamage, aToolQuality, Float.valueOf(aToolStrength), aEnergyConsumptionPerBlockBreak, aDisChargedGTID));
        }
        catch (Throwable e) {
            return new GT_Tool_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", aMaxDamage, aEntityDamage, false);
        }
    }

    public static GT_Tool_Item constructElectricDrillItem(String aUnlocalized, String aEnglish, int aMaxDamage, int aEntityDamage, int aToolQuality, float aToolStrength, int aEnergyConsumptionPerBlockBreak, int aDisChargedGTID) {
        try {
            return (GT_Tool_Item)((Object)Class.forName("gregtechmod.api.items.GT_DrillIC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aEntityDamage, aToolQuality, Float.valueOf(aToolStrength), aEnergyConsumptionPerBlockBreak, aDisChargedGTID));
        }
        catch (Throwable e) {
            return new GT_Tool_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", aMaxDamage, aEntityDamage, false);
        }
    }

    public static GT_Tool_Item constructElectricSolderingToolItem(String aUnlocalized, String aEnglish, int aMaxDamage, int aEntityDamage, int aDisChargedGTID) {
        try {
            return (GT_Tool_Item)((Object)Class.forName("gregtechmod.api.items.GT_SolderingToolIC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aEntityDamage, aDisChargedGTID));
        }
        catch (Throwable e) {
            return new GT_Tool_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", aMaxDamage, aEntityDamage, false);
        }
    }

    public static GT_Tool_Item constructEmptyElectricToolItem(String aUnlocalized, String aEnglish, int aMaxDamage, int aChargedGTID) {
        try {
            return (GT_Tool_Item)((Object)Class.forName("gregtechmod.api.items.GT_EmptyToolIC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aChargedGTID));
        }
        catch (Throwable e) {
            return new GT_Tool_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", aMaxDamage, 0, false);
        }
    }

    public static BaseMetaTileEntity constructBaseMetaTileEntity() {
        if (sBaseMetaTileEntityClass == null) {
            try {
                if (UE_ENERGY_COMPATIBILITY) {
                    sBaseMetaTileEntityClass = Class.forName("gregtechmod.api.metatileentity.BaseMetaTileEntityUE");
                    return (BaseMetaTileEntity)sBaseMetaTileEntityClass.newInstance();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                sBaseMetaTileEntityClass = BaseMetaTileEntity.class;
                return (BaseMetaTileEntity)BaseMetaTileEntity.class.newInstance();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        try {
            return (BaseMetaTileEntity)sBaseMetaTileEntityClass.newInstance();
        }
        catch (Throwable e) {
            GT_Log.err.println("GT_Mod: Fatal Error ocurred while initializing TileEntities, crashing Minecraft.");
            e.printStackTrace(GT_Log.err);
            throw new RuntimeException(e);
        }
    }

    public static void registerCover(ItemStack aStack, ITexture aCover, GT_CoverBehavior aBehavior) {
        if (!sCovers.containsKey(new GT_ItemStack(aStack))) {
            sCovers.put(new GT_ItemStack(aStack), aCover == null || !aCover.isValidTexture() ? Textures.BlockIcons.ERROR_RENDERING[0] : aCover);
        }
        if (aBehavior != null) {
            sCoverBehaviors.put(new GT_ItemStack(aStack), aBehavior);
        }
    }

    public static void registerCoverBehavior(ItemStack aStack, GT_CoverBehavior aBehavior) {
        sCoverBehaviors.put(new GT_ItemStack(aStack), aBehavior == null ? sDefaultBehavior : aBehavior);
    }

    public static void registerCover(Collection<ItemStack> aStackList, ITexture aCover, GT_CoverBehavior aBehavior) {
        if (aCover.isValidTexture()) {
            for (ItemStack tStack : aStackList) {
                GregTech_API.registerCover(tStack, aCover, aBehavior);
            }
        }
    }

    public static GT_CoverBehavior getCoverBehavior(ItemStack aStack) {
        if (aStack == null || aStack.func_77973_b() == null) {
            return sNoBehavior;
        }
        GT_CoverBehavior rCover = sCoverBehaviors.get(new GT_ItemStack(aStack));
        if (rCover == null) {
            return sDefaultBehavior;
        }
        return rCover;
    }

    public static GT_CoverBehavior getCoverBehavior(int aStack) {
        if (aStack == 0) {
            return sNoBehavior;
        }
        return GregTech_API.getCoverBehavior(GT_Utility.intToStack((int)aStack));
    }

    public static boolean registerWrench(ItemStack aTool) {
        return GregTech_API.registerTool(aTool, sWrenchList);
    }

    public static boolean registerCrowbar(ItemStack aTool) {
        return GregTech_API.registerTool(aTool, sCrowbarList);
    }

    public static boolean registerScrewdriver(ItemStack aTool) {
        return GregTech_API.registerTool(aTool, sScrewdriverList);
    }

    public static boolean registerSoftHammer(ItemStack aTool) {
        return GregTech_API.registerTool(aTool, sSoftHammerList);
    }

    public static boolean registerHardHammer(ItemStack aTool) {
        return GregTech_API.registerTool(aTool, sHardHammerList);
    }

    public static boolean registerSolderingTool(ItemStack aTool) {
        return GregTech_API.registerTool(aTool, sSolderingToolList);
    }

    public static boolean registerSolderingMetal(ItemStack aTool) {
        return GregTech_API.registerTool(aTool, sSolderingMetalList);
    }

    public static boolean registerTool(ItemStack aTool, Collection<GT_ItemStack> aToolList) {
        if (aTool == null || sToolList.contains(new GT_ItemStack(aTool)) || !aTool.func_77973_b().func_77645_m() && !GT_ModHandler.isElectricItem((ItemStack)aTool) && !(aTool.func_77973_b() instanceof IDamagableItem)) {
            return false;
        }
        aToolList.add(new GT_ItemStack(GT_Utility.copyAmount((long)1L, (Object[])new Object[]{aTool})));
        sToolList.add(new GT_ItemStack(GT_Utility.copyAmount((long)1L, (Object[])new Object[]{aTool})));
        return true;
    }

    static {
        sBeforeGTPreload = new ArrayList<Runnable>();
        sAfterGTPreload = new ArrayList<Runnable>();
        sBeforeGTLoad = new ArrayList<Runnable>();
        sAfterGTLoad = new ArrayList<Runnable>();
        sBeforeGTPostload = new ArrayList<Runnable>();
        sAfterGTPostload = new ArrayList<Runnable>();
        sBeforeGTServerstart = new ArrayList<Runnable>();
        sAfterGTServerstart = new ArrayList<Runnable>();
        sBeforeGTServerstop = new ArrayList<Runnable>();
        sAfterGTServerstop = new ArrayList<Runnable>();
        sGTBlockIconload = new ArrayList<Runnable>();
        sGTItemIconload = new ArrayList<Runnable>();
        sItemStackMappings = new ArrayList();
        DEBUG_MODE = false;
        SECONDARY_DEBUG_MODE = false;
        UE_ENERGY_COMPATIBILITY = true;
        sRecipeFile = null;
        sMachineFile = null;
        sWorldgenFile = null;
        sMaterialProperties = null;
        sUnification = null;
        sSpecialFile = null;
        sOPStuff = null;
        TAB_GREGTECH = new GT_CreativeTab();
        TAB_GREGTECH_MATERIALS = new GT_CreativeTab();
        TAB_GREGTECH_ORES = new GT_CreativeTab();
        TICKS_FOR_LAG_AVERAGING = 25;
        MILLISECOND_THRESHOLD_UNTIL_LAG_WARNING = 100;
        METATILEENTITIES = new IMetaTileEntity[32766];
        IC2_TEXTURE_PATH = IC2_MOD_ID.toLowerCase() + ":";
        sMultiThreadedSounds = false;
        sDoShowAllItemsInCreative = false;
        sColoredGUI = true;
        sConstantEnergy = true;
        sMachineExplosions = true;
        sMachineFlammable = true;
        sMachineNonWrenchExplosions = true;
        sMachineRainExplosions = true;
        sMachineThunderExplosions = true;
        sMachineFireExplosions = true;
        sMachineWireFire = true;
        sPreloadStarted = false;
        sPreloadFinished = false;
        sLoadStarted = false;
        sLoadFinished = false;
        sPostloadStarted = false;
        sPostloadFinished = false;
        sCovers = new HashMap<GT_ItemStack, ITexture>();
        sCircuitryBehaviors = new HashMap<Integer, GT_CircuitryBehavior>();
        sCoverBehaviors = new HashMap<GT_ItemStack, GT_CoverBehavior>();
        sMachineIDs = new HashMap<Block, Integer>();
        sWirelessRedstone = new HashMap<Integer, Byte>();
        sIDSUList = new HashMap<Integer, Integer>();
        sBookList = new HashMap<String, ItemStack>();
        sSoundList = new HashMap<Integer, String>();
        sToolList = new ArrayList<GT_ItemStack>();
        sCrowbarList = new ArrayList<GT_ItemStack>();
        sScrewdriverList = new ArrayList<GT_ItemStack>();
        sWrenchList = new ArrayList<GT_ItemStack>();
        sSoftHammerList = new ArrayList<GT_ItemStack>();
        sHardHammerList = new ArrayList<GT_ItemStack>();
        sSolderingToolList = new ArrayList<GT_ItemStack>();
        sSolderingMetalList = new ArrayList<GT_ItemStack>();
        sGasHazmatList = new ArrayList<GT_ItemStack>();
        sBioHazmatList = new ArrayList<GT_ItemStack>();
        sFrostHazmatList = new ArrayList<GT_ItemStack>();
        sHeatHazmatList = new ArrayList<GT_ItemStack>();
        sRadioHazmatList = new ArrayList<GT_ItemStack>();
        sElectroHazmatList = new ArrayList<GT_ItemStack>();
        sCharcoalableWoodenLogs = new ArrayList<ItemStack>();
        sDimensionalList = new ArrayList<Integer>();
        sWorldgenList = new ArrayList<GT_Worldgen>();
        VOLTAGES = new long[]{8L, 32L, 128L, 512L, 2048L, 8192L, 32768L, 131072L, 524288L, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE};
        sGeneratedMaterials = new Materials[1000];
        sBaseMetaTileEntityClass = null;
        sDefaultBehavior = new GT_Cover_Default();
        sNoBehavior = new GT_Cover_None();
        sItemStackMappings.add(sCovers);
        sItemStackMappings.add(sCoverBehaviors);
        sDimensionalList.add(-1);
        sDimensionalList.add(0);
        sDimensionalList.add(1);
        sSoundList.put(0, "random.break");
        sSoundList.put(1, "random.anvil_use");
        sSoundList.put(2, "random.anvil_break");
        sSoundList.put(3, "random.click");
        sSoundList.put(4, "random.fizz");
        sSoundList.put(5, "random.explode");
        sSoundList.put(100, IC2_MOD_ID.toLowerCase() + ":" + "tools.Wrench");
        sSoundList.put(101, IC2_MOD_ID.toLowerCase() + ":" + "tools.RubberTrampoline");
        sSoundList.put(102, IC2_MOD_ID.toLowerCase() + ":" + "tools.Painter");
        sSoundList.put(103, IC2_MOD_ID.toLowerCase() + ":" + "tools.BatteryUse");
        sSoundList.put(104, IC2_MOD_ID.toLowerCase() + ":" + "tools.chainsaw.ChainsawUseOne");
        sSoundList.put(105, IC2_MOD_ID.toLowerCase() + ":" + "tools.chainsaw.ChainsawUseTwo");
        sSoundList.put(106, IC2_MOD_ID.toLowerCase() + ":" + "tools.drill.DrillSoft");
        sSoundList.put(107, IC2_MOD_ID.toLowerCase() + ":" + "tools.drill.DrillHard");
        sSoundList.put(108, IC2_MOD_ID.toLowerCase() + ":" + "tools.ODScanner");
        sSoundList.put(200, IC2_MOD_ID.toLowerCase() + ":" + "machines.ExtractorOp");
        sSoundList.put(201, IC2_MOD_ID.toLowerCase() + ":" + "machines.MaceratorOp");
        sSoundList.put(202, IC2_MOD_ID.toLowerCase() + ":" + "machines.InductionLoop");
        sSoundList.put(203, IC2_MOD_ID.toLowerCase() + ":" + "machines.CompressorOp");
        sSoundList.put(204, IC2_MOD_ID.toLowerCase() + ":" + "machines.RecyclerOp");
        sSoundList.put(205, IC2_MOD_ID.toLowerCase() + ":" + "machines.MinerOp");
        sSoundList.put(206, IC2_MOD_ID.toLowerCase() + ":" + "machines.PumpOp");
        sSoundList.put(207, IC2_MOD_ID.toLowerCase() + ":" + "machines.ElectroFurnaceLoop");
        sSoundList.put(208, IC2_MOD_ID.toLowerCase() + ":" + "machines.InductionLoop");
        sSoundList.put(209, IC2_MOD_ID.toLowerCase() + ":" + "machines.MachineOverload");
        sSoundList.put(210, IC2_MOD_ID.toLowerCase() + ":" + "machines.InterruptOne");
        sSoundList.put(211, IC2_MOD_ID.toLowerCase() + ":" + "machines.KaChing");
        sSoundList.put(212, IC2_MOD_ID.toLowerCase() + ":" + "machines.MagnetizerLoop");
    }
}

