/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.minetweaker;

import blusunrize.immersiveengineering.api.energy.DieselHandler;
import blusunrize.immersiveengineering.common.util.compat.minetweaker.MTHelper;
import java.util.ArrayList;
import java.util.Iterator;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveengineering.Squeezer")
public class Squeezer {
    @ZenMethod
    public static void addRecipe(IItemStack output, ILiquidStack fluid, IIngredient input, int time) {
        if (MTHelper.toObject(input) == null) {
            return;
        }
        if (MTHelper.toStack(output) == null && (MTHelper.toFluidStack(fluid) == null || MTHelper.toFluidStack(fluid).getFluid() == null)) {
            return;
        }
        DieselHandler.SqueezerRecipe r = new DieselHandler.SqueezerRecipe(MTHelper.toObject(input), time, MTHelper.toFluidStack(fluid), MTHelper.toStack(output));
        MineTweakerAPI.apply((IUndoableAction)new Add(r));
    }

    @ZenMethod
    public static void removeFluidRecipe(ILiquidStack fluid) {
        if (MTHelper.toFluidStack(fluid) != null) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveFluid(MTHelper.toFluidStack(fluid)));
        }
    }

    @ZenMethod
    public static void removeItemStack(IItemStack stack) {
        if (MTHelper.toStack(stack) != null) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveStack(MTHelper.toStack(stack)));
        }
    }

    private static class RemoveStack
    implements IUndoableAction {
        private final ItemStack output;
        ArrayList<DieselHandler.SqueezerRecipe> removedRecipes = new ArrayList();

        public RemoveStack(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            Iterator<DieselHandler.SqueezerRecipe> it = DieselHandler.squeezerList.iterator();
            while (it.hasNext()) {
                DieselHandler.SqueezerRecipe r = it.next();
                if (!OreDictionary.itemMatches((ItemStack)this.output, (ItemStack)r.output, (boolean)false)) continue;
                this.removedRecipes.add(r);
                it.remove();
            }
        }

        public void undo() {
            if (this.removedRecipes != null) {
                for (DieselHandler.SqueezerRecipe recipe : this.removedRecipes) {
                    if (recipe == null) continue;
                    DieselHandler.squeezerList.add(recipe);
                }
            }
        }

        public String describe() {
            return "Removing Squeezer Recipes for ItemStack " + this.output.func_82833_r();
        }

        public String describeUndo() {
            return "Re-Adding Squeezer Recipes for ItemStack " + this.output.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }

    private static class RemoveFluid
    implements IUndoableAction {
        private final FluidStack output;
        ArrayList<DieselHandler.SqueezerRecipe> removedRecipes = new ArrayList();

        public RemoveFluid(FluidStack output) {
            this.output = output;
        }

        public void apply() {
            Iterator<DieselHandler.SqueezerRecipe> it = DieselHandler.squeezerList.iterator();
            while (it.hasNext()) {
                DieselHandler.SqueezerRecipe r = it.next();
                if (!r.fluid.isFluidEqual(this.output)) continue;
                this.removedRecipes.add(r);
                it.remove();
            }
        }

        public void undo() {
            if (this.removedRecipes != null) {
                for (DieselHandler.SqueezerRecipe recipe : this.removedRecipes) {
                    if (recipe == null) continue;
                    DieselHandler.squeezerList.add(recipe);
                }
            }
        }

        public String describe() {
            return "Removing Squeezer Recipes for Fluid " + this.output.getLocalizedName();
        }

        public String describeUndo() {
            return "Re-Adding Squeezer Recipes for Fluid " + this.output.getLocalizedName();
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }

    private static class Add
    implements IUndoableAction {
        private final DieselHandler.SqueezerRecipe recipe;

        public Add(DieselHandler.SqueezerRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            DieselHandler.squeezerList.add(this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            DieselHandler.squeezerList.remove(this.recipe);
        }

        public String describe() {
            String fluid = this.recipe.fluid != null ? this.recipe.fluid.getLocalizedName() : "null";
            String out = this.recipe.output != null ? this.recipe.output.func_82833_r() : "null";
            return "Adding Squeezer Recipe for Fluid " + fluid + " and Item " + out;
        }

        public String describeUndo() {
            String fluid = this.recipe.fluid != null ? this.recipe.fluid.getLocalizedName() : "null";
            String out = this.recipe.output != null ? this.recipe.output.func_82833_r() : "null";
            return "Removing Squeezer Recipe for Fluid " + fluid + " and Item " + out;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

