/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemIETool
extends ItemIEBase {
    public ItemIETool() {
        super("tool", 1, "hammer", "wirecutter", "voltmeter", "manual");
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        int[] link;
        if (ItemNBTHelper.hasKey(stack, "linkingPos") && (link = ItemNBTHelper.getIntArray(stack, "linkingPos")) != null && link.length > 3) {
            list.add(StatCollector.func_74837_a((String)"desc.ImmersiveEngineering.info.attachedToDim", (Object[])new Object[]{link[1], link[2], link[3], link[0]}));
        }
    }

    public boolean hasContainerItem(ItemStack stack) {
        return stack.func_77960_j() == 0;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return stack.func_77960_j() == 0 ? stack : null;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (stack.func_77960_j() == 0) {
                for (MultiblockHandler.IMultiblock mb : MultiblockHandler.getMultiblocks()) {
                    if (!mb.isBlockTrigger(world.func_147439_a(x, y, z), world.func_72805_g(x, y, z)) || !mb.createStructure(world, x, y, z, side, player)) continue;
                    return true;
                }
            } else {
                if (stack.func_77960_j() == 1 && world.func_147438_o(x, y, z) instanceof IImmersiveConnectable) {
                    IImmersiveConnectable nodeHere = (IImmersiveConnectable)world.func_147438_o(x, y, z);
                    ImmersiveNetHandler.INSTANCE.clearAllConnectionsFor(Utils.toCC(nodeHere), world, new TargetingInfo(side, hitX, hitY, hitZ));
                    IESaveData.setDirty(world.field_73011_w.field_76574_g);
                    return true;
                }
                if (stack.func_77960_j() == 2) {
                    if (!player.func_70093_af() && (world.func_147438_o(x, y, z) instanceof IEnergyReceiver || world.func_147438_o(x, y, z) instanceof IEnergyProvider)) {
                        int max = 0;
                        int stored = 0;
                        if (world.func_147438_o(x, y, z) instanceof IEnergyReceiver) {
                            max = ((IEnergyReceiver)world.func_147438_o(x, y, z)).getMaxEnergyStored(ForgeDirection.getOrientation((int)side));
                            stored = ((IEnergyReceiver)world.func_147438_o(x, y, z)).getEnergyStored(ForgeDirection.getOrientation((int)side));
                        } else if (world.func_147438_o(x, y, z) instanceof IEnergyProvider) {
                            max = ((IEnergyProvider)world.func_147438_o(x, y, z)).getMaxEnergyStored(ForgeDirection.getOrientation((int)side));
                            stored = ((IEnergyProvider)world.func_147438_o(x, y, z)).getEnergyStored(ForgeDirection.getOrientation((int)side));
                        }
                        if (max > 0) {
                            player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.info.energyStorage", new Object[]{stored, max}));
                        }
                    }
                    if (player.func_70093_af() && world.func_147438_o(x, y, z) instanceof IImmersiveConnectable) {
                        if (!ItemNBTHelper.hasKey(stack, "linkingPos")) {
                            ItemNBTHelper.setIntArray(stack, "linkingPos", new int[]{world.field_73011_w.field_76574_g, x, y, z});
                        } else {
                            int[] pos = ItemNBTHelper.getIntArray(stack, "linkingPos");
                            if (pos[0] == world.field_73011_w.field_76574_g) {
                                IImmersiveConnectable nodeHere = (IImmersiveConnectable)world.func_147438_o(x, y, z);
                                IImmersiveConnectable nodeLink = (IImmersiveConnectable)world.func_147438_o(pos[1], pos[2], pos[3]);
                                if (nodeHere != null && nodeLink != null) {
                                    List<ImmersiveNetHandler.AbstractConnection> connections = ImmersiveNetHandler.INSTANCE.getIndirectEnergyConnections(Utils.toCC(nodeLink), world);
                                    for (ImmersiveNetHandler.AbstractConnection con : connections) {
                                        if (!Utils.toCC(nodeHere).equals((Object)con.end)) continue;
                                        player.func_146105_b((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.info.averageLoss", new Object[]{Utils.formatDouble(con.getAverageLossRate() * 100.0f, "###.000")}));
                                    }
                                }
                            }
                            ItemNBTHelper.remove(stack, "linkingPos");
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        if (player.func_71045_bC() != null && ((Object)((Object)this)).equals(player.func_71045_bC().func_77973_b())) {
            return player.func_71045_bC().func_77960_j() == 0;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K && stack.func_77960_j() == 3) {
            player.openGui((Object)ImmersiveEngineering.instance, 3, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return stack;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (this.getToolClasses(stack).contains(toolClass)) {
            return 2;
        }
        return -1;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        int meta = stack.func_77960_j();
        return (Set)(meta == 0 ? ImmutableSet.of((Object)"IE_HAMMER") : (meta == 1 ? ImmutableSet.of((Object)"IE_WIRECUTTER") : new HashSet()));
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta)) {
            return 6.0f;
        }
        return super.getDigSpeed(stack, block, meta);
    }
}

