/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.debug;

import com.rwtema.debug.ClientSafe;
import com.rwtema.denseores.LogHelper;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;

public class SideOnlyCheckerTransformer
implements IClassTransformer {
    public static Logger logger = LogManager.getLogger((String)"SideOnlyChecker");
    public static LaunchClassLoader classLoader = (LaunchClassLoader)SideOnlyCheckerTransformer.class.getClassLoader();
    private static final String clientSafeName = Type.getDescriptor(ClientSafe.class);
    private static String curClass;
    private static String curMethod;
    private static String curType;
    private static String curFile;
    private static final List<String> warnings;
    private static final List<String> errors;
    public static String filter;

    public static void register(String packageName) {
        if (!SideOnlyCheckerTransformer.isDevEnviroment() || FMLLaunchHandler.side() != Side.CLIENT) {
            return;
        }
        filter = packageName;
        ClassInfo.init();
        classLoader.registerTransformer(SideOnlyCheckerTransformer.class.getName());
    }

    public byte[] transform(String s, String s2, byte[] bytes) {
        if (bytes == null || filter == null || !s.startsWith(filter) || s.startsWith("net.minecraft.")) {
            return bytes;
        }
        ClassNode classNode = new ClassNode();
        ClassReader reader = new ClassReader(bytes);
        reader.accept((ClassVisitor)classNode, 0);
        curClass = s;
        curFile = classNode.sourceFile;
        curType = classNode.name;
        curMethod = "";
        ClassInfo.registerClass(s, bytes);
        if (SideOnlyCheckerTransformer.hasClientAnnotation(classNode.visibleAnnotations)) {
            return bytes;
        }
        if (classNode.superName != null && ClassInfo.isClientClass(classNode.superName)) {
            logger.info("----------------------------------------------------------------");
            logger.info("Error: Class " + s + " extends client-side class " + classNode.superName + " but does not include annotation");
            logger.info(SideOnlyCheckerTransformer.log("Class: " + s, "class", 1));
            logger.info("----------------------------------------------------------------");
            return bytes;
        }
        for (String string : classNode.interfaces) {
            if (!ClassInfo.isClientClass(string)) continue;
            logger.info("----------------------------------------------------------------");
            logger.info("Error: Class " + s + " extends client-side class " + classNode.superName + " but does not include annotation");
            logger.info(SideOnlyCheckerTransformer.log("Class: " + s, "class", 1));
            logger.info("----------------------------------------------------------------");
            return bytes;
        }
        for (MethodNode methodNode : classNode.methods) {
            curMethod = methodNode.name;
            if (!SideOnlyCheckerTransformer.shouldProcess(methodNode.visibleAnnotations)) continue;
            if (ClassInfo.hasClientMethod(classNode.superName, methodNode.name, methodNode.desc)) {
                int line = -1;
                for (AbstractInsnNode instruction : methodNode.instructions.toArray()) {
                    if (instruction.getType() != 15) continue;
                    line = ((LineNumberNode)instruction).line;
                    break;
                }
                warnings.add(SideOnlyCheckerTransformer.log("Method: ", methodNode.name, line));
            }
            methodNode.accept((MethodVisitor)ClientCheckerMethodVisitor.instance);
        }
        for (FieldNode fieldNode : classNode.fields) {
            if (SideOnlyCheckerTransformer.hasClientAnnotation(fieldNode.visibleAnnotations) || !fieldNode.desc.startsWith("L") || !ClassInfo.isClientClass(SideOnlyCheckerTransformer.stripToType(fieldNode.desc))) continue;
            errors.add(SideOnlyCheckerTransformer.log("Field Type: ", fieldNode.desc, 1));
        }
        if (!warnings.isEmpty() || !errors.isEmpty()) {
            logger.info("----------------------------------------------------------------");
            if (!warnings.isEmpty()) {
                logger.info("Warning: Class " + s + " overrides client-side methods and does not include the SideOnly annotation");
                logger.info("Include the @ClientSafe annotation if this is intentional");
                for (String string : warnings) {
                    logger.info(string);
                }
                warnings.clear();
            }
            if (!errors.isEmpty()) {
                logger.info("Error: Class " + s + " has references to client-side code in non-client-side fields/methods");
                logger.info("Include the @ClientSafe annotation if you have ensured the code is unreachable");
                for (String string : errors) {
                    logger.info(string);
                }
                errors.clear();
            }
            logger.info("----------------------------------------------------------------");
        }
        return bytes;
    }

    public static String log(String info, String method, int line) {
        return "\t" + info + "\tat " + new StackTraceElement(curClass, method, curFile, line).toString();
    }

    public static boolean shouldProcess(List<AnnotationNode> anns) {
        if (SideOnlyCheckerTransformer.hasClientSafeAnnotation(anns)) {
            if ("net.minecraft.block.Block".equals(curClass) && "getRenderType".equals(curMethod)) {
                errors.add("\tIn the interest of sanity, @ClientSafe is disabled for getRenderType().");
                errors.add("\tgetRenderType() is a server-side method used by the server to get details about block structure.");
                errors.add("\tUse your SidedProxies to ensure this works properly.");
                errors.add("\tOr you will be eaten by venemous spiders.");
                return true;
            }
            return false;
        }
        return !SideOnlyCheckerTransformer.hasClientAnnotation(anns);
    }

    private static boolean hasClientSafeAnnotation(List<AnnotationNode> anns) {
        if (anns == null) {
            return false;
        }
        for (AnnotationNode ann : anns) {
            if (!ann.desc.equals(clientSafeName)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasClientAnnotation(List<AnnotationNode> anns) {
        if (anns == null) {
            return false;
        }
        for (AnnotationNode ann : anns) {
            if (!ann.desc.equals(Type.getDescriptor(SideOnly.class)) || ann.values == null) continue;
            for (int x = 0; x < ann.values.size() - 1; x += 2) {
                Object key = ann.values.get(x);
                Object value = ann.values.get(x + 1);
                if (!(key instanceof String) || !key.equals("value") || !(value instanceof String[]) || !((String[])value)[1].equals(Side.CLIENT.name())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isDevEnviroment() {
        return LogHelper.isDeObf;
    }

    private static String stripToType(String desc) {
        String type = desc.endsWith(";") ? desc.substring(1, desc.length() - 1) : desc.substring(1);
        return type;
    }

    static {
        warnings = new ArrayList<String>();
        errors = new ArrayList<String>();
        filter = null;
    }

    public static class ClassInfo {
        public static HashMap<String, ClassInfo> cached = new HashMap();
        public static ClassInfo blankClass = new ClassInfo();
        HashMap<String, Boolean> methods = new HashMap();
        HashMap<String, Boolean> fields = new HashMap();
        boolean isClient = false;

        public static String toTypeName(String s) {
            return s.replace('.', '/');
        }

        public static boolean hasClientMethod(String owner, String name, String desc) {
            ClassInfo classInfo = ClassInfo.getClassInfo(owner);
            return classInfo.hasClientMethod(name, desc);
        }

        public static void init() {
            cached.put("java/lang/Object", new ClassInfo());
        }

        public static boolean isClientClass(String clazz) {
            return ClassInfo.getClassInfo((String)clazz).isClient;
        }

        public static boolean hasClientField(String owner, String name) {
            return ClassInfo.getClassInfo(owner).isClientField(name);
        }

        private boolean hasClientMethod(String name, String desc) {
            return this.isClient || this.getSafe(this.methods, name);
        }

        private boolean getSafe(HashMap<String, Boolean> list, String key) {
            Boolean result = list.get(key);
            return result == null ? false : result;
        }

        private boolean isClientField(String name) {
            return this.isClient || this.getSafe(this.fields, name);
        }

        public static ClassInfo getClassInfo(String className) {
            if (className.startsWith("java/") || className.startsWith("io/")) {
                return blankClass;
            }
            if (cached.containsKey(className)) {
                return cached.get(className);
            }
            ClassInfo value = new ClassInfo(className);
            cached.put(className, value);
            return value;
        }

        private ClassInfo(String className) {
            this(ClassInfo.getBytes(className));
        }

        private ClassInfo() {
        }

        private static byte[] getBytes(String className) {
            byte[] bytes;
            try {
                String properName = className.replace('/', '.');
                bytes = classLoader.getClassBytes(properName);
            }
            catch (IOException e) {
                return null;
            }
            return bytes;
        }

        private ClassInfo(byte[] bytes) {
            if (bytes == null) {
                return;
            }
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(bytes);
            classReader.accept((ClassVisitor)classNode, 0);
            this.isClient = SideOnlyCheckerTransformer.hasClientAnnotation(classNode.visibleAnnotations);
            if (this.isClient) {
                return;
            }
            for (MethodNode method : classNode.methods) {
                this.methods.put(method.name, SideOnlyCheckerTransformer.hasClientAnnotation(method.visibleAnnotations));
            }
            for (FieldNode field : classNode.fields) {
                this.fields.put(field.name, SideOnlyCheckerTransformer.hasClientAnnotation(field.visibleAnnotations));
            }
            if (classNode.superName != null && !classNode.superName.startsWith("java/")) {
                this.join(ClassInfo.getClassInfo(classNode.superName));
            }
            for (String iface : classNode.interfaces) {
                this.join(ClassInfo.getClassInfo(iface));
            }
        }

        public void join(ClassInfo info) {
            if (this.isClient || info.isClient) {
                this.isClient = true;
                return;
            }
            this.merge(this.fields, info.fields);
            this.merge(this.methods, info.methods);
        }

        public void merge(Map a, Map b) {
            for (Object key : b.keySet()) {
                if (a.containsKey(key)) continue;
                a.put(key, b.get(key));
            }
        }

        public static void registerClass(String s, byte[] bytes) {
            s = s.replace('.', '/');
            cached.put(s, new ClassInfo(bytes));
        }
    }

    public static class ClientCheckerMethodVisitor
    extends MethodVisitor {
        public static ClientCheckerMethodVisitor instance = new ClientCheckerMethodVisitor();
        int line;

        public ClientCheckerMethodVisitor() {
            super(262144);
        }

        public void visitCode() {
            this.line = -1;
        }

        public void visitLineNumber(int line, Label start) {
            this.line = line;
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            if (name == null || "this".equals(name) || desc == null || !desc.startsWith("L")) {
                return;
            }
            String type = SideOnlyCheckerTransformer.stripToType(desc);
            if (ClassInfo.isClientClass(type)) {
                errors.add(SideOnlyCheckerTransformer.log("Local Variable: " + name, curMethod, this.line));
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (ClassInfo.hasClientMethod(owner, name, desc)) {
                errors.add(SideOnlyCheckerTransformer.log("Method Reference: " + name, curMethod, this.line));
            }
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (ClassInfo.hasClientField(owner, name)) {
                errors.add(SideOnlyCheckerTransformer.log("Field Reference: " + name, curMethod, this.line));
            }
        }

        public void visitTypeInsn(int opcode, String type) {
            if (ClassInfo.isClientClass(Type.getType((String)type).getInternalName())) {
                errors.add(SideOnlyCheckerTransformer.log("Type Reference: " + type, curMethod, this.line));
            }
        }
    }
}

