/*
 * Decompiled with CFR 0.152.
 */
package io.github.alex_hawks.SanguineExtras.common.sigil_utils;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import io.github.alex_hawks.SanguineExtras.common.SanguineExtras;
import io.github.alex_hawks.SanguineExtras.common.util.BloodUtils;
import io.github.alex_hawks.SanguineExtras.common.util.PlayerUtils;
import io.github.alex_hawks.util.Vector3;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;

public class UtilsRebuilding {
    public static List<Vector3> find(int x, int y, int z, World world) {
        Block b;
        ArrayList<Vector3> solidBlocks = new ArrayList<Vector3>();
        ArrayList<Vector3> airBlocks = new ArrayList<Vector3>();
        ArrayList<Vector3> currentSolidBlocks = new ArrayList<Vector3>();
        ArrayList<Vector3> currentairBlocks = new ArrayList<Vector3>();
        ArrayList<Vector3> toReturn = new ArrayList<Vector3>();
        Block original = world.func_147439_a(x, y, z);
        solidBlocks.add(new Vector3(x, y, z));
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            b = world.func_147439_a(x + d.offsetX, y + d.offsetY, z + d.offsetZ);
            if (b.func_149747_d((IBlockAccess)world, x, y, z, world.func_72805_g(x, y, z)) || b.equals(original)) continue;
            airBlocks.add(new Vector3(x + d.offsetX, y + d.offsetY, z + d.offsetZ));
        }
        for (int i = 0; i < SanguineExtras.pathfindIterations; ++i) {
            currentSolidBlocks.clear();
            currentSolidBlocks.addAll(solidBlocks);
            currentairBlocks.clear();
            currentairBlocks.addAll(airBlocks);
            for (Vector3 v : currentSolidBlocks) {
                for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                    b = world.func_147439_a(v.x() + d.offsetX, v.y() + d.offsetY, v.z() + d.offsetZ);
                    if (b.func_149747_d((IBlockAccess)world, x, y, z, world.func_72805_g(x, y, z)) && b.equals(original)) {
                        solidBlocks.add(new Vector3(v.x() + d.offsetX, v.y() + d.offsetY, v.z() + d.offsetZ));
                        continue;
                    }
                    airBlocks.add(new Vector3(v.x() + d.offsetX, v.y() + d.offsetY, v.z() + d.offsetZ));
                }
            }
            for (Vector3 v : currentairBlocks) {
                for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                    b = world.func_147439_a(v.x() + d.offsetX, v.y() + d.offsetY, v.z() + d.offsetZ);
                    if (b.func_149747_d((IBlockAccess)world, x, y, z, world.func_72805_g(x, y, z)) || b.equals(original)) continue;
                    airBlocks.add(new Vector3(v.x() + d.offsetX, v.y() + d.offsetY, v.z() + d.offsetZ));
                }
            }
        }
        block6: for (Vector3 v : currentSolidBlocks) {
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                for (Vector3 air : airBlocks) {
                    Vector3 vec3;
                    if (!air.equals(vec3 = new Vector3(v.x() + d.offsetX, v.y() + d.offsetY, v.z() + d.offsetZ))) continue;
                    toReturn.add(v);
                    continue block6;
                }
            }
        }
        return toReturn;
    }

    public static List<Vector3> find(Vector3 coords, World w) {
        return UtilsRebuilding.find(coords.x(), coords.y(), coords.z(), w);
    }

    public static void doReplace(EntityPlayer player, String sigilOwner, List<Vector3> list, World w, Block oldBlock, int oldMeta, Block newBlock, int newMeta) {
        UtilsRebuilding.doReplace(player, sigilOwner, list.toArray(new Vector3[0]), w, oldBlock, oldMeta, newBlock, newMeta);
    }

    public static void doReplace(EntityPlayer player, String sigilOwner, Vector3[] list, World w, Block oldBlock, int oldMeta, Block newBlock, int newMeta) {
        for (Vector3 v : list) {
            if (!w.func_147439_a(v.x(), v.y(), v.z()).equals(oldBlock) || w.func_72805_g(v.x(), v.y(), v.z()) != oldMeta) continue;
            BlockEvent.BreakEvent e = new BlockEvent.BreakEvent(v.x(), v.y(), v.z(), w, oldBlock, oldMeta, player);
            BlockSnapshot s = new BlockSnapshot(w, v.x(), v.y(), v.z(), newBlock, newMeta);
            BlockEvent.PlaceEvent e2 = new BlockEvent.PlaceEvent(s, null, player);
            if (FMLCommonHandler.instance().bus().post((Event)e) || FMLCommonHandler.instance().bus().post((Event)e2)) continue;
            if (!BloodUtils.drainSoulNetwork(sigilOwner, SanguineExtras.rebuildSigilCost) || !PlayerUtils.takeItem(player, new ItemStack(newBlock, 1, newMeta))) break;
            PlayerUtils.putItem(player, oldBlock.getDrops(w, v.x(), v.y(), v.z(), oldMeta, 0).toArray(new ItemStack[0]));
            w.func_147465_d(v.x(), v.y(), v.z(), newBlock, newMeta, 3);
            if (e.getExpToDrop() <= 0) continue;
            w.func_72838_d((Entity)new EntityXPOrb(w, player.field_70165_t, player.field_70163_u, player.field_70161_v, e.getExpToDrop()));
        }
    }
}

