/*
 * Decompiled with CFR 0.152.
 */
package io.github.alex_hawks.SanguineExtras.common;

import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.rituals.Rituals;
import WayofTime.alchemicalWizardry.common.entity.projectile.EnergyBlastProjectile;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import io.github.alex_hawks.SanguineExtras.api.sigil.IPushCondition;
import io.github.alex_hawks.SanguineExtras.api.sigil.Interdiction;
import io.github.alex_hawks.SanguineExtras.common.CommonProxy;
import io.github.alex_hawks.SanguineExtras.common.ModBlocks;
import io.github.alex_hawks.SanguineExtras.common.ModItems;
import io.github.alex_hawks.SanguineExtras.common.Recipe;
import io.github.alex_hawks.SanguineExtras.common.multipart.PartFactory;
import io.github.alex_hawks.SanguineExtras.common.network.chat_handler.HandlerDisplayChat;
import io.github.alex_hawks.SanguineExtras.common.network.chat_handler.MsgDisplayChat;
import io.github.alex_hawks.SanguineExtras.common.network.entity_motion.HandlerEntityMotion;
import io.github.alex_hawks.SanguineExtras.common.network.entity_motion.MsgEntityMotion;
import io.github.alex_hawks.SanguineExtras.common.ritual_stones.marker.warded.WRSHandler;
import io.github.alex_hawks.SanguineExtras.common.ritual_stones.master.advanced.AMRSHandler;
import io.github.alex_hawks.SanguineExtras.common.ritual_stones.master.warded.WMRSHandler;
import io.github.alex_hawks.SanguineExtras.common.rituals.basic.Spawn;
import io.github.alex_hawks.SanguineExtras.common.sigil_utils.interdiction.PushHandlerEnergyBlastProjectile;
import io.github.alex_hawks.SanguineExtras.common.sigil_utils.interdiction.PushHandlerTamable;
import net.minecraft.entity.IEntityOwnable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;

@Mod(dependencies="after:AWWayofTime", modid="SanguineExtras", name="Sanguine Utilities", useMetadata=false, modLanguage="java")
public class SanguineExtras {
    public static SimpleNetworkWrapper networkWrapper;
    @SidedProxy(clientSide="io.github.alex_hawks.SanguineExtras.client.ClientProxy", serverSide="io.github.alex_hawks.SanguineExtras.common.CommonProxy", modId="SanguineExtras")
    public static CommonProxy proxy;
    @Mod.Instance(value="SanguineExtras")
    public static SanguineExtras INSTANCE;
    private static Configuration config;
    public static int pathfindIterations;
    public static int rebuildSigilCost;
    public static boolean trappableBossMobs;
    public static boolean spawnableBossMobs;
    public static int spawnLpPerHealth;
    public static int spawnMaxEntities;
    public static float interdictionRange;
    public static boolean opsCanBreakWardedBlocks;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent e) {
        config = new Configuration(e.getSuggestedConfigurationFile());
        SanguineExtras.readConfig();
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent e) {
        ModItems.initItems();
        ModBlocks.initBlocks();
        Rituals.registerRitual((String)"SE001Spawner", (int)1, (int)250000, (RitualEffect)new Spawn(), (String)"Ritual of Re-creation");
        MinecraftForge.EVENT_BUS.register((Object)new AMRSHandler());
        MinecraftForge.EVENT_BUS.register((Object)new WMRSHandler());
        MinecraftForge.EVENT_BUS.register((Object)new WRSHandler());
        networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("SanguineExtras");
        networkWrapper.registerMessage(HandlerDisplayChat.class, MsgDisplayChat.class, 0, Side.CLIENT);
        networkWrapper.registerMessage(HandlerEntityMotion.class, MsgEntityMotion.class, 1, Side.CLIENT);
        if (Loader.isModLoaded((String)"ForgeMultipart")) {
            new PartFactory().init();
        }
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent e) {
        Interdiction.addToPushConditional(IEntityOwnable.class, (IPushCondition)new PushHandlerTamable());
        Interdiction.addToPushConditional(EnergyBlastProjectile.class, (IPushCondition)new PushHandlerEnergyBlastProjectile());
        Recipe.register();
        proxy.registerClientStuff();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)proxy);
    }

    public static void readConfig() {
        config.load();
        SanguineExtras.readConfig(config);
    }

    public static void readConfig(Configuration config2) {
        pathfindIterations = config2.getInt("Sigil Of Rebuilding pathfinding iterations", "general", 5, 1, 50, "The number of times that the sigil will iterate when used to replace more than one block at a time. Beware: this can add up quickly...");
        rebuildSigilCost = config2.getInt("Sigil Of Rebuilding LP Cost", "general", 25, 0, Integer.MAX_VALUE, "The LP cost of replacing one block using the Sigil Of Rebuilding");
        trappableBossMobs = config2.getBoolean("Trappable Boss Mobs", "general", true, "Set to \"true\" if you want to be able to trap boss mobs at 10 times the LP cost");
        spawnableBossMobs = config2.getBoolean("Spawnable Boss Mobs", "general", false, "Set to \"true\" if you want to be able to spawn boss mobs at 10 times the LP cost");
        spawnLpPerHealth = config2.getInt("Base Spawner LP Cost Per Health", "general", 150, 118, 15000, "This is the lowest that the cost can go. If you don't use reagents, it drains double to spawn one mob, and this is per half heart that the mob has at max, plus what health it is missing as well");
        spawnMaxEntities = config2.getInt("Max Entities in Spawner", "general", 20, 1, 50, "The maximum number of entities inside the spawner's area of effect, before it gives up on spawning more. It only counts what it is currenly spawning. Divide by 10 if the mob in question is a boss");
        interdictionRange = config2.getFloat("Interdiction Range", "general", 5.0f, 0.5f, 10.0f, "Entities will be pushed away from you if they are closer than this many blocks, calculated using pythagorean theorem");
        opsCanBreakWardedBlocks = config2.getBoolean("Ops can break warded blocks", "general", false, "set this to true if you want ops to be able to break the warded blocks when most others can't.");
        if (config2.hasChanged()) {
            config2.save();
        }
    }
}

