/*
 * Decompiled with CFR 0.152.
 */
package io.github.alex_hawks.SanguineExtras.api.sigil;

import io.github.alex_hawks.SanguineExtras.api.sigil.IPushCondition;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;

public class Interdiction {
    private static final Set<Class<?>> pushDeny = new LinkedHashSet();
    private static final Set<Class<?>> pushAllow = new LinkedHashSet();
    private static final Map<Class<?>, IPushCondition> pushConditional = new HashMap();

    public static void addToPushAllow(Class<?> ent) {
        pushAllow.add(ent);
    }

    public static void addToPushConditional(Class<?> ent, IPushCondition handler) {
        pushConditional.put(ent, handler);
    }

    public static void addToPushDeny(Class<?> ent) {
        pushDeny.add(ent);
    }

    public static void addToPushAllow(String name) {
        try {
            Interdiction.addToPushAllow(Class.forName(name));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void addToPushConditional(String name, IPushCondition handler) {
        try {
            Interdiction.addToPushConditional(Class.forName(name), handler);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void addToPushDeny(String name) {
        try {
            Interdiction.addToPushAllow(Class.forName(name));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static boolean isPushAllowed(Entity e, EntityPlayer pushedBy) {
        if (pushDeny.contains(e.getClass())) {
            return false;
        }
        for (Class<?> clazz : pushDeny) {
            if (!clazz.isInstance(e)) continue;
            pushDeny.add(e.getClass());
            return false;
        }
        boolean allowCondition = true;
        boolean handlerExists = false;
        for (Class<?> clazz : pushConditional.keySet()) {
            if (!clazz.isInstance(e)) continue;
            allowCondition &= pushConditional.get(clazz).canPush(e, pushedBy);
            handlerExists = true;
        }
        if (handlerExists) {
            return allowCondition;
        }
        if (pushAllow.contains(e.getClass())) {
            return true;
        }
        for (Class<?> clazz : pushAllow) {
            if (!clazz.isInstance(e)) continue;
            pushAllow.add(e.getClass());
            return true;
        }
        return false;
    }

    static {
        Interdiction.addToPushDeny(IEntityMultiPart.class);
        Interdiction.addToPushDeny(EntityPlayer.class);
        Interdiction.addToPushDeny("thaumcraft.common.entities.golems.EntityGolemBase");
        Interdiction.addToPushDeny("vazkii.botania.api.internal.IManaBurst");
        Interdiction.addToPushAllow(IProjectile.class);
        Interdiction.addToPushAllow(EntityLivingBase.class);
    }
}

