/*
 * Decompiled with CFR 0.152.
 */
package com.gekox.gekosLasers.utility;

import com.gekox.gekosLasers.blocks.tileEntity.TileEntityTurret;
import com.gekox.gekosLasers.utility.GhostTurretEntity;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class TurretUtil {
    public static float getDistanceToEntity(TileEntityTurret turret, Entity entity) {
        float x = (float)((double)turret.field_145851_c - entity.field_70165_t);
        float y = (float)((double)turret.field_145848_d - entity.field_70163_u);
        float z = (float)((double)turret.field_145849_e - entity.field_70161_v);
        return MathHelper.func_76129_c((float)(x * x + y * y + z * z));
    }

    public static Entity getTarget(TileEntityTurret turret, World world, int x, int y, int z, int range) {
        Entity target = null;
        if (!world.field_72995_K && turret != null && turret.getOwner() != null) {
            AxisAlignedBB axis = AxisAlignedBB.func_72330_a((double)(x - range), (double)(y - range), (double)(z - range), (double)(x + range), (double)(y + range), (double)(z + range));
            List targets = world.func_72872_a(Entity.class, axis);
            for (Entity e : targets) {
                EntityPlayerMP player;
                if (turret.attackMobs && !e.field_70128_L && e instanceof IMob) {
                    target = e;
                }
                if (turret.attackPlayers && !e.field_70128_L && e instanceof EntityPlayerMP && !(player = (EntityPlayerMP)e).getDisplayName().equals(turret.getOwner()) && !TurretUtil.isTrusted(turret, player.getDisplayName())) {
                    target = e;
                }
                if (target == null || !TurretUtil.canTurretSeeTarget(turret, (EntityLivingBase)target, range)) continue;
                return target;
            }
        }
        return null;
    }

    public static boolean canTurretSeeTarget(TileEntityTurret turret, EntityLivingBase target, float range) {
        GhostTurretEntity ghost = new GhostTurretEntity(turret.func_145831_w());
        ghost.field_70165_t = (float)turret.field_145851_c - 0.5f;
        ghost.field_70163_u = (float)turret.field_145848_d + 0.5f;
        ghost.field_70161_v = (float)turret.field_145849_e - 0.5f;
        if (ghost.func_70032_d((Entity)target) > range) {
            return false;
        }
        return ghost.func_70685_l((Entity)target);
    }

    private static boolean isTrusted(TileEntityTurret turret, String name) {
        for (String trusted_player : turret.getTrustedPlayers()) {
            if (!trusted_player.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static int getRFUsePerShot(float base, float damage, float accuracy, float cooldown) {
        int RFPerShot = (int)(Math.round((double)(base * (damage /= 10.0f)) * Math.pow(1.0f + (accuracy /= 10.0f), 1.0f + (cooldown /= 10.0f))) + 50L);
        return RFPerShot;
    }

    public static int getRFUsePerTick(float base, float range) {
        return Math.round(base + range * range);
    }
}

