/*
 * Decompiled with CFR 0.152.
 */
package com.gekox.gekosLasers.items;

import com.gekox.gekosLasers.creativeTab.CreativeTabGL;
import com.gekox.gekosLasers.items.ItemLaserThing;
import com.gekox.gekosLasers.reference.ConfigSettings;
import com.gekox.gekosLasers.reference.Reference;
import com.gekox.gekosLasers.utility.ColorUtils;
import com.gekox.gekosLasers.utility.LaserSwordDamageSource;
import com.gekox.gekosLasers.utility.NBTHelper;
import com.gekox.gekosLasers.utility.StringUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemLaserSword
extends ItemLaserThing {
    public int damage = (int)ConfigSettings.SWORD_DAMAGE_MODIFER;
    protected int startTime;
    protected IIcon[] beamIcons = new IIcon[16];
    protected IIcon hiltIcon;
    private final String SWORD_ACTIVE_TAG = "SwordActive";
    private boolean isActive = false;
    private boolean isRightClicking = false;
    private boolean canToggle = true;

    public ItemLaserSword(ItemStack stack) {
        this.func_77637_a(CreativeTabGL.GL_TAB);
        this.setContainerItem(stack);
    }

    @Override
    protected String getUnwrappedUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(".") + 1);
    }

    public boolean getIsActive(ItemStack stack) {
        return true;
    }

    public void setIsActive(ItemStack stack, boolean value) {
        this.isActive = true;
    }

    public boolean onEntitySwing(EntityLivingBase entBase, ItemStack stack) {
        entBase.field_70170_p.func_72956_a((Entity)entBase, Reference.RESOURCE_PREFIX + "laser.sword", 0.5f, 1.0f);
        return false;
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity player, int p_77663_4_, boolean par5) {
        if (this.canToggle && player.func_70093_af() && par5 && this.isRightClicking && player instanceof EntityPlayerMP && ((EntityPlayerMP)player).func_71045_bC() == stack) {
            boolean isActive = this.getIsActive(stack);
            this.setIsActive(stack, !isActive);
            this.canToggle = false;
        }
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entityTarget, EntityLivingBase entityUser) {
        if (entityUser instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityUser;
            ItemLaserThing laserThing = (ItemLaserThing)stack.func_77973_b();
            int curEnergy = laserThing.getEnergyStored(stack);
            int energyPerShot = laserThing.getEnergyPerUse(stack);
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, false);
            }
            LaserSwordDamageSource ds = new LaserSwordDamageSource((Entity)player);
            entityTarget.func_70097_a((DamageSource)ds, curEnergy >= energyPerShot ? (float)this.damage : 1.0f);
            entityTarget.func_70015_d(this.damage);
            return true;
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean b0) {
        String color = StringUtils.toTitleCase(ColorUtils.names[NBTHelper.getInt(stack, "LaserColor")]);
        String code = ColorUtils.codes[NBTHelper.getInt(stack, "LaserColor")];
        list.add(String.format("%s%s%s lasersaber", code, color, "\u00a77"));
        if (GuiScreen.func_146272_n()) {
            list.add(String.format("Energy: %d/%dRF", this.getEnergyStored(stack), this.getMaxEnergyStored(stack)));
            list.add(String.format("Uses left: %d", this.getEnergyStored(stack) / this.energyPerUse));
            list.add(String.format("%d points of damage", this.damage));
            list.add(String.format("Sets things on fire for %ds", this.damage));
        } else {
            list.add(String.format("%sPress %sSHIFT%s for details", "\u00a77", "\u00a7e", "\u00a77"));
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.block;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer entityPlayer) {
        this.isRightClicking = true;
        entityPlayer.func_71008_a(stack, this.func_77626_a(stack));
        return stack;
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer entityPlayer, int ticksInUseFor) {
        this.canToggle = true;
        this.isRightClicking = false;
    }

    public boolean func_77629_n_() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        for (int i = 0; i < 16; ++i) {
            this.beamIcons[i] = iconRegister.func_94245_a(this.func_77658_a().substring(this.func_77658_a().indexOf(".") + 1) + "Beam_" + ColorUtils.names[i]);
        }
    }

    public IIcon func_77617_a(int meta) {
        meta = meta > 15 ? 16 : (meta < 0 ? 0 : meta);
        return this.beamIcons[meta];
    }

    public IIcon func_77650_f(ItemStack stack) {
        boolean isActive = NBTHelper.getBoolean(stack, this.SWORD_ACTIVE_TAG);
        int color = NBTHelper.getInt(stack, "LaserColor");
        return this.beamIcons[color];
    }
}

