/*
 * Decompiled with CFR 0.152.
 */
package com.gekox.gekosLasers.client.gui;

import cofh.api.energy.IEnergyStorage;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementEnergyStored;
import com.gekox.gekosLasers.GekosLasers;
import com.gekox.gekosLasers.blocks.tileEntity.TileEntityTurret;
import com.gekox.gekosLasers.client.gui.TurretContainerTier1;
import com.gekox.gekosLasers.network.UpdateTurretMessage;
import com.gekox.gekosLasers.reference.Reference;
import com.gekox.gekosLasers.utility.TurretUtil;
import com.gekox.gekosLasers.utility.gui.GUILabel;
import com.gekox.gekosLasers.utility.gui.ToggleButton;
import com.gekox.gekosLasers.utility.gui.TurretSlider;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class TurretGuiBase
extends GuiBase {
    private int mouseX;
    private int mouseY;
    private TileEntityTurret turret;
    private static ResourceLocation texture = new ResourceLocation(Reference.RESOURCE_PREFIX + "textures/gui/turretGui.png");
    private ToggleButton buttonToggleTarget;
    private TurretSlider sliderRange;
    private TurretSlider sliderDamage;
    private TurretSlider sliderAccuracy;
    private TurretSlider sliderCooldown;
    private GUILabel RFTick;
    private GUILabel RFShot;

    public TurretGuiBase(InventoryPlayer inventoryPlayer, TileEntityTurret tileEntity) {
        super((Container)new TurretContainerTier1(inventoryPlayer, tileEntity), texture);
        this.turret = tileEntity;
        this.field_146999_f = 225;
        this.field_147000_g = 200;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        System.out.println("GUI init");
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.elements.add(new ElementEnergyStored((GuiBase)this, 8, 20, (IEnergyStorage)this.turret.storage));
        int xPos = 115;
        this.buttonToggleTarget = new ToggleButton(this, xPos, 20, 100, 20, this.turret);
        ArrayList<String> toolTip = new ArrayList<String>();
        toolTip.add("Change the target of this turret");
        this.buttonToggleTarget.addTooltip(toolTip);
        this.buttonToggleTarget.setValue(0, "None");
        this.buttonToggleTarget.setValue(1, "Mobs");
        this.buttonToggleTarget.setValue(2, "Players");
        this.buttonToggleTarget.setValue(3, "Mobs and Players");
        this.buttonToggleTarget.setSelectedIndex(this.turret.getTargetValue());
        this.elements.add(this.buttonToggleTarget);
        this.sliderRange = new TurretSlider(this, xPos, 45, 100, 10, 20, 1, this.turret);
        this.sliderRange.setName("range");
        this.sliderRange.setValue(this.turret.range);
        this.elements.add(this.sliderRange);
        this.sliderDamage = new TurretSlider(this, xPos, 56, 100, 10, 20, 1, this.turret);
        this.sliderDamage.setName("damage");
        this.sliderDamage.setValue(this.turret.getDamageMod());
        this.elements.add(this.sliderDamage);
        this.sliderAccuracy = new TurretSlider(this, xPos, 67, 100, 10, 20, 1, this.turret);
        this.sliderAccuracy.setName("accuracy");
        this.sliderAccuracy.setValue(this.turret.getAccuracyMod());
        this.elements.add(this.sliderAccuracy);
        this.sliderCooldown = new TurretSlider(this, xPos, 78, 100, 10, 20, 1, this.turret);
        this.sliderCooldown.setName("cooldown");
        this.sliderCooldown.setValue(this.turret.getCooldownMod());
        this.elements.add(this.sliderCooldown);
        GuiButton confirmButton = new GuiButton(0, x + xPos, y + 93, 100, 20, "Confirm");
        this.field_146292_n.add(confirmButton);
        if (!Minecraft.func_71410_x().field_71439_g.getDisplayName().equals(this.turret.getOwner())) {
            confirmButton.field_146124_l = false;
        }
        GUILabel infoLabel1 = new GUILabel(this, 10, 65, 100, 10, "RF per tick:");
        this.elements.add(infoLabel1);
        this.RFTick = new GUILabel(this, 10, 75, 50, 10, "");
        this.elements.add(this.RFTick);
        GUILabel infoLabel2 = new GUILabel(this, 10, 85, 100, 10, "RF per shot:");
        this.elements.add(infoLabel2);
        this.RFShot = new GUILabel(this, 10, 95, 50, 10, "");
        this.elements.add(this.RFShot);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        String s = this.turret.func_145818_k_() ? this.turret.func_145825_b() : I18n.func_135052_a((String)this.turret.func_145825_b(), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, 0x404040);
        this.RFTick.text = "" + TurretUtil.getRFUsePerTick(this.turret.getBaseEnergyPerTick(), this.sliderRange.getValue());
        this.RFShot.text = "" + TurretUtil.getRFUsePerShot(this.turret.getBaseEnergyPerShot(), this.sliderDamage.getValue(), this.sliderAccuracy.getValue(), this.sliderCooldown.getValue());
        ArrayList<String> tip = new ArrayList<String>();
        tip.add("ToolTip");
        this.sliderAccuracy.addTooltip(tip);
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton.field_146127_k == 0) {
            this.sendUpdateMessage();
        }
    }

    private void sendUpdateMessage() {
        UpdateTurretMessage message = new UpdateTurretMessage(this.turret.field_145851_c, this.turret.field_145848_d, this.turret.field_145849_e, this.buttonToggleTarget.getSelectedIndex(), this.sliderDamage.getValue(), this.sliderAccuracy.getValue(), this.sliderCooldown.getValue(), this.sliderRange.getValue());
        GekosLasers.network.sendToServer((IMessage)message);
    }
}

