/*
 * Decompiled with CFR 0.152.
 */
package com.piepenguin.rfwindmill.tileentities;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import com.piepenguin.rfwindmill.lib.EnergyPacket;
import com.piepenguin.rfwindmill.lib.EnergyStorage;
import com.piepenguin.rfwindmill.lib.ModConfiguration;
import com.piepenguin.rfwindmill.lib.Util;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public final class TileEntityWindmillBlock
extends TileEntity
implements IEnergyProvider {
    private EnergyStorage storage;
    private static final int tunnelRange = 10;
    private static final int minHeight = 60;
    private static final int maxHeight = 100;
    private static final String NBT_EFFICIENCY = "RFWEfficiency";
    private static final String NBT_ROTOR_TYPE = "RFWRotorType";
    private static final String NBT_ROTOR_DIR = "RFWRotorDir";
    private static final String NBT_CURRENT_ENERGY_GENERATION = "RFWCurrentEnergyGeneration";
    private float currentEnergyGeneration;
    private float oldEnergyGeneration = 0.0f;
    private int rotorType;
    private ForgeDirection rotorDir;
    private EnergyPacket energyPacket = new EnergyPacket();
    private float efficiency;
    private static int windPacketLength = 4;
    public static final String publicName = "tileEntityWindmillBlock";
    private static final String name = "tileEntityWindmillBlock";

    public TileEntityWindmillBlock() {
        this(0.0f, 0, 0);
    }

    public TileEntityWindmillBlock(float pEfficiency, int pMaximumEnergyTransfer, int pCapacity) {
        this.storage = new EnergyStorage(pCapacity, pMaximumEnergyTransfer);
        this.efficiency = pEfficiency;
        this.rotorType = -1;
        this.rotorDir = ForgeDirection.NORTH;
    }

    public String getName() {
        return "tileEntityWindmillBlock";
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.energyPacket.getLifetime() > 0) {
                this.extractFromEnergyPacket(this.energyPacket);
            } else {
                this.energyPacket = this.getEnergyPacketFromWind();
                this.extractFromEnergyPacket(this.energyPacket);
            }
            if (this.storage.getEnergyStored() > 0) {
                this.transferEnergy();
            }
        }
    }

    public void readSyncableDataFromNBT(NBTTagCompound pNbt) {
        this.currentEnergyGeneration = pNbt.func_74760_g(NBT_CURRENT_ENERGY_GENERATION);
    }

    public void writeSyncableDataToNBT(NBTTagCompound pNbt) {
        pNbt.func_74776_a(NBT_CURRENT_ENERGY_GENERATION, this.currentEnergyGeneration);
    }

    public void func_145839_a(NBTTagCompound pNbt) {
        super.func_145839_a(pNbt);
        this.efficiency = pNbt.func_74760_g(NBT_EFFICIENCY);
        this.rotorType = pNbt.func_74762_e(NBT_ROTOR_TYPE);
        this.rotorDir = Util.intToDirection(pNbt.func_74762_e(NBT_ROTOR_DIR));
        this.readSyncableDataFromNBT(pNbt);
        this.storage.readFromNBT(pNbt);
    }

    public void func_145841_b(NBTTagCompound pNbt) {
        super.func_145841_b(pNbt);
        pNbt.func_74776_a(NBT_EFFICIENCY, this.efficiency);
        pNbt.func_74768_a(NBT_ROTOR_TYPE, this.rotorType);
        pNbt.func_74768_a(NBT_ROTOR_DIR, Util.directionToInt(this.rotorDir));
        this.writeSyncableDataToNBT(pNbt);
        this.storage.writeToNBT(pNbt);
    }

    public Packet func_145844_m() {
        NBTTagCompound syncData = new NBTTagCompound();
        this.writeSyncableDataToNBT(syncData);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, syncData);
    }

    public void onDataPacket(NetworkManager pNet, S35PacketUpdateTileEntity pPacket) {
        this.readSyncableDataFromNBT(pPacket.func_148857_g());
    }

    private EnergyPacket getEnergyPacketFromWind() {
        int deltaHeight = 40;
        if (deltaHeight <= 0) {
            deltaHeight = 1;
        }
        float heightModifier = (float)Math.min(Math.max(this.field_145848_d - 60, 0), deltaHeight) / (float)deltaHeight;
        float weatherModifier = 1.0f;
        if (this.field_145850_b.func_72911_I()) {
            weatherModifier = ModConfiguration.getWeatherMultiplierThunder();
        } else if (this.field_145850_b.func_72896_J()) {
            weatherModifier = ModConfiguration.getWeatherMultiplierRain();
        }
        float energy = ModConfiguration.getWindGenerationBase() * heightModifier * (float)this.getTunnelLength() * 0.1f * weatherModifier;
        if ((double)energy < 0.01) {
            return new EnergyPacket(0.0f, 0);
        }
        return new EnergyPacket(energy * (float)windPacketLength, windPacketLength);
    }

    private EnergyPacket getEnergyPacketFromHand() {
        return new EnergyPacket((float)Util.ticksPerClick() * ModConfiguration.getWindGenerationBase() * ModConfiguration.getHandcrankEnergyMultiplier(), Util.ticksPerClick());
    }

    public void handcrank() {
        if (this.energyPacket.getLifetime() <= 0) {
            this.energyPacket = this.getEnergyPacketFromHand();
        }
    }

    private float getExtractableEnergyFromPacket(EnergyPacket pEnergyPacket) {
        float totalEfficiency = 1.0f;
        if (!this.hasRotor()) {
            totalEfficiency = 0.0f;
        } else {
            totalEfficiency *= ModConfiguration.getRotorEnergyMultiplier(this.rotorType);
            totalEfficiency *= this.efficiency;
        }
        return pEnergyPacket.getEnergyPerTick() * totalEfficiency;
    }

    private void extractFromEnergyPacket(EnergyPacket pEnergyPacket) {
        this.currentEnergyGeneration = this.getExtractableEnergyFromPacket(pEnergyPacket);
        pEnergyPacket.deplete();
        this.syncEnergy();
        this.storage.modifyEnergyStored(this.currentEnergyGeneration);
    }

    public float getCurrentEnergyGeneration() {
        return this.currentEnergyGeneration;
    }

    private void syncEnergy() {
        if ((double)Math.abs(this.currentEnergyGeneration - this.oldEnergyGeneration) > 0.01) {
            this.oldEnergyGeneration = this.currentEnergyGeneration;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        }
    }

    private int getTunnelLengthSingleBlock(int pX, int pY, int pZ, ForgeDirection pDirection, boolean ignoreFirst) {
        for (int i = 1; i <= 10; ++i) {
            Block block;
            int dx = pX + pDirection.offsetX * i;
            int dy = pY + pDirection.offsetY * i;
            int dz = pZ + pDirection.offsetZ * i;
            if (ignoreFirst && i == 1 || (block = this.field_145850_b.func_147439_a(dx, dy, dz)) != null && block.func_149688_o() == Material.field_151579_a) continue;
            return i - 1;
        }
        return 10;
    }

    private int getTunnelLengthTwoSided(int pX, int pY, int pZ, ForgeDirection pDirection, boolean ignoreFirst) {
        int rangeA = this.getTunnelLengthSingleBlock(pX, pY, pZ, pDirection, ignoreFirst);
        int rangeB = this.getTunnelLengthSingleBlock(pX, pY, pZ, pDirection.getOpposite(), false);
        return Math.min(rangeA, rangeB);
    }

    private int getTunnelLength() {
        int range = 10;
        if (this.rotorDir == ForgeDirection.NORTH || this.rotorDir == ForgeDirection.SOUTH) {
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    int r = this.getTunnelLengthTwoSided(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e, this.rotorDir, x == 0 && y == 0);
                    if (r >= range) continue;
                    range = r;
                }
            }
        } else {
            for (int z = -1; z <= 1; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    int r = this.getTunnelLengthTwoSided(this.field_145851_c, this.field_145848_d + y, this.field_145849_e + z, this.rotorDir, z == 0 && y == 0);
                    if (r >= range) continue;
                    range = r;
                }
            }
        }
        return range;
    }

    private void transferEnergy() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.func_145831_w().func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
            if (!(tile instanceof IEnergyReceiver)) continue;
            IEnergyReceiver receiver = (IEnergyReceiver)tile;
            this.extractEnergy(direction.getOpposite(), receiver.receiveEnergy(direction.getOpposite(), this.storage.getExtract(), false), false);
        }
    }

    @Override
    public int extractEnergy(ForgeDirection pFrom, int pMaxExtract, boolean pSimulate) {
        if (this.canConnectEnergy(pFrom)) {
            return this.storage.extractEnergy(pMaxExtract, pSimulate);
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection pFrom) {
        return this.storage.getEnergyStored();
    }

    public int getEnergyStored() {
        return this.getEnergyStored(ForgeDirection.NORTH);
    }

    public void setEnergyStored(int pEnergy) {
        this.storage.setEnergyStored(pEnergy);
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection pFrom) {
        return this.storage.getMaxEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.getMaxEnergyStored(ForgeDirection.NORTH);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection pFrom) {
        return true;
    }

    public boolean hasRotor() {
        return this.rotorType >= 0;
    }

    public void setRotor(int pRotorType, ForgeDirection fDir) {
        this.rotorType = pRotorType;
        this.rotorDir = fDir;
    }

    public ForgeDirection getRotorDir() {
        return this.rotorDir;
    }
}

