/*
 * Decompiled with CFR 0.152.
 */
package com.piepenguin.rfwindmill.recipes;

import com.google.common.base.Preconditions;
import com.piepenguin.rfwindmill.blocks.ModBlocks;
import com.piepenguin.rfwindmill.items.ModItems;
import com.piepenguin.rfwindmill.lib.ModConfiguration;
import com.piepenguin.rfwindmill.lib.Util;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModRecipes {
    public static void init() {
        ModRecipes.registerCommonRecipes();
        if (Util.useThermalFoundation() && !ModConfiguration.useVanillaRecipes()) {
            ModRecipes.registerThermalFoundationRotors();
        } else {
            ModRecipes.registerVanillaRotors();
        }
        if (Util.useThermalExpansion() && !ModConfiguration.useVanillaRecipes()) {
            ModRecipes.registerThermalExpansionTurbines();
        } else {
            ModRecipes.registerVanillaTurbines();
        }
    }

    private static void registerCommonRecipes() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)ModItems.rotor1, new Object[]{"i  ", "iii", "  i", Character.valueOf('i'), "ingotIron"}));
    }

    private static void registerVanillaTurbines() {
        String ingotTin = ModRecipes.getOreWithFallback("ingotTin", "ingotIron");
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ModBlocks.windmillBlock, 1, 0), new Object[]{" x ", "ibi", "ixi", Character.valueOf('x'), "dustRedstone", Character.valueOf('i'), ingotTin, Character.valueOf('b'), "blockIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ModBlocks.windmillBlock, 1, 1), new Object[]{" x ", "ibi", "ixi", Character.valueOf('x'), "dustRedstone", Character.valueOf('i'), "ingotGold", Character.valueOf('b'), "blockIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ModBlocks.windmillBlock, 1, 2), new Object[]{" x ", "ibi", "oxo", Character.valueOf('x'), "dustRedstone", Character.valueOf('i'), Blocks.field_150371_ca, Character.valueOf('o'), Blocks.field_150343_Z, Character.valueOf('b'), "blockIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ModBlocks.windmillBlock, 1, 3), new Object[]{" x ", "dbd", "ixi", Character.valueOf('x'), "dustRedstone", Character.valueOf('d'), "gemDiamond", Character.valueOf('i'), "ingotGold", Character.valueOf('b'), "blockIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ModBlocks.windmillBlock, 1, 1), new Object[]{"i i", " b ", "i i", Character.valueOf('i'), "ingotGold", Character.valueOf('b'), new ItemStack(ModBlocks.windmillBlock, 1, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ModBlocks.windmillBlock, 1, 2), new Object[]{"i i", " b ", "o o", Character.valueOf('i'), Blocks.field_150371_ca, Character.valueOf('o'), Blocks.field_150343_Z, Character.valueOf('b'), new ItemStack(ModBlocks.windmillBlock, 1, 1)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ModBlocks.windmillBlock, 1, 3), new Object[]{"d d", " b ", "i i", Character.valueOf('i'), "ingotGold", Character.valueOf('d'), "gemDiamond", Character.valueOf('b'), new ItemStack(ModBlocks.windmillBlock, 1, 2)}));
    }

    private static void registerVanillaRotors() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)ModItems.rotor2, new Object[]{"g  ", "gig", "  g", Character.valueOf('i'), "ingotIron", Character.valueOf('g'), "ingotGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)ModItems.rotor3, new Object[]{"n  ", "non", "  n", Character.valueOf('n'), Items.field_151128_bU, Character.valueOf('o'), Blocks.field_150343_Z}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)ModItems.rotor4, new Object[]{"d  ", "dgd", "  d", Character.valueOf('d'), "gemDiamond", Character.valueOf('g'), "ingotGold"}));
    }

    private static void registerThermalFoundationRotors() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)ModItems.rotor2, new Object[]{"e  ", "eie", "  e", Character.valueOf('i'), "ingotInvar", Character.valueOf('e'), "ingotElectrum"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)ModItems.rotor3, new Object[]{"s  ", "ses", "  s", Character.valueOf('s'), "ingotSignalum", Character.valueOf('e'), "ingotElectrum"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)ModItems.rotor4, new Object[]{"e  ", "eie", "  e", Character.valueOf('e'), "ingotEnderium", Character.valueOf('i'), "ingotInvar"}));
    }

    private static void registerThermalExpansionTurbines() {
        ItemStack powerCoilSilver = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"powerCoilSilver", (int)1));
        ItemStack machineFrameBasic = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"frameMachineBasic", (int)1));
        ItemStack machineFrameHardened = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"frameMachineHardened", (int)1));
        ItemStack machineFrameReinforced = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"frameMachineReinforced", (int)1));
        ItemStack machineFrameResonant = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"frameMachineResonant", (int)1));
        ItemStack hardenedGlass = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"Glass", (int)1));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ModBlocks.windmillBlock, 1, 0), new Object[]{" x ", "imi", " c ", Character.valueOf('x'), "dustRedstone", Character.valueOf('i'), "ingotTin", Character.valueOf('m'), machineFrameBasic, Character.valueOf('c'), powerCoilSilver}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ModBlocks.windmillBlock, 1, 1), new Object[]{" x ", "imi", " c ", Character.valueOf('x'), "dustRedstone", Character.valueOf('i'), "ingotInvar", Character.valueOf('m'), machineFrameHardened, Character.valueOf('c'), powerCoilSilver}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ModBlocks.windmillBlock, 1, 2), new Object[]{" x ", "imi", " c ", Character.valueOf('x'), "dustRedstone", Character.valueOf('i'), "ingotSilver", Character.valueOf('m'), machineFrameReinforced, Character.valueOf('c'), powerCoilSilver}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ModBlocks.windmillBlock, 1, 3), new Object[]{" x ", "imi", " c ", Character.valueOf('x'), "dustRedstone", Character.valueOf('i'), "ingotPlatinum", Character.valueOf('m'), machineFrameResonant, Character.valueOf('c'), powerCoilSilver}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ModBlocks.windmillBlock, 1, 1), new Object[]{"igi", "jmj", "i i", Character.valueOf('i'), "ingotInvar", Character.valueOf('j'), "ingotInvar", Character.valueOf('g'), "gearElectrum", Character.valueOf('m'), new ItemStack(ModBlocks.windmillBlock, 1, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ModBlocks.windmillBlock, 1, 2), new Object[]{"igi", "jmj", "i i", Character.valueOf('i'), hardenedGlass, Character.valueOf('j'), "ingotSilver", Character.valueOf('g'), "gearSignalum", Character.valueOf('m'), new ItemStack(ModBlocks.windmillBlock, 1, 1)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ModBlocks.windmillBlock, 1, 3), new Object[]{"igi", "jmj", "i i", Character.valueOf('i'), "ingotSilver", Character.valueOf('j'), "ingotPlatinum", Character.valueOf('g'), "gearEnderium", Character.valueOf('m'), new ItemStack(ModBlocks.windmillBlock, 1, 2)}));
    }

    public static String getOreWithFallback(String pOre, String pFallback) {
        if (OreDictionary.getOres((String)pOre).isEmpty()) {
            return pFallback;
        }
        return pOre;
    }
}

