/*
 * Decompiled with CFR 0.152.
 */
package latmod.latblocks.block.paintable;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import latmod.core.ODItems;
import latmod.core.tile.IGuiTile;
import latmod.core.util.FastList;
import latmod.latblocks.LatBlocksItems;
import latmod.latblocks.block.BlockPaintableSingle;
import latmod.latblocks.tile.TilePaintableLB;
import latmod.latblocks.tile.TileSinglePaintable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;

public class BlockPPressurePlate
extends BlockPaintableSingle {
    public BlockPPressurePlate(String s) {
        super(s, 0.0625f);
    }

    @Override
    public TilePaintableLB createNewTileEntity(World w, int m) {
        return new TilePPressurePlate();
    }

    public void loadRecipes() {
        this.mod.recipes.addRecipe(new ItemStack((Block)this, 2), new Object[]{"PP", Character.valueOf('P'), LatBlocksItems.b_cover});
    }

    public void onPostLoaded() {
        super.onPostLoaded();
        ODItems.add((String)"coverPaintable", (ItemStack)new ItemStack((Block)this));
    }

    @Override
    public void addCollisionBoxes(World w, int x, int y, int z, int m, FastList<AxisAlignedBB> boxes, Entity e) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addItemRenderBoxes(FastList<AxisAlignedBB> boxes) {
        double f1 = 0.0625;
        boxes.add((Object)AxisAlignedBB.func_72330_a((double)0.0, (double)(0.5 - f1), (double)0.0, (double)1.0, (double)(0.5 + f1), (double)1.0));
    }

    @Override
    public int onBlockPlaced(World w, EntityPlayer ep, MovingObjectPosition mop, int m) {
        return 0;
    }

    @Override
    public int func_149692_a(int m) {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawHighlight(FastList<AxisAlignedBB> boxes, DrawBlockHighlightEvent event) {
        boxes.add((Object)BlockPPressurePlate.getBox(0, 0, 0));
    }

    @Override
    public void addBoxes(FastList<AxisAlignedBB> boxes, IBlockAccess iba, int x, int y, int z, int m) {
        boxes.add((Object)BlockPPressurePlate.getBox(0, 0, 0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addRenderBoxes(FastList<AxisAlignedBB> boxes, IBlockAccess iba, int x, int y, int z, int m) {
        TilePPressurePlate t = (TilePPressurePlate)iba.func_147438_o(x, y, z);
        double p = 0.0625;
        double h = t != null && t.isValid() && t.isPressed ? p / 2.0 : p;
        boxes.add((Object)AxisAlignedBB.func_72330_a((double)p, (double)0.0, (double)p, (double)(1.0 - p), (double)h, (double)(1.0 - p)));
    }

    public boolean func_149727_a(World w, int x, int y, int z, EntityPlayer ep, int s, float x1, float y1, float z1) {
        return false;
    }

    public boolean func_149742_c(World w, int x, int y, int z) {
        return World.func_147466_a((IBlockAccess)w, (int)x, (int)(y - 1), (int)z) || BlockFence.func_149825_a((Block)w.func_147439_a(x, y - 1, z));
    }

    public void func_149695_a(World w, int x, int y, int z, Block b) {
        if (!World.func_147466_a((IBlockAccess)w, (int)x, (int)(y - 1), (int)z) && !BlockFence.func_149825_a((Block)w.func_147439_a(x, y - 1, z))) {
            this.func_149697_b(w, x, y, z, w.func_72805_g(x, y, z), 0);
            w.func_147468_f(x, y, z);
        }
    }

    public int func_149709_b(IBlockAccess iba, int x, int y, int z, int s) {
        return ((TilePPressurePlate)iba.func_147438_o((int)x, (int)y, (int)z)).isPressed ? 15 : 0;
    }

    public int func_149748_c(IBlockAccess iba, int x, int y, int z, int s) {
        return ((TilePPressurePlate)iba.func_147438_o((int)x, (int)y, (int)z)).isPressed ? 15 : 0;
    }

    public boolean func_149744_f() {
        return true;
    }

    private static AxisAlignedBB getBox(int x, int y, int z) {
        double p = 0.0625;
        return AxisAlignedBB.func_72330_a((double)((double)x + p), (double)y, (double)((double)z + p), (double)((double)x + 1.0 - p), (double)((double)y + p), (double)((double)z + 1.0 - p));
    }

    public static class TilePPressurePlate
    extends TileSinglePaintable
    implements IGuiTile {
        public byte plateType = 0;
        public short maxTick = (short)20;
        public boolean isPressed = false;
        private short cooldown = 0;

        @Override
        public void readTileData(NBTTagCompound tag) {
            super.readTileData(tag);
            this.plateType = tag.func_74771_c("Type");
            this.maxTick = tag.func_74765_d("MaxTick");
            this.isPressed = tag.func_74767_n("Down");
            this.cooldown = tag.func_74765_d("Tick");
            this.security.readFromNBT(tag, "Security");
        }

        @Override
        public void writeTileData(NBTTagCompound tag) {
            super.writeTileData(tag);
            tag.func_74774_a("Type", this.plateType);
            tag.func_74777_a("MaxTick", this.maxTick);
            tag.func_74757_a("Down", this.isPressed);
            tag.func_74777_a("Tick", this.cooldown);
            this.security.writeToNBT(tag, "Security");
        }

        public void onUpdate() {
            if (!this.isServer()) {
                return;
            }
            boolean pPressed = this.isPressed;
            this.isPressed = this.isPressed();
            if (this.isPressed) {
                this.cooldown = this.maxTick;
            } else if (this.cooldown > 0) {
                this.cooldown = (short)(this.cooldown - 1);
            }
            boolean bl = this.isPressed = this.cooldown > 0;
            if (pPressed != this.isPressed) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.1, (double)this.field_145849_e + 0.5, "random.click", 0.3f, this.isPressed ? 0.6f : 0.5f);
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)this.getBlockType());
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, (Block)this.getBlockType());
                this.func_70296_d();
            }
        }

        private boolean isPressed() {
            Class<Entity> c = null;
            if (this.plateType == 0) {
                c = Entity.class;
            } else if (this.plateType == 1) {
                c = EntityLivingBase.class;
            } else if (this.plateType == 2) {
                c = EntityPlayer.class;
            }
            List list = this.field_145850_b.func_72872_a(c, BlockPPressurePlate.getBox(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            if (list != null && !list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    Entity e = (Entity)list.get(i);
                    if (e.func_145773_az() || this.plateType == 2 && !this.security.canInteract(e.func_110124_au())) continue;
                    return true;
                }
            }
            return false;
        }

        public Container getContainer(EntityPlayer ep, NBTTagCompound data) {
            return null;
        }

        public GuiScreen getGui(EntityPlayer ep, NBTTagCompound data) {
            return null;
        }
    }
}

