/*
 * Decompiled with CFR 0.152.
 */
package latmod.latblocks.block.paintable;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import latmod.core.util.FastList;
import latmod.core.util.MathHelperLM;
import latmod.latblocks.LatBlocksConfig;
import latmod.latblocks.LatBlocksItems;
import latmod.latblocks.block.BlockPaintableSingle;
import latmod.latblocks.item.ItemMaterialsLB;
import latmod.latblocks.tile.TilePaintableLB;
import latmod.latblocks.tile.TileSinglePaintable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;

public class BlockPFenceGate
extends BlockPaintableSingle {
    public BlockPFenceGate(String s) {
        super(s, 1.0f);
    }

    @Override
    public TilePaintableLB createNewTileEntity(World w, int m) {
        return new TilePFenceGate();
    }

    public void loadRecipes() {
        this.mod.recipes.addRecipe(new ItemStack((Block)this), new Object[]{"PSP", "PSP", Character.valueOf('P'), LatBlocksItems.b_paintable, Character.valueOf('S'), ItemMaterialsLB.ROD});
    }

    @Override
    public void addCollisionBoxes(World w, int x, int y, int z, int m, FastList<AxisAlignedBB> boxes, Entity e) {
        if (m == -1) {
            m = w.func_72805_g(x, y, z);
        }
        if (m > 1) {
            return;
        }
        double p = 0.25;
        double pn = 0.5 - p / 2.0;
        double pp = 0.5 + p / 2.0;
        double x0 = pn;
        double x1 = pp;
        double z0 = pn;
        double z1 = pp;
        double d = 0.01;
        if (m % 2 == 0) {
            x0 = -d;
            x1 = 1.0 + d;
        } else {
            z0 = -d;
            z1 = 1.0 + d;
        }
        double h = 1.5;
        if (LatBlocksConfig.General.fencesIgnorePlayers && e instanceof EntityPlayer) {
            h = 1.0;
        }
        boxes.add((Object)AxisAlignedBB.func_72330_a((double)x0, (double)0.0, (double)z0, (double)x1, (double)h, (double)z1));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addItemRenderBoxes(FastList<AxisAlignedBB> boxes) {
        double p = 0.1875;
        double pn = 0.5 - p / 2.0;
        double pp = 0.5 + p / 2.0;
        boxes.add((Object)AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)pn, (double)p, (double)1.0, (double)pp));
        boxes.add((Object)AxisAlignedBB.func_72330_a((double)(1.0 - p), (double)0.0, (double)pn, (double)1.0, (double)1.0, (double)pp));
        double hn = 0.125;
        double hp = 0.875;
        double dd = 0.125;
        double x0 = p;
        double z0 = 0.5 - dd / 2.0;
        double x1 = 1.0 - p;
        double z1 = 0.5 + dd / 2.0;
        boxes.add((Object)AxisAlignedBB.func_72330_a((double)x0, (double)hn, (double)z0, (double)x1, (double)hp, (double)z1));
    }

    @Override
    public int onBlockPlaced(World w, EntityPlayer ep, MovingObjectPosition mop, int m) {
        return (MathHelperLM.floor((double)((double)ep.field_70177_z * 4.0 / 360.0 + 0.5)) & 3) % 2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawHighlight(FastList<AxisAlignedBB> boxes, DrawBlockHighlightEvent event) {
    }

    @Override
    public void addBoxes(FastList<AxisAlignedBB> boxes, IBlockAccess iba, int x, int y, int z, int m) {
        if (m == -1) {
            m = iba.func_72805_g(x, y, z);
        }
        double p = 0.25;
        double pn = 0.5 - p / 2.0;
        double pp = 0.5 + p / 2.0;
        double x0 = pn;
        double x1 = pp;
        double z0 = pn;
        double z1 = pp;
        double d = 0.01;
        if (m % 2 == 0) {
            x0 = -d;
            x1 = 1.0 + d;
        } else {
            z0 = -d;
            z1 = 1.0 + d;
        }
        boxes.add((Object)AxisAlignedBB.func_72330_a((double)x0, (double)0.0, (double)z0, (double)x1, (double)1.0, (double)z1));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addRenderBoxes(FastList<AxisAlignedBB> boxes, IBlockAccess iba, int x, int y, int z, int m) {
        if (m == -1) {
            m = iba.func_72805_g(x, y, z);
        }
        double p = 0.1875;
        double pn = 0.5 - p / 2.0;
        double pp = 0.5 + p / 2.0;
        if (m % 2 == 0) {
            boxes.add((Object)AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)pn, (double)p, (double)1.0, (double)pp));
            boxes.add((Object)AxisAlignedBB.func_72330_a((double)(1.0 - p), (double)0.0, (double)pn, (double)1.0, (double)1.0, (double)pp));
        } else {
            boxes.add((Object)AxisAlignedBB.func_72330_a((double)pn, (double)0.0, (double)0.0, (double)pp, (double)1.0, (double)p));
            boxes.add((Object)AxisAlignedBB.func_72330_a((double)pn, (double)0.0, (double)(1.0 - p), (double)pp, (double)1.0, (double)1.0));
        }
        if (m <= 1) {
            double hp = 0.875;
            if (iba.func_147439_a(x, y + 1, z) != Blocks.field_150350_a) {
                hp = 1.0;
            }
            double dd = 0.125;
            double x0 = p;
            double z0 = 0.5 - dd / 2.0;
            double x1 = 1.0 - p;
            double z1 = 0.5 + dd / 2.0;
            if (m == 1) {
                z0 = p;
                x0 = 0.5 - dd / 2.0;
                z1 = 1.0 - p;
                x1 = 0.5 + dd / 2.0;
            }
            boxes.add((Object)AxisAlignedBB.func_72330_a((double)x0, (double)0.0, (double)z0, (double)x1, (double)hp, (double)z1));
        }
    }

    public boolean func_149727_a(World w, int x, int y, int z, EntityPlayer ep, int s, float x1, float y1, float z1) {
        this.setOpen(w, x, y, z, !this.isOpen(w.func_72805_g(x, y, z)));
        return true;
    }

    public boolean isOpen(int meta) {
        return meta > 1;
    }

    public void setOpen(World w, int x, int y, int z, boolean open) {
        int m0 = w.func_72805_g(x, y, z);
        if (open == this.isOpen(m0)) {
            return;
        }
        w.func_72921_c(x, y, z, (m0 + 2) % 4, 3);
        for (int i = -2; i <= 2; ++i) {
            int m;
            if (i == 0 || w.func_147439_a(x, y + i, z) != this || (m = w.func_72805_g(x, y + i, z)) != m0) continue;
            w.func_72921_c(x, y + i, z, (m + 2) % 4, 3);
        }
        if (!w.field_72995_K) {
            w.func_72889_a(null, 1003, x, y, z, 0);
        }
    }

    public void func_149695_a(World w, int x, int y, int z, Block b) {
        boolean flag;
        if (!w.field_72995_K && ((flag = w.func_72864_z(x, y, z)) || b.func_149744_f())) {
            this.setOpen(w, x, y, z, flag);
        }
    }

    public static class TilePFenceGate
    extends TileSinglePaintable {
    }
}

