/*
 * Decompiled with CFR 0.152.
 */
package latmod.latblocks.block;

import com.cricketcraft.chisel.api.carving.ICarvingGroup;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import latmod.core.EnumDyeColor;
import latmod.core.LatCoreMC;
import latmod.core.ODItems;
import latmod.core.mod.ChiselHelper;
import latmod.core.mod.LCConfig;
import latmod.core.recipes.LMRecipes;
import latmod.core.tile.IPaintable;
import latmod.core.tile.TileLM;
import latmod.core.util.FastList;
import latmod.latblocks.LatBlocksConfig;
import latmod.latblocks.LatBlocksItems;
import latmod.latblocks.block.BlockLB;
import latmod.latblocks.client.render.world.RenderGlowiumBlocks;
import latmod.latblocks.item.ItemMaterialsLB;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockGlowium
extends BlockLB
implements IPaintable.INoPaint {
    public static final String ORE_NAME = "blockGlowium";
    public static final int DEF_DMG = EnumDyeColor.YELLOW.ID;
    public static final FastList<BlockGlowium> allBlocks = new FastList();
    public final String name;
    @SideOnly(value=Side.CLIENT)
    public IIcon icon_glow;

    public static void postLoaded() {
        if (ChiselHelper.isInstalled()) {
            for (int i = 0; i < allBlocks.size(); ++i) {
                ChiselHelper.register((ICarvingGroup)new GroupGlowium((BlockGlowium)((Object)allBlocks.get(i))));
            }
        }
    }

    public BlockGlowium(String s, String s1) {
        super(s, Material.field_151576_e);
        this.name = s1;
        this.field_149758_A = false;
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
    }

    public String getUnlocalizedName(int m) {
        return this.mod.getBlockName("glowium." + this.name);
    }

    public void onPostLoaded() {
        allBlocks.add((Object)this);
        this.blocksAdded.add(new ItemStack((Block)this, 1, DEF_DMG));
        if (!ChiselHelper.isInstalled()) {
            ODItems.add((String)ORE_NAME, (ItemStack)new ItemStack((Block)this, 1, Short.MAX_VALUE));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item j, CreativeTabs c, List l) {
        if (LCConfig.Client.addAllColorItems) {
            for (int i = 0; i < 16; ++i) {
                l.add(new ItemStack((Block)this, 1, i));
            }
        } else {
            l.add(new ItemStack((Block)this, 1, DEF_DMG));
        }
    }

    public void loadRecipes() {
        if (LatBlocksConfig.Crafting.glowiumBlocks && !ChiselHelper.isInstalled()) {
            for (int i = 0; i < 16; ++i) {
                this.mod.recipes.addRecipe(new ItemStack((Block)this, 4, i), new Object[]{" G ", "GCG", " G ", Character.valueOf('G'), new ItemStack((Block)this, 1, DEF_DMG), Character.valueOf('C'), EnumDyeColor.VALUES[i].dyeName});
            }
        }
    }

    public TileLM createNewTileEntity(World w, int m) {
        return null;
    }

    public int func_149692_a(int m) {
        return m;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ir) {
        this.field_149761_L = ir.func_94245_a(this.mod.assets + "glowium/" + this.name);
        this.icon_glow = ir.func_94245_a(this.mod.assets + "glowium/" + this.name + "_glow");
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return RenderGlowiumBlocks.instance.getRenderId();
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean isNormalCube(IBlockAccess iba, int x, int y, int z) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess iba, int x, int y, int z, int s) {
        return true;
    }

    public boolean recolourBlock(World w, int x, int y, int z, ForgeDirection side, int col) {
        int meta = BlockColored.func_150031_c((int)col);
        if (w.func_72805_g(x, y, z) != meta) {
            w.func_72921_c(x, y, z, meta, 3);
            return true;
        }
        return false;
    }

    public boolean func_149727_a(World w, int x, int y, int z, EntityPlayer ep, int s, float x1, float y1, float z1) {
        if (LatCoreMC.isWrench((ItemStack)ep.func_70694_bm())) {
            if (!w.field_72995_K) {
                BlockGlowium b = null;
                int meta = w.func_72805_g(x, y, z);
                if (ep.func_70093_af()) {
                    if (this == LatBlocksItems.b_glowium_block) {
                        b = LatBlocksItems.b_glowium_chiseled;
                    }
                    if (this == LatBlocksItems.b_glowium_tile) {
                        b = LatBlocksItems.b_glowium_block;
                    }
                    if (this == LatBlocksItems.b_glowium_brick) {
                        b = LatBlocksItems.b_glowium_tile;
                    }
                    if (this == LatBlocksItems.b_glowium_small) {
                        b = LatBlocksItems.b_glowium_brick;
                    }
                    if (this == LatBlocksItems.b_glowium_chiseled) {
                        b = LatBlocksItems.b_glowium_small;
                    }
                } else {
                    if (this == LatBlocksItems.b_glowium_block) {
                        b = LatBlocksItems.b_glowium_tile;
                    }
                    if (this == LatBlocksItems.b_glowium_tile) {
                        b = LatBlocksItems.b_glowium_brick;
                    }
                    if (this == LatBlocksItems.b_glowium_brick) {
                        b = LatBlocksItems.b_glowium_small;
                    }
                    if (this == LatBlocksItems.b_glowium_small) {
                        b = LatBlocksItems.b_glowium_chiseled;
                    }
                    if (this == LatBlocksItems.b_glowium_chiseled) {
                        b = LatBlocksItems.b_glowium_block;
                    }
                }
                if (b != null) {
                    w.func_147465_d(x, y, z, (Block)b, meta, 3);
                }
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int m) {
        return EnumDyeColor.VALUES[m].colorBright.getRGB();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess iba, int x, int y, int z) {
        return this.func_149741_i(iba.func_72805_g(x, y, z));
    }

    public boolean hasPaint(IBlockAccess iba, int x, int y, int z, int s) {
        return false;
    }

    public void addInfo(ItemStack is, EntityPlayer ep, FastList<String> l) {
        l.add((Object)EnumDyeColor.VALUES[is.func_77960_j()].toString());
    }

    public static class GroupGlowium
    extends ChiselHelper.Group {
        public GroupGlowium(BlockGlowium b) {
            super((Block)b);
            this.name = b.blockName;
            for (int i = 0; i < 16; ++i) {
                this.addVariation((Block)b, i);
            }
        }
    }

    public static class BGBrickChiseled
    extends BlockGlowium {
        public BGBrickChiseled() {
            super("glowiumChiseledBrick", "chiseled");
        }

        @Override
        public void loadRecipes() {
            super.loadRecipes();
            if (LatBlocksConfig.Crafting.glowiumBlocks) {
                this.mod.recipes.addRecipe(new ItemStack((Block)this, 4, DEF_DMG), new Object[]{"GG", "GG", Character.valueOf('G'), new ItemStack((Block)LatBlocksItems.b_glowium_small, 4, DEF_DMG)});
            }
        }
    }

    public static class BGBrickSmall
    extends BlockGlowium {
        public BGBrickSmall() {
            super("glowiumSmallBrick", "small");
        }

        @Override
        public void loadRecipes() {
            super.loadRecipes();
            if (LatBlocksConfig.Crafting.glowiumBlocks) {
                this.mod.recipes.addRecipe(new ItemStack((Block)this, 4, DEF_DMG), new Object[]{"GG", "GG", Character.valueOf('G'), new ItemStack((Block)LatBlocksItems.b_glowium_brick, 4, DEF_DMG)});
            }
        }
    }

    public static class BGBrick
    extends BlockGlowium {
        public BGBrick() {
            super("glowiumBrick", "brick");
        }

        @Override
        public void loadRecipes() {
            super.loadRecipes();
            if (LatBlocksConfig.Crafting.glowiumBlocks) {
                this.mod.recipes.addRecipe(new ItemStack((Block)this, 4, DEF_DMG), new Object[]{"GG", "GG", Character.valueOf('G'), new ItemStack((Block)LatBlocksItems.b_glowium_tile, 4, DEF_DMG)});
            }
        }
    }

    public static class BGTile
    extends BlockGlowium {
        public BGTile() {
            super("glowiumTile", "tile");
        }

        @Override
        public void loadRecipes() {
            super.loadRecipes();
            if (LatBlocksConfig.Crafting.glowiumBlocks) {
                this.mod.recipes.addRecipe(new ItemStack((Block)this, 4, DEF_DMG), new Object[]{"GG", "GG", Character.valueOf('G'), new ItemStack((Block)LatBlocksItems.b_glowium_block, 4, DEF_DMG)});
            }
        }
    }

    public static class BGBlock
    extends BlockGlowium {
        public BGBlock() {
            super("glowiumBlock", "block");
        }

        @Override
        public void loadRecipes() {
            super.loadRecipes();
            if (LatBlocksConfig.Crafting.glowiumBlocks) {
                this.mod.recipes.addRecipe(new ItemStack((Block)this, 1, DEF_DMG), new Object[]{"GG", "GG", Character.valueOf('G'), ItemMaterialsLB.GEMS_GLOWIUM[0]});
                this.mod.recipes.addRecipe(LMRecipes.size((ItemStack)ItemMaterialsLB.GEMS_GLOWIUM[0], (int)4), new Object[]{"G", Character.valueOf('G'), new ItemStack((Block)this, 1, DEF_DMG)});
                if (!ChiselHelper.isInstalled()) {
                    LatBlocksItems.i_hammer.addRecipe(new ItemStack((Block)this, 1, DEF_DMG), BlockGlowium.ORE_NAME);
                }
                this.mod.recipes.addRecipe(new ItemStack((Block)this, 4, DEF_DMG), new Object[]{"GG", "GG", Character.valueOf('G'), new ItemStack((Block)LatBlocksItems.b_glowium_chiseled, 4, DEF_DMG)});
            }
        }
    }
}

