/*
 * Decompiled with CFR 0.152.
 */
package glassmaker.amtgenerators.gui;

import glassmaker.amtgenerators.tileentity.TileEntityManaTransformer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class HudManaTransformer {
    public static HudManaTransformer instance;
    private ResourceLocation hudTexture = new ResourceLocation("amtgen:textures/gui/hud_mana_transformer.png");
    private boolean useBotaniaHudStyle = false;

    public static void init() {
        instance = new HudManaTransformer();
    }

    public void renderHud(Minecraft minecraft, ScaledResolution scaledResolution, TileEntityManaTransformer manaTransformer) {
        if (this.useBotaniaHudStyle) {
            this.renderBotaniaHud(minecraft, scaledResolution, manaTransformer);
        } else {
            this.renderAmtGenHud(minecraft, scaledResolution, manaTransformer);
        }
    }

    private void renderBotaniaHud(Minecraft minecraft, ScaledResolution scaledResolution, TileEntityManaTransformer manaTransformer) {
    }

    private void renderAmtGenHud(Minecraft minecraft, ScaledResolution scaledResolution, TileEntityManaTransformer manaTransformer) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        String blockName = "tile.amtgen.manaTransformer.name";
        blockName = StatCollector.func_74838_a((String)blockName);
        int x = scaledResolution.func_78326_a() / 2 - minecraft.field_71466_p.func_78256_a(blockName) / 2;
        int y = scaledResolution.func_78328_b() / 2;
        minecraft.field_71466_p.func_78261_a(blockName, x, y + 10, 14212826);
        x = scaledResolution.func_78326_a() / 2 - 51;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        minecraft.field_71446_o.func_110577_a(this.hudTexture);
        int manaScaled = manaTransformer.scaleMana(102);
        this.renderTexturedRect(x, y + 20, 0, 0, 0, 102, 6);
        this.renderTexturedRect(x, y + 21, 0, 0, 6, manaScaled, 4);
        int chargeScaled = manaTransformer.scaleCurrentCharge(102);
        this.renderTexturedRect(x, y + 30, 0, 0, 0, 102, 6);
        this.renderTexturedRect(x, y + 31, 0, 0, 10, chargeScaled, 4);
        if (!manaTransformer.areBarsVisiable()) {
            int unavailableX = scaledResolution.func_78326_a() / 2 - 1;
            this.renderTexturedRect(unavailableX, y + 20, 0, 0, 14, 3, 6);
            this.renderTexturedRect(unavailableX, y + 30, 0, 0, 14, 3, 6);
        }
        String activeStats = manaTransformer.isActive() ? "hud.amtgen.yes" : "hud.amtgen.no";
        activeStats = StatCollector.func_74838_a((String)"hud.amtgen.active") + ": " + StatCollector.func_74838_a((String)activeStats);
        int xActive = scaledResolution.func_78326_a() / 2 - minecraft.field_71466_p.func_78256_a(activeStats) / 2;
        minecraft.field_71466_p.func_78261_a(activeStats, xActive, y + 38, 14212826);
        GL11.glDisable((int)3042);
    }

    private void renderTexturedRect(int x, int y, int z, int u, int v, int width, int height) {
        float textureRatio = 0.00390625f;
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78374_a((double)x, (double)y, (double)z, (double)((float)u * textureRatio), (double)((float)v * textureRatio));
        tess.func_78374_a((double)x, (double)(y + height), (double)z, (double)((float)u * textureRatio), (double)((float)(v + height) * textureRatio));
        tess.func_78374_a((double)(x + width), (double)(y + height), (double)z, (double)((float)(u + width) * textureRatio), (double)((float)(v + height) * textureRatio));
        tess.func_78374_a((double)(x + width), (double)y, (double)z, (double)((float)(u + width) * textureRatio), (double)((float)v * textureRatio));
        tess.func_78381_a();
    }
}

