/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mekanism.api.MekanismConfig;
import mekanism.api.Pos3D;
import mekanism.client.sound.ISoundSource;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IHasSound;
import mekanism.common.base.SoundWrapper;
import mekanism.common.tile.TileEntityElectricBlock;
import net.minecraft.client.audio.ISound;
import net.minecraft.util.ResourceLocation;

public abstract class TileEntityNoisyElectricBlock
extends TileEntityElectricBlock
implements IHasSound,
ISoundSource,
IActiveState {
    public ResourceLocation soundURL;
    @SideOnly(value=Side.CLIENT)
    public SoundWrapper sound;

    public TileEntityNoisyElectricBlock(String soundPath, String name, double maxEnergy) {
        super(name, maxEnergy);
        this.soundURL = new ResourceLocation("mekanism", "tile." + soundPath);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SoundWrapper getSound() {
        return this.sound;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldPlaySound() {
        return this.getActive() && !this.func_145837_r();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getSoundLocation() {
        return this.soundURL;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getVolume() {
        return 1.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getPitch() {
        return 1.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Pos3D getSoundPosition() {
        return new Pos3D((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRepeat() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getRepeatDelay() {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ISound.AttenuationType getAttenuation() {
        return ISound.AttenuationType.LINEAR;
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b.field_72995_K) {
            this.initSounds();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void initSounds() {
        this.sound = new SoundWrapper(this, this);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K) {
            this.updateSound();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateSound() {
        if (this.shouldPlaySound() && this.getSound().canRestart() && MekanismConfig.client.enableMachineSounds) {
            this.getSound().reset();
            this.getSound().play();
        }
    }
}

