/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.api.Range4D;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.Upgrade;
import mekanism.common.base.IEjector;
import mekanism.common.base.IElectricMachine;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.integration.IComputerIntegration;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.outputs.MachineOutput;
import mekanism.common.tile.TileEntityNoisyElectricBlock;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.MekanismUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityBasicMachine<INPUT extends MachineInput<INPUT>, OUTPUT extends MachineOutput<OUTPUT>, RECIPE extends MachineRecipe<INPUT, OUTPUT, RECIPE>>
extends TileEntityNoisyElectricBlock
implements IElectricMachine<INPUT, OUTPUT, RECIPE>,
IComputerIntegration,
ISideConfiguration,
IUpgradeTile,
IRedstoneControl {
    public double BASE_ENERGY_PER_TICK;
    public double energyPerTick;
    public int operatingTicks = 0;
    public int BASE_TICKS_REQUIRED;
    public int ticksRequired;
    public int updateDelay;
    public boolean isActive;
    public boolean clientActive;
    public ResourceLocation guiLocation;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public double prevEnergy;
    public RECIPE cachedRecipe = null;
    public TileComponentUpgrade upgradeComponent;
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent;

    public TileEntityBasicMachine(String soundPath, String name, ResourceLocation location, double perTick, int baseTicksRequired, double maxEnergy) {
        super("machine." + soundPath, name, maxEnergy);
        this.BASE_ENERGY_PER_TICK = perTick;
        this.energyPerTick = perTick;
        this.BASE_TICKS_REQUIRED = baseTicksRequired;
        this.ticksRequired = baseTicksRequired;
        this.guiLocation = location;
        this.isActive = false;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K && this.updateDelay > 0) {
            --this.updateDelay;
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (!this.field_145850_b.field_72995_K && this.updateDelay > 0) {
            --this.updateDelay;
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            }
        }
    }

    @Override
    public EnumSet<ForgeDirection> getConsumingSides() {
        return this.configComponent.getSidesForData(TransmissionType.ENERGY, this.facing, 1);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.operatingTicks = nbtTags.func_74762_e("operatingTicks");
        this.clientActive = this.isActive = nbtTags.func_74767_n("isActive");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74768_a("operatingTicks", this.operatingTicks);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        this.operatingTicks = dataStream.readInt();
        this.clientActive = dataStream.readBoolean();
        this.ticksRequired = dataStream.readInt();
        this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        if (this.updateDelay == 0 && this.clientActive != this.isActive) {
            this.updateDelay = MekanismConfig.general.UPDATE_DELAY;
            this.isActive = this.clientActive;
            MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.operatingTicks);
        data.add(this.isActive);
        data.add(this.ticksRequired);
        data.add(this.controlType.ordinal());
        return data;
    }

    public double getScaledProgress() {
        return (double)this.operatingTicks / (double)this.ticksRequired;
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        switch (upgrade) {
            case SPEED: {
                this.ticksRequired = MekanismUtils.getTicks(this, this.BASE_TICKS_REQUIRED);
                this.energyPerTick = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK);
                break;
            }
            case ENERGY: {
                this.energyPerTick = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK);
                this.maxEnergy = MekanismUtils.getMaxEnergy(this, this.BASE_MAX_ENERGY);
                break;
            }
        }
    }

    @Override
    public boolean canSetFacing(int facing) {
        return facing != 0 && facing != 1;
    }

    @Override
    public int[] func_94128_d(int side) {
        return this.configComponent.getOutput((TransmissionType)TransmissionType.ITEM, (int)side, (int)this.facing).availableSlots;
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public int getOrientation() {
        return this.facing;
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public IEjector getEjector() {
        return this.ejectorComponent;
    }
}

