/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.ExtendedMOP;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.render.CCModel;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.ISidedHollowConnect;
import codechicken.multipart.INeighborTileChange;
import codechicken.multipart.IconHitEffects;
import codechicken.multipart.JIconHitEffects;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.PartMap;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TSlottedPart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.IConfigurable;
import mekanism.api.MekanismConfig;
import mekanism.api.transmitters.IBlockableConnection;
import mekanism.api.transmitters.ITransmitter;
import mekanism.api.transmitters.ITransmitterTile;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.render.RenderPartTransmitter;
import mekanism.common.MekanismItems;
import mekanism.common.Tier;
import mekanism.common.base.ITileNetwork;
import mekanism.common.multipart.PartDiversionTransporter;
import mekanism.common.multipart.PartHeatTransmitter;
import mekanism.common.multipart.PartLogisticalTransporter;
import mekanism.common.multipart.PartMechanicalPipe;
import mekanism.common.multipart.PartPressurizedTube;
import mekanism.common.multipart.PartRestrictiveTransporter;
import mekanism.common.multipart.PartUniversalCable;
import mekanism.common.multipart.TransmitterType;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class PartSidedPipe
extends TMultiPart
implements TSlottedPart,
JNormalOcclusion,
ISidedHollowConnect,
JIconHitEffects,
ITileNetwork,
IBlockableConnection,
IConfigurable,
ITransmitter,
INeighborTileChange {
    public static IndexedCuboid6[] smallSides = new IndexedCuboid6[7];
    public static IndexedCuboid6[] largeSides = new IndexedCuboid6[7];
    public int delayTicks;
    public ForgeDirection testingSide = null;
    public byte currentAcceptorConnections = 0;
    public byte currentTransmitterConnections = 0;
    public boolean sendDesc = false;
    public boolean redstonePowered = false;
    public boolean redstoneReactive = true;
    public ConnectionType[] connectionTypes = new ConnectionType[]{ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL};
    public TileEntity[] cachedAcceptors = new TileEntity[6];

    public static TMultiPart getPartType(TransmitterType type) {
        switch (type) {
            case UNIVERSAL_CABLE_BASIC: {
                return new PartUniversalCable(Tier.CableTier.BASIC);
            }
            case UNIVERSAL_CABLE_ADVANCED: {
                return new PartUniversalCable(Tier.CableTier.ADVANCED);
            }
            case UNIVERSAL_CABLE_ELITE: {
                return new PartUniversalCable(Tier.CableTier.ELITE);
            }
            case UNIVERSAL_CABLE_ULTIMATE: {
                return new PartUniversalCable(Tier.CableTier.ULTIMATE);
            }
            case MECHANICAL_PIPE_BASIC: {
                return new PartMechanicalPipe(Tier.PipeTier.BASIC);
            }
            case MECHANICAL_PIPE_ADVANCED: {
                return new PartMechanicalPipe(Tier.PipeTier.ADVANCED);
            }
            case MECHANICAL_PIPE_ELITE: {
                return new PartMechanicalPipe(Tier.PipeTier.ELITE);
            }
            case MECHANICAL_PIPE_ULTIMATE: {
                return new PartMechanicalPipe(Tier.PipeTier.ULTIMATE);
            }
            case PRESSURIZED_TUBE_BASIC: {
                return new PartPressurizedTube(Tier.TubeTier.BASIC);
            }
            case PRESSURIZED_TUBE_ADVANCED: {
                return new PartPressurizedTube(Tier.TubeTier.ADVANCED);
            }
            case PRESSURIZED_TUBE_ELITE: {
                return new PartPressurizedTube(Tier.TubeTier.ELITE);
            }
            case PRESSURIZED_TUBE_ULTIMATE: {
                return new PartPressurizedTube(Tier.TubeTier.ULTIMATE);
            }
            case LOGISTICAL_TRANSPORTER_BASIC: {
                return new PartLogisticalTransporter(Tier.TransporterTier.BASIC);
            }
            case LOGISTICAL_TRANSPORTER_ADVANCED: {
                return new PartLogisticalTransporter(Tier.TransporterTier.ADVANCED);
            }
            case LOGISTICAL_TRANSPORTER_ELITE: {
                return new PartLogisticalTransporter(Tier.TransporterTier.ELITE);
            }
            case LOGISTICAL_TRANSPORTER_ULTIMATE: {
                return new PartLogisticalTransporter(Tier.TransporterTier.ULTIMATE);
            }
            case RESTRICTIVE_TRANSPORTER: {
                return new PartRestrictiveTransporter();
            }
            case DIVERSION_TRANSPORTER: {
                return new PartDiversionTransporter();
            }
            case HEAT_TRANSMITTER: {
                return new PartHeatTransmitter();
            }
        }
        return null;
    }

    public static boolean connectionMapContainsSide(byte connections, ForgeDirection side) {
        byte tester = (byte)(1 << side.ordinal());
        return (connections & tester) > 0;
    }

    public static byte setConnectionBit(byte connections, boolean toSet, ForgeDirection side) {
        return (byte)(connections & ~((byte)(1 << side.ordinal())) | (byte)((toSet ? 1 : 0) << side.ordinal()));
    }

    public abstract IIcon getCenterIcon(boolean var1);

    public abstract IIcon getSideIcon(boolean var1);

    public abstract IIcon getSideIconRotated(boolean var1);

    public void update() {
        if (this.world().field_72995_K) {
            if (this.delayTicks == 5) {
                this.delayTicks = 6;
                this.refreshConnections();
            } else if (this.delayTicks < 5) {
                ++this.delayTicks;
            }
        }
        if (this.sendDesc && !this.world().field_72995_K) {
            this.sendDescUpdate();
            this.sendDesc = false;
        }
    }

    public boolean handlesRedstone() {
        return true;
    }

    public boolean renderCenter() {
        return false;
    }

    public boolean transparencyRender() {
        return false;
    }

    public IIcon getIconForSide(ForgeDirection side, boolean opaque) {
        ConnectionType type = this.getConnectionType(side);
        if (type == ConnectionType.NONE) {
            if (MekanismConfig.client.oldTransmitterRender || this.renderCenter()) {
                return this.getCenterIcon(opaque);
            }
            if (this.getAllCurrentConnections() == 3 && side != ForgeDirection.DOWN && side != ForgeDirection.UP) {
                return this.getSideIcon(opaque);
            }
            if (this.getAllCurrentConnections() == 12 && (side == ForgeDirection.DOWN || side == ForgeDirection.UP)) {
                return this.getSideIcon(opaque);
            }
            if (this.getAllCurrentConnections() == 12 && (side == ForgeDirection.EAST || side == ForgeDirection.WEST)) {
                return this.getSideIconRotated(opaque);
            }
            if (this.getAllCurrentConnections() == 48 && side != ForgeDirection.EAST && side != ForgeDirection.WEST) {
                return this.getSideIconRotated(opaque);
            }
            return this.getCenterIcon(opaque);
        }
        return this.getSideIcon(opaque);
    }

    public byte getPossibleTransmitterConnections() {
        byte connections = 0;
        if (this.handlesRedstone() && this.redstoneReactive && this.redstonePowered) {
            return connections;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity;
            if (!this.canConnectMutual(side) || !((tileEntity = Coord4D.get((TileEntity)this.tile()).getFromSide(side).getTileEntity((IBlockAccess)this.world())) instanceof ITransmitterTile) || !TransmissionType.checkTransmissionType(((ITransmitterTile)tileEntity).getTransmitter(), this.getTransmitterType().getTransmission()) || !this.isValidTransmitter(tileEntity)) continue;
            connections = (byte)(connections | 1 << side.ordinal());
        }
        return connections;
    }

    public boolean getPossibleAcceptorConnection(ForgeDirection side) {
        TileEntity tileEntity;
        if (this.handlesRedstone() && this.redstoneReactive && this.redstonePowered) {
            return false;
        }
        if (this.canConnectMutual(side) && this.isValidAcceptor(tileEntity = Coord4D.get((TileEntity)this.tile()).getFromSide(side).getTileEntity((IBlockAccess)this.world()), side)) {
            if (this.cachedAcceptors[side.ordinal()] != tileEntity) {
                this.cachedAcceptors[side.ordinal()] = tileEntity;
                this.markDirtyAcceptor(side);
            }
            return true;
        }
        if (this.cachedAcceptors[side.ordinal()] != null) {
            this.cachedAcceptors[side.ordinal()] = null;
            this.markDirtyAcceptor(side);
        }
        return false;
    }

    public boolean getPossibleTransmitterConnection(ForgeDirection side) {
        TileEntity tileEntity;
        if (this.handlesRedstone() && this.redstoneReactive && MekanismUtils.isGettingPowered(this.world(), Coord4D.get((TileEntity)this.tile()))) {
            return false;
        }
        return this.canConnectMutual(side) && (tileEntity = Coord4D.get((TileEntity)this.tile()).getFromSide(side).getTileEntity((IBlockAccess)this.world())) instanceof ITransmitterTile && TransmissionType.checkTransmissionType(((ITransmitterTile)tileEntity).getTransmitter(), this.getTransmitterType().getTransmission()) && this.isValidTransmitter(tileEntity);
    }

    public byte getPossibleAcceptorConnections() {
        byte connections = 0;
        if (this.handlesRedstone() && this.redstoneReactive && this.redstonePowered) {
            return connections;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity;
            if (this.canConnectMutual(side) && this.isValidAcceptor(tileEntity = Coord4D.get((TileEntity)this.tile()).getFromSide(side).getTileEntity((IBlockAccess)this.world()), side)) {
                if (this.cachedAcceptors[side.ordinal()] != tileEntity) {
                    this.cachedAcceptors[side.ordinal()] = tileEntity;
                    this.markDirtyAcceptor(side);
                }
                connections = (byte)(connections | 1 << side.ordinal());
                continue;
            }
            if (this.cachedAcceptors[side.ordinal()] == null) continue;
            this.cachedAcceptors[side.ordinal()] = null;
            this.markDirtyAcceptor(side);
        }
        return connections;
    }

    public byte getAllCurrentConnections() {
        return (byte)(this.currentTransmitterConnections | this.currentAcceptorConnections);
    }

    protected boolean isValidTransmitter(TileEntity tileEntity) {
        return true;
    }

    public boolean occlusionTest(TMultiPart other) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)other);
    }

    public Iterable<IndexedCuboid6> getSubParts() {
        HashSet<IndexedCuboid6> subParts = new HashSet<IndexedCuboid6>();
        if (this.tile() != null) {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                int ord = side.ordinal();
                byte connections = this.getAllCurrentConnections();
                if (!PartSidedPipe.connectionMapContainsSide(connections, side) && side != this.testingSide) continue;
                subParts.add(this.getTransmitterType().getSize() == TransmitterType.Size.SMALL ? smallSides[ord] : largeSides[ord]);
            }
        }
        subParts.add(this.getTransmitterType().getSize() == TransmitterType.Size.SMALL ? smallSides[6] : largeSides[6]);
        return subParts;
    }

    public abstract TransmitterType getTransmitterType();

    public Iterable<Cuboid6> getCollisionBoxes() {
        HashSet<Cuboid6> collisionBoxes = new HashSet<Cuboid6>();
        collisionBoxes.addAll((Collection)this.getSubParts());
        return collisionBoxes;
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        return this.getCollisionBoxes();
    }

    public int getSlotMask() {
        return PartMap.CENTER.mask;
    }

    public IIcon getBreakingIcon(Object subPart, int side) {
        return this.getCenterIcon(true);
    }

    public IIcon getBrokenIcon(int side) {
        return this.getCenterIcon(true);
    }

    public Cuboid6 getBounds() {
        return this.getTransmitterType().getSize() == TransmitterType.Size.SMALL ? smallSides[6] : largeSides[6];
    }

    public int getHollowSize(int side) {
        ForgeDirection direction = ForgeDirection.getOrientation((int)side);
        if (PartSidedPipe.connectionMapContainsSide(this.getAllCurrentConnections(), direction) || direction == this.testingSide) {
            return this.getTransmitterType().getSize().centerSize + 1;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderStatic(Vector3 pos, int pass) {
        if (pass == 0) {
            RenderPartTransmitter.getInstance().renderStatic(this, pass);
            return true;
        }
        if (pass == 1 && this.transparencyRender()) {
            RenderPartTransmitter.getInstance().renderStatic(this, pass);
            return true;
        }
        return false;
    }

    public void addHitEffects(MovingObjectPosition hit, EffectRenderer effectRenderer) {
        IconHitEffects.addHitEffects((JIconHitEffects)this, (MovingObjectPosition)hit, (EffectRenderer)effectRenderer);
    }

    public void addDestroyEffects(MovingObjectPosition mop, EffectRenderer effectRenderer) {
        IconHitEffects.addDestroyEffects((JIconHitEffects)this, (EffectRenderer)effectRenderer, (boolean)false);
    }

    public abstract boolean isValidAcceptor(TileEntity var1, ForgeDirection var2);

    @Override
    public boolean canConnectMutual(ForgeDirection side) {
        if (!this.canConnect(side)) {
            return false;
        }
        TileEntity tile = Coord4D.get((TileEntity)this.tile()).getFromSide(side).getTileEntity((IBlockAccess)this.world());
        return !(tile instanceof IBlockableConnection) || ((IBlockableConnection)tile).canConnect(side.getOpposite());
    }

    @Override
    public boolean canConnect(ForgeDirection side) {
        if (this.handlesRedstone() && this.redstoneReactive && this.redstonePowered) {
            return false;
        }
        this.testingSide = side;
        boolean unblocked = this.tile().canReplacePart((TMultiPart)this, (TMultiPart)this);
        this.testingSide = null;
        return unblocked;
    }

    public void readDesc(MCDataInput packet) {
        this.currentTransmitterConnections = packet.readByte();
        this.currentAcceptorConnections = packet.readByte();
        for (int i = 0; i < 6; ++i) {
            this.connectionTypes[i] = ConnectionType.values()[packet.readInt()];
        }
        if (this.tile() != null) {
            this.tile().internalPartChange((TMultiPart)this);
            this.tile().markRender();
        }
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeByte((int)this.currentTransmitterConnections);
        packet.writeByte((int)this.currentAcceptorConnections);
        for (int i = 0; i < 6; ++i) {
            packet.writeInt(this.connectionTypes[i].ordinal());
        }
    }

    public void load(NBTTagCompound nbtTags) {
        super.load(nbtTags);
        this.redstoneReactive = nbtTags.func_74767_n("redstoneReactive");
        for (int i = 0; i < 6; ++i) {
            this.connectionTypes[i] = ConnectionType.values()[nbtTags.func_74762_e("connection" + i)];
        }
    }

    public void save(NBTTagCompound nbtTags) {
        super.save(nbtTags);
        nbtTags.func_74757_a("redstoneReactive", this.redstoneReactive);
        for (int i = 0; i < 6; ++i) {
            nbtTags.func_74768_a("connection" + i, this.connectionTypes[i].ordinal());
        }
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition part, ItemStack item) {
        if (item == null) {
            return false;
        }
        if (MekanismUtils.hasUsableWrench(player, this.x(), this.y(), this.z()) && player.func_70093_af()) {
            if (!this.world().field_72995_K) {
                this.tile().dropItems(this.getDrops());
                this.tile().remPart((TMultiPart)this);
            }
            return true;
        }
        return false;
    }

    public Iterable<ItemStack> getDrops() {
        return Collections.singletonList(this.pickItem(null));
    }

    public ItemStack pickItem(MovingObjectPosition hit) {
        return new ItemStack(MekanismItems.PartTransmitter, 1, this.getTransmitterType().ordinal());
    }

    public boolean doesTick() {
        return true;
    }

    protected void onRefresh() {
    }

    public void refreshConnections() {
        this.redstonePowered = this.redstoneReactive ? MekanismUtils.isGettingPowered(this.world(), Coord4D.get((TileEntity)this.tile())) : false;
        byte possibleTransmitters = this.getPossibleTransmitterConnections();
        byte possibleAcceptors = this.getPossibleAcceptorConnections();
        if (!this.world().field_72995_K) {
            if ((possibleTransmitters | possibleAcceptors) != this.getAllCurrentConnections()) {
                this.sendDesc = true;
            }
            this.currentTransmitterConnections = possibleTransmitters;
            this.currentAcceptorConnections = possibleAcceptors;
        }
    }

    public void refreshConnections(ForgeDirection side) {
        this.redstonePowered = this.redstoneReactive ? MekanismUtils.isGettingPowered(this.world(), Coord4D.get((TileEntity)this.tile())) : false;
        boolean possibleTransmitter = this.getPossibleTransmitterConnection(side);
        boolean possibleAcceptor = this.getPossibleAcceptorConnection(side);
        if (!this.world().field_72995_K) {
            if ((possibleTransmitter || possibleAcceptor) != PartSidedPipe.connectionMapContainsSide(this.getAllCurrentConnections(), side)) {
                this.sendDesc = true;
            }
            this.currentTransmitterConnections = PartSidedPipe.setConnectionBit(this.currentTransmitterConnections, possibleTransmitter, side);
            this.currentAcceptorConnections = PartSidedPipe.setConnectionBit(this.currentAcceptorConnections, possibleAcceptor, side);
        }
    }

    protected void onModeChange(ForgeDirection side) {
        this.markDirtyAcceptor(side);
    }

    protected void markDirtyTransmitters() {
        this.notifyTileChange();
    }

    protected void markDirtyAcceptor(ForgeDirection side) {
    }

    public void onAdded() {
        super.onAdded();
        this.refreshConnections();
    }

    public void onChunkLoad() {
        super.onChunkLoad();
        this.refreshConnections();
        this.notifyTileChange();
    }

    public void onNeighborTileChanged(int side, boolean weak) {
        this.refreshConnections(ForgeDirection.getOrientation((int)side));
    }

    public void onNeighborChanged() {
        if (this.handlesRedstone()) {
            boolean prevPowered = this.redstonePowered;
            this.refreshConnections();
            if (prevPowered != this.redstonePowered) {
                this.markDirtyTransmitters();
            }
        }
    }

    public void onPartChanged(TMultiPart part) {
        super.onPartChanged(part);
        byte transmittersBefore = this.currentTransmitterConnections;
        this.refreshConnections();
        if (transmittersBefore != this.currentTransmitterConnections) {
            this.markDirtyTransmitters();
        }
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) throws Exception {
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        return data;
    }

    public ConnectionType getConnectionType(ForgeDirection side) {
        if (!PartSidedPipe.connectionMapContainsSide(this.getAllCurrentConnections(), side)) {
            return ConnectionType.NONE;
        }
        if (PartSidedPipe.connectionMapContainsSide(this.currentTransmitterConnections, side)) {
            return ConnectionType.NORMAL;
        }
        return this.connectionTypes[side.ordinal()];
    }

    public List<ForgeDirection> getConnections(ConnectionType type) {
        ArrayList<ForgeDirection> sides = new ArrayList<ForgeDirection>();
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (this.getConnectionType(side) != type) continue;
            sides.add(side);
        }
        return sides;
    }

    public CCModel getModelForSide(ForgeDirection side, boolean internal) {
        String sideName = side.name().toLowerCase();
        String typeName = this.getConnectionType(side).name().toUpperCase();
        String name = sideName + typeName;
        if (internal) {
            return RenderPartTransmitter.contents_models.get(name);
        }
        if (this.getTransmitterType().getSize() == TransmitterType.Size.LARGE) {
            return RenderPartTransmitter.large_models.get(name);
        }
        return RenderPartTransmitter.small_models.get(name);
    }

    @Override
    public boolean onSneakRightClick(EntityPlayer player, int side) {
        if (!this.world().field_72995_K) {
            ExtendedMOP hit = (ExtendedMOP)RayTracer.retraceBlock((World)this.world(), (EntityPlayer)player, (int)this.x(), (int)this.y(), (int)this.z());
            if (hit == null) {
                return false;
            }
            if (hit.subHit < 6) {
                this.connectionTypes[hit.subHit] = this.connectionTypes[hit.subHit].next();
                this.sendDesc = true;
                this.onModeChange(ForgeDirection.getOrientation((int)hit.subHit));
                player.func_145747_a((IChatComponent)new ChatComponentText("Connection type changed to " + this.connectionTypes[hit.subHit].toString()));
                return true;
            }
            return this.onConfigure(player, hit.subHit, side);
        }
        return true;
    }

    protected boolean onConfigure(EntityPlayer player, int part, int side) {
        return false;
    }

    public EnumColor getRenderColor(boolean opaque) {
        return null;
    }

    @Override
    public boolean onRightClick(EntityPlayer player, int side) {
        if (!this.world().field_72995_K && this.handlesRedstone()) {
            this.redstoneReactive ^= true;
            this.refreshConnections();
            this.notifyTileChange();
            player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " Redstone sensitivity turned " + (Object)((Object)EnumColor.INDIGO) + (this.redstoneReactive ? "on." : "off.")));
        }
        return true;
    }

    public boolean weakTileChanges() {
        return false;
    }

    public void notifyTileChange() {
        MekanismUtils.notifyLoadedNeighborsOfTileChange(this.world(), Coord4D.get((TileEntity)this.tile()));
    }

    static {
        PartSidedPipe.smallSides[0] = new IndexedCuboid6((Object)0, new Cuboid6(0.3, 0.0, 0.3, 0.7, 0.3, 0.7));
        PartSidedPipe.smallSides[1] = new IndexedCuboid6((Object)1, new Cuboid6(0.3, 0.7, 0.3, 0.7, 1.0, 0.7));
        PartSidedPipe.smallSides[2] = new IndexedCuboid6((Object)2, new Cuboid6(0.3, 0.3, 0.0, 0.7, 0.7, 0.3));
        PartSidedPipe.smallSides[3] = new IndexedCuboid6((Object)3, new Cuboid6(0.3, 0.3, 0.7, 0.7, 0.7, 1.0));
        PartSidedPipe.smallSides[4] = new IndexedCuboid6((Object)4, new Cuboid6(0.0, 0.3, 0.3, 0.3, 0.7, 0.7));
        PartSidedPipe.smallSides[5] = new IndexedCuboid6((Object)5, new Cuboid6(0.7, 0.3, 0.3, 1.0, 0.7, 0.7));
        PartSidedPipe.smallSides[6] = new IndexedCuboid6((Object)6, new Cuboid6(0.3, 0.3, 0.3, 0.7, 0.7, 0.7));
        PartSidedPipe.largeSides[0] = new IndexedCuboid6((Object)0, new Cuboid6(0.25, 0.0, 0.25, 0.75, 0.25, 0.75));
        PartSidedPipe.largeSides[1] = new IndexedCuboid6((Object)1, new Cuboid6(0.25, 0.75, 0.25, 0.75, 1.0, 0.75));
        PartSidedPipe.largeSides[2] = new IndexedCuboid6((Object)2, new Cuboid6(0.25, 0.25, 0.0, 0.75, 0.75, 0.25));
        PartSidedPipe.largeSides[3] = new IndexedCuboid6((Object)3, new Cuboid6(0.25, 0.25, 0.75, 0.75, 0.75, 1.0));
        PartSidedPipe.largeSides[4] = new IndexedCuboid6((Object)4, new Cuboid6(0.0, 0.25, 0.25, 0.25, 0.75, 0.75));
        PartSidedPipe.largeSides[5] = new IndexedCuboid6((Object)5, new Cuboid6(0.75, 0.25, 0.25, 1.0, 0.75, 0.75));
        PartSidedPipe.largeSides[6] = new IndexedCuboid6((Object)6, new Cuboid6(0.25, 0.25, 0.25, 0.75, 0.75, 0.75));
    }

    public static enum ConnectionType {
        NORMAL,
        PUSH,
        PULL,
        NONE;


        public ConnectionType next() {
            if (this.ordinal() == ConnectionType.values().length - 1) {
                return NORMAL;
            }
            return ConnectionType.values()[this.ordinal() + 1];
        }
    }
}

