/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.teleportation;

import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.IGasHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class SharedInventory
implements IStrictEnergyStorage,
IFluidHandler,
IGasHandler {
    public String name;
    public double storedEnergy;
    public double MAX_ENERGY = 1000.0;
    public FluidTank storedFluid;
    public GasTank storedGas;
    public ItemStack storedItem;

    public SharedInventory(String freq) {
        this.name = freq;
        this.storedEnergy = 0.0;
        this.storedFluid = new FluidTank(1000);
        this.storedGas = new GasTank(1000);
        this.storedItem = null;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.storedFluid.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource.isFluidEqual(this.storedFluid.getFluid())) {
            return this.storedFluid.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.storedFluid.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.storedFluid.getFluid() == null || fluid == this.storedFluid.getFluid().getFluid();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.storedFluid.getFluid() == null || fluid == this.storedFluid.getFluid().getFluid();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.storedFluid)};
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack, boolean doTransfer) {
        return this.storedGas.receive(stack, doTransfer);
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        return this.receiveGas(side, stack, true);
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount, boolean doTransfer) {
        return this.storedGas.draw(amount, doTransfer);
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount) {
        return this.drawGas(side, amount, true);
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return this.storedGas.getGasType() == null || type == this.storedGas.getGasType();
    }

    @Override
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        return this.storedGas.getGasType() == null || type == this.storedGas.getGasType();
    }

    @Override
    public double getEnergy() {
        return this.storedEnergy;
    }

    @Override
    public void setEnergy(double energy) {
        this.storedEnergy = Math.max(0.0, Math.min(energy, this.MAX_ENERGY));
    }

    @Override
    public double getMaxEnergy() {
        return this.MAX_ENERGY;
    }
}

