/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class StackUtils {
    public static List<ItemStack> split(ItemStack stack) {
        if (stack == null || stack.field_77994_a == 0) {
            return null;
        }
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (stack.field_77994_a == 1) {
            ret.add(stack);
            return ret;
        }
        int remain = stack.field_77994_a % 2;
        int split = (int)((float)stack.field_77994_a / 2.0f);
        ret.add(StackUtils.size(stack, split + remain));
        ret.add(StackUtils.size(stack, split));
        return ret;
    }

    public static Item getItem(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return stack.func_77973_b();
    }

    public static boolean diffIgnoreNull(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.func_77973_b() != stack2.func_77973_b() || stack1.func_77960_j() != stack2.func_77960_j();
    }

    public static boolean equalsWildcard(ItemStack wild, ItemStack check) {
        if (wild == null || check == null) {
            return check == wild;
        }
        return wild.func_77973_b() == check.func_77973_b() && (wild.func_77960_j() == Short.MAX_VALUE || wild.func_77960_j() == check.func_77960_j());
    }

    public static boolean equalsWildcardWithNBT(ItemStack wild, ItemStack check) {
        return StackUtils.equalsWildcard(wild, check) && (wild.field_77990_d == null ? check.field_77990_d == null : wild.field_77990_d == check.field_77990_d || wild.field_77990_d.equals((Object)check.field_77990_d));
    }

    public static List<ItemStack> even(ItemStack stack1, ItemStack stack2) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (StackUtils.getSize(stack1) == StackUtils.getSize(stack2) || Math.abs(StackUtils.getSize(stack1) - StackUtils.getSize(stack2)) == 1) {
            ret.add(stack1);
            ret.add(stack2);
            return ret;
        }
        if (StackUtils.getSize(stack1) > StackUtils.getSize(stack2)) {
            int diff = StackUtils.getSize(stack1) - StackUtils.getSize(stack2);
            List<ItemStack> split = StackUtils.split(StackUtils.size(stack1, diff));
            ret.add(StackUtils.subtract(stack1, split.get(0)));
            ret.add(StackUtils.add(stack2, split.get(0)));
        } else if (StackUtils.getSize(stack2) > StackUtils.getSize(stack1)) {
            int diff = StackUtils.getSize(stack2) - StackUtils.getSize(stack1);
            List<ItemStack> split = StackUtils.split(StackUtils.size(stack2, diff));
            ret.add(StackUtils.subtract(stack2, split.get(0)));
            ret.add(StackUtils.add(stack1, split.get(0)));
        }
        return ret;
    }

    public static ItemStack add(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null) {
            return stack2;
        }
        if (stack2 == null) {
            return stack1;
        }
        return StackUtils.size(stack1, StackUtils.getSize(stack1) + StackUtils.getSize(stack2));
    }

    public static ItemStack subtract(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null) {
            return null;
        }
        if (stack2 == null) {
            return stack1;
        }
        return StackUtils.size(stack1, StackUtils.getSize(stack1) - StackUtils.getSize(stack2));
    }

    public static ItemStack size(ItemStack stack, int size) {
        if (size <= 0 || stack == null) {
            return null;
        }
        ItemStack ret = stack.func_77946_l();
        ret.field_77994_a = size;
        return ret;
    }

    public static ItemStack copy(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return stack.func_77946_l();
    }

    public static int getSize(ItemStack stack) {
        return stack != null ? stack.field_77994_a : 0;
    }

    public static List<ItemStack> getMergeRejects(ItemStack[] orig, ItemStack[] toAdd) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int i = 0; i < toAdd.length; ++i) {
            ItemStack reject;
            if (toAdd[i] == null || (reject = StackUtils.getMergeReject(orig[i], toAdd[i])) == null) continue;
            ret.add(reject);
        }
        return ret;
    }

    public static void merge(ItemStack[] orig, ItemStack[] toAdd) {
        for (int i = 0; i < toAdd.length; ++i) {
            if (toAdd[i] == null) continue;
            orig[i] = StackUtils.merge(orig[i], toAdd[i]);
        }
    }

    public static ItemStack merge(ItemStack orig, ItemStack toAdd) {
        if (orig == null) {
            return toAdd;
        }
        if (toAdd == null) {
            return orig;
        }
        if (!orig.func_77969_a(toAdd) || !ItemStack.func_77970_a((ItemStack)orig, (ItemStack)toAdd)) {
            return orig;
        }
        return StackUtils.size(orig, Math.min(orig.func_77976_d(), orig.field_77994_a + toAdd.field_77994_a));
    }

    public static ItemStack getMergeReject(ItemStack orig, ItemStack toAdd) {
        if (orig == null) {
            return null;
        }
        if (toAdd == null) {
            return orig;
        }
        if (!orig.func_77969_a(toAdd) || !ItemStack.func_77970_a((ItemStack)orig, (ItemStack)toAdd)) {
            return orig;
        }
        int newSize = orig.field_77994_a + toAdd.field_77994_a;
        if (newSize > orig.func_77976_d()) {
            return StackUtils.size(orig, newSize - orig.func_77976_d());
        }
        return StackUtils.size(orig, newSize);
    }

    public static boolean contains(ItemStack container, ItemStack contained) {
        return StackUtils.equalsWildcardWithNBT(contained, container) && container.field_77994_a >= contained.field_77994_a;
    }

    public static int hashItemStack(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return -1;
        }
        String name = stack.func_77960_j() == Short.MAX_VALUE ? stack.func_77973_b().func_77658_a() : stack.func_77973_b().func_77667_c(stack);
        return name.hashCode() << 8 | stack.func_77960_j();
    }
}

