/*
 * Decompiled with CFR 0.152.
 */
package main.ironbackpacks.util;

import java.util.ArrayList;
import main.ironbackpacks.items.backpacks.ItemBaseBackpack;
import main.ironbackpacks.proxies.CommonProxy;
import main.ironbackpacks.util.IronBackpacksConstants;
import main.ironbackpacks.util.NBTHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class IronBackpacksHelper {
    public static ItemStack getBackpack(EntityPlayer player) {
        ItemStack backpack = null;
        ItemStack proxyPack = CommonProxy.getCurrBackpack(player);
        backpack = proxyPack != null ? proxyPack : IronBackpacksHelper.getBackpackFromPlayersInventory(player);
        if (!player.field_70170_p.field_72995_K && backpack != null) {
            NBTHelper.setUUID(backpack);
        }
        return backpack;
    }

    public static ItemStack getBackpackFromPlayersInventory(EntityPlayer player) {
        ItemStack backpack = null;
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemBaseBackpack) {
            backpack = player.func_70694_bm();
        } else {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || stack.func_77973_b() == null || !(stack.func_77973_b() instanceof ItemBaseBackpack)) continue;
                backpack = player.field_71071_by.func_70301_a(i);
            }
        }
        if (!player.field_70170_p.field_72995_K && backpack != null) {
            NBTHelper.setUUID(backpack);
        }
        return backpack;
    }

    public static int[] getUpgradesAppliedFromNBT(ItemStack stack) {
        NBTTagCompound nbtTagCompound;
        ArrayList<Integer> upgradesArrayList = new ArrayList<Integer>();
        if (stack != null && (nbtTagCompound = stack.func_77978_p()) != null && nbtTagCompound.func_74764_b("Upgrades")) {
            NBTTagList tagList = nbtTagCompound.func_150295_c("Upgrades", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = tagList.func_150305_b(i);
                byte hasUpgrade = stackTag.func_74771_c("Upgrade");
                if (hasUpgrade == 0) continue;
                upgradesArrayList.add(Integer.valueOf(hasUpgrade));
            }
        }
        int[] ret = new int[upgradesArrayList.size()];
        int i = 0;
        for (Integer e : upgradesArrayList) {
            ret[i++] = e;
        }
        return ret;
    }

    public static int getUpgradePointsUsed(int[] upgrades) {
        int counter = 0;
        for (int upgrade : upgrades) {
            counter += IronBackpacksConstants.Upgrades.UPGRADE_POINTS[upgrade];
        }
        return counter;
    }

    public static int getTotalUpgradePointsFromNBT(ItemStack stack) {
        ItemBaseBackpack backpack = (ItemBaseBackpack)stack.func_77973_b();
        int upgradeCount = backpack.getUpgradeSlots();
        int extraPoints = IronBackpacksHelper.getAdditionalUpgradesUpgradeCount(stack);
        return upgradeCount + extraPoints;
    }

    public static int getAdditionalUpgradesUpgradeCount(ItemStack stack) {
        NBTTagCompound nbtTagCompound;
        if (stack != null && (nbtTagCompound = stack.func_77978_p()) != null && nbtTagCompound.func_74764_b("AdditionalPoints")) {
            return nbtTagCompound.func_74759_k("AdditionalPoints")[0];
        }
        return 0;
    }

    public static int getAdditionalUpgradesTimesApplied(ItemStack stack) {
        NBTTagCompound nbtTagCompound;
        if (stack != null && (nbtTagCompound = stack.func_77978_p()) != null && nbtTagCompound.func_74764_b("AdditionalPoints")) {
            return nbtTagCompound.func_74759_k("AdditionalPoints")[1];
        }
        return 0;
    }
}

