/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.entities;

import com.vanhal.progressiveautomation.PAConfig;
import com.vanhal.progressiveautomation.ProgressiveAutomation;
import com.vanhal.progressiveautomation.entities.BaseTileEntity;
import com.vanhal.progressiveautomation.entities.IUpgradeable;
import com.vanhal.progressiveautomation.items.upgrades.ItemUpgrade;
import com.vanhal.progressiveautomation.ref.ToolHelper;
import com.vanhal.progressiveautomation.upgrades.UpgradeType;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class UpgradeableTileEntity
extends BaseTileEntity
implements IUpgradeable {
    protected int toolLevel = 0;
    private Map<UpgradeType, Integer> installedUpgrades = new EnumMap<UpgradeType, Integer>(UpgradeType.class);
    private Set<UpgradeType> allowedUpgrades = Collections.emptySet();
    protected int advancedToolFlash = 0;

    public UpgradeableTileEntity(int numSlots) {
        super(numSlots);
    }

    @Override
    public void writeCommonNBT(NBTTagCompound nbt) {
        super.writeCommonNBT(nbt);
        NBTTagCompound tag = new NBTTagCompound();
        for (Map.Entry<UpgradeType, Integer> mapEntry : this.installedUpgrades.entrySet()) {
            tag.func_74768_a(mapEntry.getKey().name(), mapEntry.getValue().intValue());
        }
        nbt.func_74782_a("installedUpgrades", (NBTBase)tag);
        nbt.func_74768_a("advancedToolFlash", this.advancedToolFlash);
    }

    @Override
    public void readCommonNBT(NBTTagCompound nbt) {
        super.readCommonNBT(nbt);
        this.readLegacyNBT(nbt);
        NBTTagCompound tag = nbt.func_74775_l("installedUpgrades");
        if (tag != null) {
            for (Object key : tag.func_150296_c()) {
                String upgradeName = (String)key;
                this.installedUpgrades.put(UpgradeType.valueOf(upgradeName), tag.func_74762_e(upgradeName));
            }
        }
        if (nbt.func_74764_b("advancedToolFlash")) {
            this.advancedToolFlash = nbt.func_74762_e("advancedToolFlash");
        }
    }

    @Deprecated
    private void readLegacyNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("NumUpgrades") && nbt.func_74762_e("NumUpgrades") > 0) {
            this.installedUpgrades.put(UpgradeType.getRangeUpgrade(this.toolLevel), nbt.func_74762_e("NumUpgrades"));
        }
        if (nbt.func_74764_b("hasWitherUpgrade") && nbt.func_74762_e("hasWitherUpgrade") > 0) {
            this.installedUpgrades.put(UpgradeType.WITHER, nbt.func_74762_e("hasWitherUpgrade"));
        }
        if (nbt.func_74764_b("hasCobbleUpgrade") && nbt.func_74762_e("hasCobbleUpgrade") > 0) {
            this.installedUpgrades.put(UpgradeType.COBBLE_GEN, nbt.func_74762_e("hasCobbleUpgrade"));
        }
        if (nbt.func_74764_b("hasFillerUpgrade") && nbt.func_74762_e("hasFillerUpgrade") > 0) {
            this.installedUpgrades.put(UpgradeType.FILLER, nbt.func_74762_e("hasFillerUpgrade"));
        }
    }

    public void setInvalidTool() {
        this.advancedToolFlash = 30;
    }

    public boolean isInvalidTool() {
        return this.advancedToolFlash > 0;
    }

    @Override
    public boolean hasUpgrade(UpgradeType type) {
        return this.installedUpgrades.get((Object)type) != null;
    }

    @Override
    public Integer getUpgradeAmount(UpgradeType type) {
        if (!this.installedUpgrades.containsKey((Object)type)) {
            return 0;
        }
        Integer upgradeAmount = this.installedUpgrades.get((Object)type);
        return upgradeAmount != null ? upgradeAmount : 0;
    }

    @Override
    public void addUpgrade(UpgradeType type, Integer amount) {
        this.setUpgradeAmount(type, this.getUpgradeAmount(type) + amount);
    }

    @Override
    public void setUpgradeAmount(UpgradeType type, Integer amount) {
        this.installedUpgrades.put(type, amount);
        NBTTagCompound tag = this.getCompoundTagFromPartialUpdate("installedUpgrades");
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74768_a(type.name(), amount.intValue());
        this.addPartialUpdate("installedUpgrades", tag);
        this.notifyUpdate();
    }

    @Override
    public void removeUpgradeCompletely(UpgradeType type) {
        this.installedUpgrades.remove((Object)type);
        NBTTagCompound tag = this.getCompoundTagFromPartialUpdate("installedUpgrades");
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74768_a(type.name(), 0);
        this.addPartialUpdate("upgrades", tag);
    }

    @Override
    public Set<UpgradeType> getInstalledUpgradeTypes() {
        return this.installedUpgrades.keySet();
    }

    @Override
    public int getUpgrades() {
        return this.getUpgradeAmount(UpgradeType.getRangeUpgrade(this.toolLevel));
    }

    @Override
    public void setUpgrades(int value) {
        UpgradeType type = UpgradeType.getRangeUpgrade(this.toolLevel);
        this.setUpgradeAmount(type, value);
    }

    @Override
    public void addUpgrades(int addValue) {
        this.addUpgrade(UpgradeType.getRangeUpgrade(this.toolLevel), addValue);
    }

    @Override
    public int getRange() {
        int range = this.getUpgrades() * PAConfig.upgradeRange + 1;
        if (this.hasUpgrade(UpgradeType.WITHER)) {
            range *= PAConfig.witherMultiplier;
        }
        return range;
    }

    @Override
    public int getUpgradeLevel() {
        return this.toolLevel;
    }

    @Override
    public void setUpgradeLevel(int level) {
        this.toolLevel = level;
    }

    @Override
    public boolean isAllowedUpgrade(UpgradeType type) {
        return this.allowedUpgrades.contains((Object)type);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            ItemStack upgrade;
            ItemStack itemStack = upgrade = this.SLOT_UPGRADE != -1 ? this.func_70301_a(this.SLOT_UPGRADE) : null;
            if (upgrade != null && upgrade.field_77994_a > 0) {
                ItemUpgrade upgradeItem = (ItemUpgrade)upgrade.func_77973_b();
                UpgradeType type = upgradeItem.getType();
                int installedAmount = this.getUpgradeAmount(type);
                if (this.allowedUpgrades.contains((Object)upgradeItem.getType()) && installedAmount < upgradeItem.allowedAmount()) {
                    int newTotal = installedAmount + upgrade.field_77994_a;
                    upgrade.field_77994_a = newTotal <= upgradeItem.allowedAmount() ? 0 : newTotal - upgradeItem.allowedAmount();
                    this.setUpgradeAmount(type, newTotal -= upgrade.field_77994_a);
                }
                if (upgrade.field_77994_a <= 0) {
                    this.slots[this.SLOT_UPGRADE] = null;
                }
            } else if (upgrade != null) {
                ProgressiveAutomation.logger.warn("Inserted ItemStack with stacksize <= 0. Deleting");
                this.slots[this.SLOT_UPGRADE] = null;
            }
        }
        if (this.advancedToolFlash > 0) {
            --this.advancedToolFlash;
            if (this.advancedToolFlash < 0) {
                this.advancedToolFlash = 0;
            }
        }
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == this.SLOT_PICKAXE && ToolHelper.getType(stack) == ToolHelper.TYPE_PICKAXE ? ToolHelper.getLevel(stack) <= PAConfig.getToolConfigLevel(this.getUpgradeLevel()) && !ToolHelper.isBroken(stack) : (slot == this.SLOT_SHOVEL && ToolHelper.getType(stack) == ToolHelper.TYPE_SHOVEL ? ToolHelper.getLevel(stack) <= PAConfig.getToolConfigLevel(this.getUpgradeLevel()) && !ToolHelper.isBroken(stack) : (slot == this.SLOT_AXE && ToolHelper.getType(stack) == ToolHelper.TYPE_AXE ? ToolHelper.getLevel(stack) <= PAConfig.getToolConfigLevel(this.getUpgradeLevel()) && !ToolHelper.isBroken(stack) : (slot == this.SLOT_SWORD && ToolHelper.getType(stack) == ToolHelper.TYPE_SWORD ? ToolHelper.getLevel(stack) <= PAConfig.getToolConfigLevel(this.getUpgradeLevel()) && !ToolHelper.isBroken(stack) : (slot == this.SLOT_HOE && ToolHelper.getType(stack) == ToolHelper.TYPE_HOE ? ToolHelper.getLevel(stack) <= PAConfig.getToolConfigLevel(this.getUpgradeLevel()) && !ToolHelper.isBroken(stack) : slot == this.SLOT_UPGRADE && stack.func_77969_a(ToolHelper.getUpgradeType(this.getUpgradeLevel()))))))) {
            return true;
        }
        return super.func_94041_b(slot, stack);
    }

    protected Set<UpgradeType> getAllowedUpgrades() {
        return this.allowedUpgrades;
    }

    protected void setAllowedUpgrades(Set<UpgradeType> allowedUpgrades) {
        this.allowedUpgrades = allowedUpgrades;
    }

    protected void setAllowedUpgrades(UpgradeType first, UpgradeType ... rest) {
        this.allowedUpgrades = EnumSet.of(first, rest);
    }

    protected void addAllowedUpgrade(UpgradeType upgrade) {
        if (this.allowedUpgrades != null) {
            this.allowedUpgrades.add(upgrade);
        }
    }
}

