/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.method;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import openperipheral.adapter.method.Argument;
import openperipheral.api.adapter.method.ArgType;
import openperipheral.api.converter.IConverter;

public class VarArgument
extends Argument {
    public VarArgument(String name, String description, ArgType luaType, TypeToken<?> javaType, int javaArgIndex) {
        super(name, description, luaType, javaType, javaArgIndex);
    }

    @Override
    protected TypeToken<?> getArgType(TypeToken<?> javaArgClass) {
        Preconditions.checkArgument((boolean)javaArgClass.isArray(), (Object)"Vararg type must be array");
        return javaArgClass.getComponentType();
    }

    protected void checkArgument(Object value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Vararg parameter '%s' has null value, but is not marked as nullable", (Object[])new Object[]{this.name});
    }

    @Override
    public Object convert(IConverter converter, Iterator<Object> args) {
        ArrayList allArgs = Lists.newArrayList(args);
        Object vararg = Array.newInstance(this.javaType.getRawType(), allArgs.size());
        for (int i = 0; i < allArgs.size(); ++i) {
            Object value = allArgs.get(i);
            this.checkArgument(value);
            Object converted = this.convertSingleArg(converter, value);
            Array.set(vararg, i, converted);
        }
        return vararg;
    }

    @Override
    public String toString() {
        return this.name + "...";
    }

    @Override
    public boolean variadic() {
        return true;
    }
}

