/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.method;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.util.Iterator;
import openperipheral.adapter.ArgumentDescriptionBase;
import openperipheral.api.adapter.method.ArgType;
import openperipheral.api.converter.IConverter;
import openperipheral.util.DocUtils;

public class Argument
extends ArgumentDescriptionBase {
    public final TypeToken<?> javaType;
    final int javaArgIndex;

    public Argument(String name, String description, ArgType type, TypeToken<?> javaType, int javaArgIndex) {
        super(name, type, description);
        this.javaArgIndex = javaArgIndex;
        this.javaType = this.getArgType(javaType);
        this.range = DocUtils.createRangeString(this.javaType);
    }

    protected TypeToken<?> getArgType(TypeToken<?> javaArgClass) {
        return javaArgClass;
    }

    public Object convert(IConverter converter, Iterator<Object> args) {
        Preconditions.checkArgument((boolean)args.hasNext(), (String)"Not enough arguments, first missing: %s", (Object[])new Object[]{this.name});
        Object arg = args.next();
        Preconditions.checkArgument((arg != null ? 1 : 0) != 0, (String)"Argument %s cannot be null", (Object[])new Object[]{this.name});
        return this.convertSingleArg(converter, arg);
    }

    protected final Object convertSingleArg(IConverter converter, Object o) {
        try {
            return converter.toJava(o, this.javaType.getType());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Failed to convert arg '%s'", this.name), e);
        }
    }

    public String toString() {
        return this.name;
    }
}

