/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.machine.entangler;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import java.util.UUID;
import jotato.quantumflux.ConfigMan;
import jotato.quantumflux.redflux.IRedfluxProvider;
import jotato.quantumflux.redflux.RedfluxField;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityRFEntangler
extends TileEntity
implements IEnergyReceiver,
IRedfluxProvider {
    public UUID owner;
    private long lastIn;
    private long lastOut;
    public long reportedIn;
    public long reportedOut;
    private EnergyStorage storage = new EnergyStorage(ConfigMan.redfluxField_buffer, Integer.MAX_VALUE);

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        int taken = this.storage.receiveEnergy(maxReceive, simulate);
        if (!simulate) {
            if (!this.field_145850_b.field_72995_K) {
                this.lastIn += (long)taken;
            }
            this.func_70296_d();
        }
        return taken;
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagCompound energyTag = new NBTTagCompound();
        this.storage.writeToNBT(energyTag);
        tag.func_74782_a("Energy", (NBTBase)energyTag);
        tag.func_74778_a("owner", this.owner.toString());
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagCompound energyTag = tag.func_74775_l("Energy");
        this.storage.readFromNBT(energyTag);
        this.owner = UUID.fromString(tag.func_74779_i("owner"));
        this.registerWithField();
    }

    @Override
    public boolean canSend() {
        return true;
    }

    @Override
    public boolean canReceive() {
        return false;
    }

    @Override
    public int requestEnergy(int energy, boolean simulate) {
        int given = this.storage.extractEnergy(energy, simulate);
        if (!simulate) {
            this.func_70296_d();
            if (!this.field_145850_b.field_72995_K) {
                this.lastOut += (long)given;
            }
        }
        return given;
    }

    @Override
    public int receiveEnergy(int energy, boolean simulate) {
        return energy;
    }

    public void deregisterWithField() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            RedfluxField.removeLink(this);
        }
    }

    public void registerWithField() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            RedfluxField.registerLink(this);
        }
    }

    @Override
    public String getOwner() {
        if (this.owner == null) {
            return null;
        }
        return this.owner.toString();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.deregisterWithField();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.deregisterWithField();
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.registerWithField();
    }

    public void func_145845_h() {
        this.reportedOut = this.lastOut;
        this.reportedIn = this.lastIn;
        this.lastIn = 0L;
        this.lastOut = 0L;
    }
}

