/*
 * Decompiled with CFR 0.152.
 */
package com.vapourdrive.magtools.items.tools;

import com.vapourdrive.magtools.MagTools;
import com.vapourdrive.magtools.config.ConfigInfo;
import com.vapourdrive.magtools.items.MagItemRef;
import com.vapourdrive.magtools.utils.RandomUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C07PacketPlayerDigging;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.world.BlockEvent;

public class MagHammer
extends ItemPickaxe {
    public MagHammer(Item.ToolMaterial material) {
        super(material);
        this.func_77655_b(MagItemRef.MagHammerName);
        this.func_77637_a(MagTools.MagCreativeTab);
        if ((float)ConfigInfo.MagHammerDurability != ConfigInfo.MagDamage) {
            this.func_77656_e(ConfigInfo.MagHammerDurability);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("magnanimoustools:" + MagItemRef.MagHammerName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean useExtraInformation) {
        list.add(EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"phrase.magtools.hammerinfo"));
        float Bonus = (float)player.field_71068_ca / 75.0f;
        if (ConfigInfo.EnableXPSpeed) {
            list.add(EnumChatFormatting.GREEN + "Goes " + new DecimalFormat("#.##").format(1.0f + Bonus) + " Times Faster");
        }
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        World world = player.field_70170_p;
        Block block = world.func_147439_a(x, y, z);
        MovingObjectPosition object = RandomUtils.raytraceFromEntity(world, (Entity)player, false, 4.5);
        if (object == null) {
            return super.func_150894_a(stack, world, block, x, y, z, (EntityLivingBase)player);
        }
        int side = object.field_72310_e;
        int xmove = 0;
        int ymove = 0;
        int zmove = 0;
        if (side == 0 || side == 1) {
            xmove = 1;
            zmove = 1;
        } else {
            ymove = 1;
            if (side == 4 || side == 5) {
                zmove = 1;
            } else {
                xmove = 1;
            }
        }
        float strength = ForgeHooks.blockStrength((Block)block, (EntityPlayer)player, (World)world, (int)x, (int)y, (int)z);
        if (player.func_70093_af() && ConfigInfo.EnableHammerShiftOneBlock && (player.field_71068_ca >= 20 || player.field_71075_bZ.field_75098_d)) {
            this.checkBlockBreak(world, player, x, y, z, stack, strength, block, side);
        } else {
            for (int i = -xmove; i <= xmove; ++i) {
                for (int j = -ymove; j <= ymove; ++j) {
                    for (int k = -zmove; k <= zmove; ++k) {
                        if (i == x || j == y || k == z) continue;
                        this.checkBlockBreak(world, player, x + i, y + j, z + k, stack, strength, block, side);
                    }
                }
            }
        }
        return false;
    }

    public void checkBlockBreak(World world, EntityPlayer player, int x, int y, int z, ItemStack stack, float strength, Block originalBlock, int side) {
        Block breakBlock = world.func_147439_a(x, y, z);
        if (this.canHarvestBlock(breakBlock, stack)) {
            float newStrength = ForgeHooks.blockStrength((Block)breakBlock, (EntityPlayer)player, (World)world, (int)x, (int)y, (int)z);
            Material material = originalBlock.func_149688_o();
            if (newStrength > 0.0f && strength / newStrength <= 10.0f && breakBlock.func_149688_o() == material) {
                this.breakBlock(world, breakBlock, x, y, z, side, player);
                if ((double)breakBlock.func_149712_f(world, x, y, z) != 0.0) {
                    stack.func_77972_a(1, (EntityLivingBase)player);
                }
            }
        }
    }

    public boolean breakBlock(World world, Block block, int x, int y, int z, int side, EntityPlayer player) {
        int meta;
        if (world.func_147437_c(x, y, z)) {
            return false;
        }
        EntityPlayerMP playerMP = null;
        if (player instanceof EntityPlayerMP) {
            playerMP = (EntityPlayerMP)player;
        }
        if (block.getHarvestTool(meta = world.func_72805_g(x, y, z)) != "pickaxe" || !this.canHarvestBlock(block, player.func_71045_bC()) || !ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (int)meta)) {
            return false;
        }
        if (playerMP != null) {
            BlockEvent.BreakEvent event = ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)playerMP.field_71134_c.func_73081_b(), (EntityPlayerMP)playerMP, (int)x, (int)y, (int)z);
            int drop = event.getExpToDrop();
            block.func_149657_c(world, x, y, z, drop);
            world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) | world.func_72805_g(x, y, z) << 12);
            if (event.isCanceled()) {
                return false;
            }
        }
        if (player.field_71075_bZ.field_75098_d) {
            if (!world.field_72995_K) {
                block.func_149681_a(world, x, y, z, meta, player);
            }
            if (block.removedByPlayer(world, player, x, y, z, false)) {
                block.func_149664_b(world, x, y, z, meta);
            }
            if (!world.field_72995_K) {
                playerMP.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, world));
            } else {
                Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C07PacketPlayerDigging(2, x, y, z, side));
            }
            return true;
        }
        if (!world.field_72995_K) {
            block.func_149681_a(world, x, y, z, meta, player);
            if (block.removedByPlayer(world, player, x, y, z, true)) {
                block.func_149664_b(world, x, y, z, meta);
                if (!player.field_71075_bZ.field_75098_d) {
                    block.func_149636_a(world, player, x, y, z, meta);
                }
            }
            playerMP.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, world));
        } else {
            if (block.removedByPlayer(world, player, x, y, z, true)) {
                block.func_149664_b(world, x, y, z, meta);
            }
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C07PacketPlayerDigging(2, x, y, z, side));
        }
        return true;
    }
}

