/*
 * Decompiled with CFR 0.152.
 */
package com.vapourdrive.magtools.anvilhandler;

import com.vapourdrive.magtools.anvilhandler.AnvilManager;
import com.vapourdrive.magtools.anvilhandler.IAnvilRecipe;
import java.util.List;
import net.minecraft.item.ItemStack;

public class AnvilRecipe
implements IAnvilRecipe {
    public final ItemStack leftItem;
    public final ItemStack rightItem;
    public final ItemStack resultItem;
    public final int cost;
    public final int matCost;

    public AnvilRecipe(ItemStack left, ItemStack right, int MatCost, ItemStack result, int xpCost) {
        this.leftItem = left;
        this.rightItem = right;
        this.resultItem = result;
        this.cost = xpCost;
        this.matCost = MatCost;
    }

    @Override
    public boolean matches(ItemStack left, ItemStack right) {
        ItemStack Left = this.leftItem;
        ItemStack Right = this.rightItem;
        return left != null && right != null && Left == left && Right == right;
    }

    @Override
    public ItemStack getLeftItem() {
        return this.leftItem;
    }

    @Override
    public ItemStack getResult() {
        return this.resultItem;
    }

    @Override
    public ItemStack getRightItem() {
        return this.rightItem;
    }

    public boolean hasOutput(ItemStack tool) {
        List recipes = AnvilManager.getInstance().getRecipeList();
        for (IAnvilRecipe recipe : recipes) {
            ItemStack Result = recipe.getResult();
            if (Result == null || Result.func_77973_b() != tool.func_77973_b()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getCost() {
        return this.cost;
    }

    @Override
    public int getMatCost() {
        return this.matCost;
    }
}

