/*
 * Decompiled with CFR 0.152.
 */
package lumaceon.mods.clockworkphase.item.construct.hourglass;

import lumaceon.mods.clockworkphase.init.ModBlocks;
import lumaceon.mods.clockworkphase.item.construct.hourglass.ItemHourglass;
import lumaceon.mods.clockworkphase.lib.MechanicTweaker;
import lumaceon.mods.clockworkphase.lib.Phases;
import lumaceon.mods.clockworkphase.util.NBTHelper;
import lumaceon.mods.clockworkphase.util.PhaseHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class ItemHourglassLight
extends ItemHourglass {
    public void func_77663_a(ItemStack is, World world, Entity entity, int p_77663_4_, boolean p_77663_5_) {
        if (entity instanceof EntityPlayer && NBTHelper.getBoolean(is, "cp_active")) {
            int newTension;
            EntityPlayer player = (EntityPlayer)entity;
            int tension = NBTHelper.getInt(is, "tension_energy");
            int quality = NBTHelper.getInt(is, "cp_quality");
            if (quality <= 0) {
                return;
            }
            int speed = NBTHelper.getInt(is, "cp_speed");
            int memory = NBTHelper.getInt(is, "cp_memory");
            float efficiency = (float)speed / (float)quality;
            int tensionCost = (int)Math.round((double)MechanicTweaker.LIGHT_HOURGLASS_TENSION_COST * Math.pow(efficiency, 2.0));
            if (PhaseHelper.getPhaseForWorld(world).equals((Object)Phases.LIGHT)) {
                tensionCost = (int)((double)tensionCost * 0.1);
            }
            if ((newTension = tension - tensionCost) <= 0) {
                this.removeTension(is, tension);
                NBTHelper.setBoolean(is, "cp_active", false);
                return;
            }
            if (efficiency > 10.0f) {
                NBTHelper.setBoolean(is, "cp_active", false);
                player.func_146105_b((IChatComponent)new ChatComponentText("Your clockwork's quality can't handle it's speed."));
                return;
            }
            if (speed < 50) {
                NBTHelper.setBoolean(is, "cp_active", false);
                player.func_146105_b((IChatComponent)new ChatComponentText("Your clockwork's speed is too slow to be of any use."));
                return;
            }
            if (!player.field_70122_E) {
                return;
            }
            int x = (int)Math.floor(player.field_70165_t);
            int y = (int)Math.floor(player.field_70163_u + 1.5);
            int z = (int)Math.floor(player.field_70161_v);
            int lightness = world.func_72957_l(x, y, z);
            if (world.func_147437_c(x, y, z) && lightness <= 7) {
                if (speed > 500) {
                    speed = 500;
                }
                world.func_147465_d(x, y, z, ModBlocks.hourglassLight, 10 + speed / 100, 2);
                this.removeTension(is, tensionCost);
            }
        }
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer player, World world, int x, int y, int z, int meta, float f1, float f2, float f3) {
        boolean isActive = NBTHelper.getBoolean(is, "cp_active");
        NBTHelper.setBoolean(is, "cp_active", !isActive);
        return true;
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer player) {
        boolean isActive = NBTHelper.getBoolean(is, "cp_active");
        NBTHelper.setBoolean(is, "cp_active", !isActive);
        return is;
    }
}

