/*
 * Decompiled with CFR 0.152.
 */
package lumaceon.mods.clockworkphase.client.particle;

import lumaceon.mods.clockworkphase.client.particle.ParticleGenerator;
import lumaceon.mods.clockworkphase.client.particle.entityfx.EntityBlockInTheWayFX;
import lumaceon.mods.clockworkphase.client.particle.entityfx.EntityElementalAttunementFX;
import lumaceon.mods.clockworkphase.client.particle.entityfx.EntityGrowthAbsorptionFX;
import lumaceon.mods.clockworkphase.client.particle.entityfx.EntityTimeSandExtractionFX;
import lumaceon.mods.clockworkphase.client.particle.entityfx.EntityTimeSandTunnelFX;
import lumaceon.mods.clockworkphase.proxy.ClientProxy;

public class ParticleSpawner {
    public ParticleGenerator gen;

    public ParticleSpawner(ParticleGenerator gen) {
        this.gen = gen;
    }

    public void spawnElementizeParticle(double x, double y, double z) {
        this.gen.initWorldAndRandom();
        EntityElementalAttunementFX particle = new EntityElementalAttunementFX(this.gen.world, x, y, z);
        ClientProxy.particleGenerator.spawnParticle(particle, 64.0);
    }

    public void spawnTimeSandExtractionParticles(double x, double y, double z, int amount) {
        this.gen.initWorldAndRandom();
        for (int n = 0; n < amount; ++n) {
            EntityTimeSandExtractionFX particle = new EntityTimeSandExtractionFX(this.gen.world, x, y, z);
            ClientProxy.particleGenerator.spawnParticle(particle, 64.0);
        }
    }

    public void spawnGrowthAbsorptionParticle(double fromX, double fromY, double fromZ, double x, double y, double z) {
        this.gen.initWorldAndRandom();
        EntityGrowthAbsorptionFX particle = new EntityGrowthAbsorptionFX(this.gen.world, fromX, fromY, fromZ, x, y, z);
        ClientProxy.particleGenerator.spawnParticle(particle, 64.0);
    }

    public void spawnBlockInTheWayParticle(double x, double y, double z) {
        this.gen.initWorldAndRandom();
        EntityBlockInTheWayFX particle = new EntityBlockInTheWayFX(this.gen.world, x, y, z);
        ClientProxy.particleGenerator.spawnParticle(particle, 48.0);
    }

    public void spawnTimeSandTunnelParticle(double x, double y, double z, double targetX, double targetY, double targetZ) {
        this.gen.initWorldAndRandom();
        EntityTimeSandTunnelFX particle = new EntityTimeSandTunnelFX(this.gen.world, x, y, z, targetX, targetY, targetZ);
        ClientProxy.particleGenerator.spawnParticle(particle, 64.0);
    }
}

