/*
 * Decompiled with CFR 0.152.
 */
package lumaceon.mods.clockworkphase.block.tileentity;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import lumaceon.mods.clockworkphase.block.extractor.ExtractorAreas;
import lumaceon.mods.clockworkphase.block.tileentity.TileEntityTimeSandCapacitor;
import lumaceon.mods.clockworkphase.block.tileentity.TileEntityTimeWell;
import lumaceon.mods.clockworkphase.init.ModItems;
import lumaceon.mods.clockworkphase.item.ItemCatalyst;
import lumaceon.mods.clockworkphase.lib.MechanicTweaker;
import lumaceon.mods.clockworkphase.lib.Phases;
import lumaceon.mods.clockworkphase.network.MessageDoublePositionParticleSpawn;
import lumaceon.mods.clockworkphase.network.PacketHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileEntityExtractor
extends TileEntityTimeSandCapacitor
implements IInventory {
    public Phases phase;
    public boolean extractorAreaReady = false;
    public boolean needsToUpdateArea = false;
    public int timeWellX;
    public int timeWellY;
    public int timeWellZ;
    protected ItemStack inventory;

    public TileEntityExtractor() {
    }

    public TileEntityExtractor(Phases phase) {
        this.phase = phase;
    }

    public boolean applyEffect(Phases phase) {
        if (!phase.equals((Object)this.phase)) {
            return false;
        }
        if (this.inventory != null && this.inventory.func_77973_b() instanceof ItemCatalyst && this.inventory.func_77973_b().equals(ModItems.catalystElements[phase.ordinal()])) {
            switch (phase.ordinal()) {
                case 0: {
                    this.addTimeSand(MechanicTweaker.TIME_SAND_FROM_NATURAL_SPAWN);
                    int newDamage = this.inventory.func_77960_j() + 1;
                    if (newDamage > this.inventory.func_77958_k()) {
                        this.func_70298_a(0, 1);
                        break;
                    }
                    this.inventory.func_77964_b(newDamage);
                    this.func_70296_d();
                    break;
                }
                case 1: {
                    int lightLevels = 0;
                    lightLevels += this.field_145850_b.func_72957_l(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
                    lightLevels += this.field_145850_b.func_72957_l(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
                    lightLevels += this.field_145850_b.func_72957_l(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                    lightLevels += this.field_145850_b.func_72957_l(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
                    lightLevels += this.field_145850_b.func_72957_l(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
                    int timeSandToAdd = (int)((double)(lightLevels += this.field_145850_b.func_72957_l(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) / 75.0 * (double)MechanicTweaker.TIME_SAND_FROM_LIGHT_SECOND);
                    if (timeSandToAdd <= 0) {
                        return false;
                    }
                    if (timeSandToAdd > MechanicTweaker.TIME_SAND_FROM_LIGHT_SECOND) {
                        timeSandToAdd = MechanicTweaker.TIME_SAND_FROM_LIGHT_SECOND;
                    }
                    this.addTimeSand(timeSandToAdd);
                    int newDamage = this.inventory.func_77960_j() + 1;
                    if (newDamage > this.inventory.func_77958_k()) {
                        this.func_70298_a(0, 1);
                        break;
                    }
                    this.inventory.func_77964_b(newDamage);
                    this.func_70296_d();
                    break;
                }
                case 2: {
                    int waterBlocks = 0;
                    for (int x = this.field_145851_c - 1; x <= this.field_145851_c + 1; ++x) {
                        for (int y = this.field_145848_d - 1; y <= this.field_145848_d + 1; ++y) {
                            for (int z = this.field_145849_e - 1; z <= this.field_145849_e + 1; ++z) {
                                if (!this.field_145850_b.func_147439_a(x, y, z).equals(Blocks.field_150355_j)) continue;
                                ++waterBlocks;
                            }
                        }
                    }
                    int timeSandToAdd = (int)((double)waterBlocks / 26.0 * (double)MechanicTweaker.TIME_SAND_FROM_WATER_SECOND);
                    if (timeSandToAdd <= 0) {
                        return false;
                    }
                    this.addTimeSand(timeSandToAdd);
                    int newDamage = this.inventory.func_77960_j() + 1;
                    if (newDamage > this.inventory.func_77958_k()) {
                        this.func_70298_a(0, 1);
                        break;
                    }
                    this.inventory.func_77964_b(newDamage);
                    this.func_70296_d();
                    break;
                }
                case 3: {
                    this.addTimeSand(MechanicTweaker.TIME_SAND_FROM_TREE_EXTRACTION);
                    int newDamage = this.inventory.func_77960_j() + 1;
                    if (newDamage > this.inventory.func_77958_k()) {
                        this.func_70298_a(0, 1);
                    } else {
                        this.inventory.func_77964_b(newDamage);
                        this.func_70296_d();
                    }
                    return true;
                }
                case 4: {
                    int timeSandToAdd = (int)((double)this.field_145848_d / 255.0 * (double)MechanicTweaker.TIME_SAND_FROM_AIR_SECOND);
                    if (timeSandToAdd <= 0) {
                        return false;
                    }
                    this.addTimeSand(timeSandToAdd);
                    int newDamage = this.inventory.func_77960_j() + 1;
                    if (newDamage > this.inventory.func_77958_k()) {
                        this.func_70298_a(0, 1);
                        break;
                    }
                    this.inventory.func_77964_b(newDamage);
                    this.func_70296_d();
                    break;
                }
                case 5: {
                    this.addTimeSand(MechanicTweaker.TIME_SAND_FROM_ONE_FIRE_DAMAGE);
                    int newDamage = this.inventory.func_77960_j() + 1;
                    if (newDamage > this.inventory.func_77958_k()) {
                        this.func_70298_a(0, 1);
                        break;
                    }
                    this.inventory.func_77964_b(newDamage);
                    this.func_70296_d();
                    break;
                }
                case 6: {
                    if (this.field_145850_b.func_72820_D() % 24000L <= 12000L || this.field_145850_b.func_72820_D() % 24000L >= 24000L) break;
                    this.addTimeSand(MechanicTweaker.TIME_SAND_FROM_MOON_SECOND);
                    int newDamage = this.inventory.func_77960_j() + 1;
                    if (newDamage > this.inventory.func_77958_k()) {
                        this.func_70298_a(0, 1);
                        break;
                    }
                    this.inventory.func_77964_b(newDamage);
                    this.func_70296_d();
                    break;
                }
                case 7: {
                    this.addTimeSand(MechanicTweaker.TIME_SAND_FROM_DEATH);
                    int newDamage = this.inventory.func_77960_j() + 1;
                    if (newDamage > this.inventory.func_77958_k()) {
                        this.func_70298_a(0, 1);
                    } else {
                        this.inventory.func_77964_b(newDamage);
                        this.func_70296_d();
                    }
                    return true;
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public int getMaxTimeSandCapacity() {
        return 1000000;
    }

    public void func_145845_h() {
        if (this.field_145850_b != null) {
            TileEntity te;
            if (!this.extractorAreaReady && this.phase != null && !this.field_145850_b.field_72995_K) {
                if (!ExtractorAreas.doesAreaExist(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e) && (this.phase.equals((Object)Phases.FIRE) || this.phase.equals((Object)Phases.EARTH) || this.phase.equals((Object)Phases.LIFE) || this.phase.equals((Object)Phases.DEATH))) {
                    int radius = 7;
                    ExtractorAreas.getAreasFromWorld(this.field_145850_b, this.phase).addArea(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c - radius, this.field_145848_d - radius, this.field_145849_e - radius, this.field_145851_c + radius, this.field_145848_d + radius, this.field_145849_e + radius);
                }
                this.extractorAreaReady = true;
            }
            int timeSandToRemove = 1000;
            if (this.getTimeSand() > 10000) {
                timeSandToRemove = this.getTimeSand() / 10;
            }
            if (this.field_145850_b.func_72820_D() % 100L == 0L && this.getTimeSand() >= timeSandToRemove && (te = this.field_145850_b.func_147438_o(this.timeWellX, this.timeWellY, this.timeWellZ)) != null && te instanceof TileEntityTimeWell) {
                TileEntityTimeWell timeWell = (TileEntityTimeWell)te;
                if (timeWell.getTimeSand() + timeSandToRemove <= timeWell.getMaxTimeSandCapacity()) {
                    timeWell.addTimeSand(this.removeTimeSand(timeSandToRemove));
                } else {
                    timeWell.addTimeSand(this.removeTimeSand(timeWell.getMaxTimeSandCapacity() - timeWell.getTimeSand()));
                }
                if (!this.field_145850_b.field_72995_K) {
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageDoublePositionParticleSpawn((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, (double)this.timeWellX + 0.5, (double)this.timeWellY + 0.5, (double)this.timeWellZ + 0.5, 1), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 64.0));
                }
            }
            if (this.phase != null && this.field_145850_b.func_72820_D() % 20L == 0L && (this.phase.equals((Object)Phases.AIR) || this.phase.equals((Object)Phases.WATER) || this.phase.equals((Object)Phases.LUNAR) || this.phase.equals((Object)Phases.LIGHT))) {
                this.applyEffect(this.phase);
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("phase_element", this.phase.ordinal());
        NBTTagCompound compound = new NBTTagCompound();
        if (this.inventory != null) {
            this.inventory.func_77955_b(compound);
        }
        nbt.func_74782_a("inventory_array", (NBTBase)compound);
        nbt.func_74768_a("cp_x", this.timeWellX);
        nbt.func_74768_a("cp_y", this.timeWellY);
        nbt.func_74768_a("cp_z", this.timeWellZ);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.phase = Phases.values()[nbt.func_74762_e("phase_element")];
        this.inventory = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("inventory_array"));
        this.timeWellX = nbt.func_74762_e("cp_x");
        this.timeWellY = nbt.func_74762_e("cp_y");
        this.timeWellZ = nbt.func_74762_e("cp_z");
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int slotIndex) {
        return this.inventory;
    }

    public ItemStack func_70298_a(int index, int lossCount) {
        ItemStack is = this.func_70301_a(index);
        if (is != null) {
            if (lossCount >= is.field_77994_a) {
                this.func_70299_a(index, null);
            } else {
                is = is.func_77979_a(lossCount);
                if (is.field_77994_a == 0) {
                    this.func_70299_a(index, null);
                }
            }
        }
        this.func_70296_d();
        return is;
    }

    public ItemStack func_70304_b(int index) {
        if (this.inventory != null) {
            ItemStack itemStack = this.inventory;
            this.inventory = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack is) {
        this.inventory = is;
        if (is != null && is.field_77994_a > this.func_70297_j_()) {
            is.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack is) {
        return is.func_77973_b() instanceof ItemCatalyst && is.func_77973_b().equals(ModItems.catalystElements[this.phase.ordinal()]);
    }
}

