/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.addons.vanillamc;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.darkhax.wawla.util.Utilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class AddonVanillaEntities
implements IWailaEntityProvider {
    private static String showHorseJump = "wawla.horse.showJump";
    private static String showHorseSpeed = "wawla.horse.showSpeed";
    private static String showProfession = "wawla.showProfession";
    private static String showTntFuse = "wawla.tnt.fuse";

    public Entity getWailaOverride(IWailaEntityAccessor data, IWailaConfigHandler cfg) {
        return data.getEntity();
    }

    public List<String> getWailaHead(Entity entity, List<String> tip, IWailaEntityAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public List<String> getWailaBody(Entity entity, List<String> tip, IWailaEntityAccessor data, IWailaConfigHandler cfg) {
        if (entity instanceof EntityHorse) {
            EntityHorse horse = (EntityHorse)entity;
            if (cfg.getConfig("wawla.horse.showJump")) {
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.jumpStrength") + ": " + Utilities.round(horse.func_110215_cj(), 4));
            }
            if (cfg.getConfig("wawla.horse.showSpeed")) {
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.speed") + ": " + Utilities.round(horse.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e(), 4));
            }
        } else if (cfg.getConfig(showProfession)) {
            EntityZombie zombie;
            String profession = "";
            if (FMLCommonHandler.instance().getSide().equals((Object)Side.CLIENT) && entity instanceof EntityVillager) {
                EntityVillager villager = (EntityVillager)entity;
                profession = StatCollector.func_74838_a((String)("description.villager.profession." + Utilities.getVillagerName(villager.func_70946_n())));
            }
            if (entity instanceof EntityZombie && (zombie = (EntityZombie)entity).func_82231_m()) {
                profession = StatCollector.func_74838_a((String)"description.villager.profession.zombie");
            }
            if (entity instanceof EntityWitch) {
                profession = StatCollector.func_74838_a((String)"description.villager.profession.witch");
            }
            tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.profession") + ": " + profession);
        } else if (entity instanceof EntityTNTPrimed && cfg.getConfig(showTntFuse)) {
            tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.tnt.fuse") + ": " + data.getNBTData().func_74771_c("Fuse"));
        }
        return tip;
    }

    public List<String> getWailaTail(Entity entity, List<String> tip, IWailaEntityAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, Entity entity, NBTTagCompound tag, World world) {
        if (entity != null) {
            entity.func_70109_d(tag);
        }
        return tag;
    }

    public static void registerAddon(IWailaRegistrar register) {
        AddonVanillaEntities dataProvider = new AddonVanillaEntities();
        register.registerBodyProvider((IWailaEntityProvider)dataProvider, EntityHorse.class);
        register.registerNBTProvider((IWailaEntityProvider)dataProvider, EntityHorse.class);
        register.registerBodyProvider((IWailaEntityProvider)dataProvider, EntityVillager.class);
        register.registerNBTProvider((IWailaEntityProvider)dataProvider, EntityVillager.class);
        register.registerBodyProvider((IWailaEntityProvider)dataProvider, EntityZombie.class);
        register.registerNBTProvider((IWailaEntityProvider)dataProvider, EntityZombie.class);
        register.registerBodyProvider((IWailaEntityProvider)dataProvider, EntityTNTPrimed.class);
        register.registerNBTProvider((IWailaEntityProvider)dataProvider, EntityTNTPrimed.class);
        register.addConfig("Wawla-Entity", showHorseJump);
        register.addConfig("Wawla-Entity", showHorseSpeed);
        register.addConfig("Wawla-Entity", showProfession);
        register.addConfig("Wawla-Entity", showTntFuse);
    }
}

