/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.Config;
import openblocks.common.MagnetWhitelists;
import openblocks.common.entity.EntityMiniMe;
import openmods.Log;
import openmods.api.IBreakAwareTile;
import openmods.api.IPlaceAwareTile;
import openmods.entity.EntityBlock;
import openmods.fakeplayer.FakePlayerPool;
import openmods.fakeplayer.OpenModsFakePlayer;
import openmods.sync.SyncableEnum;
import openmods.tileentity.SyncedTileEntity;

public class TileEntityGoldenEgg
extends SyncedTileEntity
implements IPlaceAwareTile,
IBreakAwareTile {
    private static final float SPEED_CHANGE_RATE = 0.1f;
    private static final Random RANDOM = new Random();
    private static final int STAGE_CHANGE_TICK = 100;
    private static final int RISING_TIME = 400;
    private static final int FALLING_TIME = 10;
    public static final int MAX_HEIGHT = 5;
    private static final double STAGE_CHANGE_CHANCE = 0.8;
    private static final GameProfile MR_GLITCH = new GameProfile(UUID.fromString("d4d119aa-d410-488a-8734-0053577d4a1a"), null);
    public int tickCounter;
    private float rotation;
    private float progress;
    private float rotationSpeed;
    private float progressSpeed;
    private List<EntityBlock> blocks = Lists.newArrayList();
    private SyncableEnum<State> stage;
    private GameProfile owner;

    public float getRotation(float partialTickTime) {
        return this.rotation + this.rotationSpeed * partialTickTime;
    }

    public float getProgress(float partialTickTime) {
        return this.progress + this.progressSpeed * partialTickTime;
    }

    public float getOffset(float partialTickTime) {
        return this.getProgress(partialTickTime) * 5.0f;
    }

    public State tryRandomlyChangeState(int delay, State nextState) {
        return this.tickCounter % delay == 0 && RANDOM.nextDouble() < 0.8 ? nextState : null;
    }

    protected void createSyncedFields() {
        this.stage = SyncableEnum.create((Enum)State.INERT);
    }

    private void pickUpBlock(final WorldServer world, final int x, final int y, final int z) {
        FakePlayerPool.instance.executeOnPlayer(world, new FakePlayerPool.PlayerUser(){

            public void usePlayer(OpenModsFakePlayer fakePlayer) {
                EntityBlock block = EntityBlock.create((EntityPlayer)fakePlayer, (World)TileEntityGoldenEgg.this.field_145850_b, (int)x, (int)y, (int)z);
                if (block != null) {
                    block.setHasAirResistance(false);
                    block.setHasGravity(false);
                    block.field_70181_x = 0.1;
                    TileEntityGoldenEgg.this.blocks.add(block);
                    world.func_72838_d((Entity)block);
                }
            }
        });
    }

    private void dropBlocks() {
        for (EntityBlock block : this.blocks) {
            block.field_70181_x = -0.9;
            block.setHasGravity(true);
        }
        this.blocks.clear();
    }

    private void explode() {
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_72876_a(null, 0.5 + (double)this.field_145851_c, 0.5 + (double)this.field_145848_d, 0.5 + (double)this.field_145849_e, 2.0f, true);
        EntityMiniMe miniMe = new EntityMiniMe(this.field_145850_b, (GameProfile)Objects.firstNonNull((Object)this.owner, (Object)MR_GLITCH));
        miniMe.func_70080_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 0.0f, 0.0f);
        this.field_145850_b.func_72838_d((Entity)miniMe);
    }

    public State getState() {
        return (State)this.stage.get();
    }

    public void func_145845_h() {
        super.func_145845_h();
        State state = this.getState();
        if (this.field_145850_b.field_72995_K) {
            this.rotationSpeed = 0.9f * this.rotationSpeed + 0.1f * state.rotationSpeed;
            this.rotation += this.rotationSpeed;
            this.progressSpeed = 0.9f * this.progressSpeed + 0.1f * state.progressSpeed;
            this.progress += this.progressSpeed;
        } else {
            State nextState;
            if (this.field_145850_b instanceof WorldServer) {
                state.onServerTick(this, (WorldServer)this.field_145850_b);
            }
            if ((nextState = state.getNextState(this)) != null) {
                this.stage.set((Enum)nextState);
                nextState.onEntry(this);
                this.sync();
            }
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.owner != null) {
            NBTTagCompound ownerTag = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)ownerTag, (GameProfile)this.owner);
            nbt.func_74782_a("Owner", (NBTBase)ownerTag);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_150297_b("owner", 8)) {
            String ownerName = nbt.func_74779_i("owner");
            this.owner = MinecraftServer.func_71276_C().func_152358_ax().func_152655_a(ownerName);
        } else if (nbt.func_150297_b("OwnerUUID", 8)) {
            String uuidStr = nbt.func_74779_i("OwnerUUID");
            try {
                UUID uuid = UUID.fromString(uuidStr);
                this.owner = new GameProfile(uuid, null);
            }
            catch (IllegalArgumentException e) {
                Log.warn((Throwable)e, (String)"Failed to parse UUID: %s", (Object[])new Object[]{uuidStr});
            }
        } else if (nbt.func_150297_b("Owner", 10)) {
            this.owner = NBTUtil.func_152459_a((NBTTagCompound)nbt.func_74775_l("Owner"));
        }
    }

    public void onBlockBroken() {
        this.dropBlocks();
    }

    public void onBlockPlacedBy(EntityPlayer player, ForgeDirection side, ItemStack stack, float hitX, float hitY, float hitZ) {
        if (player != null) {
            this.owner = player.func_146103_bH();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)-1024.0, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)1024.0, (double)(this.field_145849_e + 1));
    }

    public static enum State {
        INERT(0.0f, 0.0f, false){

            @Override
            public State getNextState(TileEntityGoldenEgg target) {
                return target.tryRandomlyChangeState(100, ROTATING_SLOW);
            }

            @Override
            public void onServerTick(TileEntityGoldenEgg target, WorldServer world) {
                ++target.tickCounter;
            }
        }
        ,
        ROTATING_SLOW(1.0f, 0.0f, false){

            @Override
            public State getNextState(TileEntityGoldenEgg target) {
                return target.tryRandomlyChangeState(100, ROTATING_MEDIUM);
            }

            @Override
            public void onServerTick(TileEntityGoldenEgg target, WorldServer world) {
                ++target.tickCounter;
            }
        }
        ,
        ROTATING_MEDIUM(10.0f, 0.0f, false){

            @Override
            public State getNextState(TileEntityGoldenEgg target) {
                return target.tryRandomlyChangeState(100, ROTATING_FAST);
            }

            @Override
            public void onServerTick(TileEntityGoldenEgg target, WorldServer world) {
                ++target.tickCounter;
            }
        }
        ,
        ROTATING_FAST(50.0f, 0.0f, false){

            @Override
            public State getNextState(TileEntityGoldenEgg target) {
                return target.tryRandomlyChangeState(100, FLOATING);
            }

            @Override
            public void onServerTick(TileEntityGoldenEgg target, WorldServer world) {
                ++target.tickCounter;
            }
        }
        ,
        FLOATING(100.0f, 0.0025f, true){

            @Override
            public void onEntry(TileEntityGoldenEgg target) {
                target.tickCounter = 400;
            }

            @Override
            public void onServerTick(TileEntityGoldenEgg target, WorldServer world) {
                --target.tickCounter;
                if (Config.eggCanPickBlocks && RANDOM.nextInt(6) == 0) {
                    int posX = target.field_145851_c + RANDOM.nextInt(20) - 10;
                    int posY = target.field_145848_d + RANDOM.nextInt(2) - 1;
                    int posZ = target.field_145849_e + RANDOM.nextInt(20) - 10;
                    boolean canMove = MagnetWhitelists.instance.testBlock(target.field_145850_b, posX, posY, posZ);
                    if (canMove) {
                        target.pickUpBlock(world, posX, posY, posZ);
                    }
                }
            }

            @Override
            public State getNextState(TileEntityGoldenEgg target) {
                return target.tickCounter <= 0 ? FALLING : null;
            }
        }
        ,
        FALLING(150.0f, -0.1f, true){

            @Override
            public void onEntry(TileEntityGoldenEgg target) {
                target.tickCounter = 10;
                target.dropBlocks();
            }

            @Override
            public void onServerTick(TileEntityGoldenEgg target, WorldServer world) {
                --target.tickCounter;
            }

            @Override
            public State getNextState(TileEntityGoldenEgg target) {
                return target.tickCounter <= 0 ? EXPLODING : null;
            }
        }
        ,
        EXPLODING(666.0f, 0.0f, true){

            @Override
            public void onEntry(TileEntityGoldenEgg target) {
                target.explode();
            }

            @Override
            public State getNextState(TileEntityGoldenEgg target) {
                return null;
            }
        };

        public final float rotationSpeed;
        public final float progressSpeed;
        public final boolean specialEffects;

        public void onEntry(TileEntityGoldenEgg target) {
        }

        public void onServerTick(TileEntityGoldenEgg target, WorldServer world) {
        }

        public abstract State getNextState(TileEntityGoldenEgg var1);

        private State(float rotationSpeed, float riseSpeed, boolean specialEffects) {
            this.rotationSpeed = rotationSpeed;
            this.progressSpeed = riseSpeed;
            this.specialEffects = specialEffects;
        }
    }
}

