/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.client.model.ModelVillage;
import openblocks.common.tileentity.TileEntityVillageHighlighter;
import openmods.sync.SyncableIntArray;
import openmods.utils.BlockUtils;
import org.lwjgl.opengl.GL11;

public class TileEntityVillageHighlighterRenderer
extends TileEntitySpecialRenderer {
    private static final AxisAlignedBB BOUNDING_BOX = AxisAlignedBB.func_72330_a((double)-8.0, (double)-3.0, (double)-8.0, (double)8.0, (double)3.0, (double)8.0);
    private ModelVillage model = new ModelVillage();
    private static final ResourceLocation texture = new ResourceLocation("openblocks", "textures/models/village.png");

    public void func_147500_a(TileEntity tileentity, double x, double y, double z, float f) {
        TileEntityVillageHighlighter villagehighlighter = (TileEntityVillageHighlighter)tileentity;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.0f), (float)((float)z + 0.5f));
        if (!villagehighlighter.isRenderedInInventory() && villagehighlighter.isPowered()) {
            GL11.glPushMatrix();
            Tessellator t = Tessellator.field_78398_a;
            SyncableIntArray villages = villagehighlighter.getVillageData();
            int[] data = villages.getValue();
            for (int i = 0; i < data.length; i += TileEntityVillageHighlighter.VALUES_PER_VILLAGE) {
                t.func_78371_b(0);
                int radius = data[i];
                int vX = data[i + 1];
                int vY = data[i + 2];
                int vZ = data[i + 3];
                int id = data[i + 6];
                GL11.glPushMatrix();
                GL11.glDisable((int)3553);
                GL11.glTranslated((double)vX, (double)vY, (double)vZ);
                int color = id % 0xFFFFFF;
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
                GL11.glPushMatrix();
                GL11.glPointSize((float)4.0f);
                GL11.glLineWidth((float)10.0f);
                double N = 1500.0;
                double ratio = Math.PI * (3.0 - Math.sqrt(5.0));
                double off = 2.0 / N;
                int j = 0;
                while ((double)j < N) {
                    double py = (double)j * off - 1.0 + off / 2.0;
                    double rad = Math.sqrt(1.0 - py * py);
                    double phi = (double)j * ratio;
                    double px = Math.cos(phi) * rad;
                    double pz = Math.sin(phi) * rad;
                    t.func_78377_a(px * (double)radius, py * (double)radius, pz * (double)radius);
                    ++j;
                }
                t.func_78381_a();
                GL11.glPopMatrix();
                this.drawBox(BOUNDING_BOX);
                GL11.glEnable((int)3553);
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(-BlockUtils.getRotationFromDirection((ForgeDirection)villagehighlighter.getRotation())), (float)0.0f, (float)1.0f, (float)0.0f);
        this.func_147499_a(texture);
        this.model.render((TileEntity)villagehighlighter, f);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public void drawBox(AxisAlignedBB bb) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78371_b(3);
        tessellator.func_78377_a(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c);
        tessellator.func_78377_a(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c);
        tessellator.func_78377_a(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f);
        tessellator.func_78377_a(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f);
        tessellator.func_78377_a(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c);
        tessellator.func_78381_a();
        tessellator.func_78371_b(3);
        tessellator.func_78377_a(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c);
        tessellator.func_78377_a(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c);
        tessellator.func_78377_a(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
        tessellator.func_78377_a(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f);
        tessellator.func_78377_a(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c);
        tessellator.func_78381_a();
        tessellator.func_78371_b(1);
        tessellator.func_78377_a(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c);
        tessellator.func_78377_a(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c);
        tessellator.func_78377_a(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c);
        tessellator.func_78377_a(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c);
        tessellator.func_78377_a(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f);
        tessellator.func_78377_a(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
        tessellator.func_78377_a(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f);
        tessellator.func_78377_a(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f);
        tessellator.func_78381_a();
    }
}

