/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.repackage.cofh.lib.render;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public final class RenderHelper {
    public static final double RENDER_OFFSET = 9.765625E-4;
    public static final ResourceLocation MC_BLOCK_SHEET = new ResourceLocation("textures/atlas/blocks.png");
    public static final ResourceLocation MC_ITEM_SHEET = new ResourceLocation("textures/atlas/items.png");
    public static final ResourceLocation MC_FONT_DEFAULT = new ResourceLocation("textures/font/ascii.png");
    public static final ResourceLocation MC_FONT_ALTERNATE = new ResourceLocation("textures/font/ascii_sga.png");
    public static final ResourceLocation MC_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");

    private RenderHelper() {
    }

    public static final TextureManager engine() {
        return Minecraft.func_71410_x().field_71446_o;
    }

    public static final Tessellator tessellator() {
        return Tessellator.field_78398_a;
    }

    public static void setColor3ub(int color) {
        GL11.glColor3ub((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
    }

    public static void setColor4ub(int color) {
        GL11.glColor4ub((byte)((byte)(color >> 24 & 0xFF)), (byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
    }

    public static void resetColor() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderItemAsBlock(RenderBlocks renderer, ItemStack item, double translateX, double translateY, double translateZ) {
        RenderHelper.renderTextureAsBlock(renderer, item.func_77954_c(), translateX, translateY, translateZ);
    }

    public static void renderTextureAsBlock(RenderBlocks renderer, IIcon texture, double translateX, double translateY, double translateZ) {
        Tessellator tessellator = Tessellator.field_78398_a;
        Block block = Blocks.field_150348_b;
        if (texture == null) {
            return;
        }
        renderer.func_147775_a(block);
        GL11.glTranslated((double)translateX, (double)translateY, (double)translateZ);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, texture);
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, texture);
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, texture);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, texture);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, texture);
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, texture);
        tessellator.func_78381_a();
    }

    public static void renderItemIn2D(IIcon icon) {
        ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
    }

    public static void renderIcon(IIcon icon, double z) {
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78374_a(0.0, 16.0, z, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(16.0, 16.0, z, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(16.0, 0.0, z, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        Tessellator.field_78398_a.func_78374_a(0.0, 0.0, z, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        Tessellator.field_78398_a.func_78381_a();
    }

    public static void renderIcon(double x, double y, double z, IIcon icon, int width, int height) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(x, y + (double)height, z, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        tessellator.func_78374_a(x + (double)width, y + (double)height, z, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        tessellator.func_78374_a(x + (double)width, y, z, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        tessellator.func_78374_a(x, y, z, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        tessellator.func_78381_a();
    }

    public static final IIcon getFluidTexture(Fluid fluid) {
        if (fluid == null) {
            return FluidRegistry.LAVA.getIcon();
        }
        return fluid.getIcon();
    }

    public static final IIcon getFluidTexture(FluidStack fluid) {
        if (fluid == null || fluid.getFluid() == null || fluid.getFluid().getIcon(fluid) == null) {
            return FluidRegistry.LAVA.getIcon();
        }
        return fluid.getFluid().getIcon(fluid);
    }

    public static final void bindItemTexture(ItemStack stack) {
        RenderHelper.engine().func_110577_a(stack.func_94608_d() == 0 ? MC_BLOCK_SHEET : MC_ITEM_SHEET);
    }

    public static final void bindTexture(ResourceLocation texture) {
        RenderHelper.engine().func_110577_a(texture);
    }

    public static final void setBlockTextureSheet() {
        RenderHelper.bindTexture(MC_BLOCK_SHEET);
    }

    public static final void setItemTextureSheet() {
        RenderHelper.bindTexture(MC_ITEM_SHEET);
    }

    public static final void setDefaultFontTextureSheet() {
        RenderHelper.bindTexture(MC_FONT_DEFAULT);
    }

    public static final void setSGAFontTextureSheet() {
        RenderHelper.bindTexture(MC_FONT_ALTERNATE);
    }

    public static final void enableGUIStandardItemLighting() {
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
    }
}

