/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.repackage.cofh.lib.gui.element;

import com.pahimar.repackage.cofh.lib.gui.GuiBase;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class ElementBase {
    protected GuiBase gui;
    protected ResourceLocation texture;
    protected int posX;
    protected int posY;
    protected int sizeX;
    protected int sizeY;
    protected int texW = 256;
    protected int texH = 256;
    protected String name;
    private boolean visible = true;
    private boolean enabled = true;

    public ElementBase(GuiBase gui, int posX, int posY) {
        this.gui = gui;
        this.posX = posX;
        this.posY = posY;
    }

    public ElementBase(GuiBase gui, int posX, int posY, int width, int height) {
        this.gui = gui;
        this.posX = posX;
        this.posY = posY;
        this.sizeX = width;
        this.sizeY = height;
    }

    public ElementBase setName(String name) {
        this.name = name;
        return this;
    }

    public ElementBase setPosition(int posX, int posY) {
        this.posX = posX;
        this.posY = posY;
        return this;
    }

    public ElementBase setSize(int sizeX, int sizeY) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        return this;
    }

    public ElementBase setTexture(String texture, int texW, int texH) {
        this.texture = new ResourceLocation(texture);
        this.texW = texW;
        this.texH = texH;
        return this;
    }

    public ElementBase setTexture(ResourceLocation texture, int texW, int texH) {
        this.texture = texture;
        this.texW = texW;
        this.texH = texH;
        return this;
    }

    public final ElementBase setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public final ElementBase setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void update(int mouseX, int mouseY) {
        this.update();
    }

    public void update() {
    }

    public abstract void drawBackground(int var1, int var2, float var3);

    public abstract void drawForeground(int var1, int var2);

    public void addTooltip(List<String> list) {
    }

    public void drawModalRect(int x, int y, int width, int height, int color) {
        this.gui.drawSizedModalRect(x, y, width, height, color);
    }

    public void drawStencil(int xStart, int yStart, int xEnd, int yEnd, int flag) {
        GL11.glDisable((int)3553);
        GL11.glStencilFunc((int)519, (int)flag, (int)flag);
        GL11.glStencilOp((int)7680, (int)7680, (int)7681);
        GL11.glStencilMask((int)1);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL11.glDepthMask((boolean)false);
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78377_a((double)xStart, (double)yEnd, 0.0);
        Tessellator.field_78398_a.func_78377_a((double)xEnd, (double)yEnd, 0.0);
        Tessellator.field_78398_a.func_78377_a((double)xEnd, (double)yStart, 0.0);
        Tessellator.field_78398_a.func_78377_a((double)xStart, (double)yStart, 0.0);
        Tessellator.field_78398_a.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glStencilFunc((int)514, (int)flag, (int)flag);
        GL11.glStencilMask((int)0);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glDepthMask((boolean)true);
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height) {
        this.gui.drawSizedTexturedModalRect(x, y, u, v, width, height, this.texW, this.texH);
    }

    public void drawCenteredString(FontRenderer fontRenderer, String text, int x, int y, int color) {
        fontRenderer.func_78261_a(text, x - fontRenderer.func_78256_a(text) / 2, y, color);
    }

    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        return false;
    }

    public void onMouseReleased(int mouseX, int mouseY) {
    }

    public boolean onMouseWheel(int mouseX, int mouseY, int movement) {
        return false;
    }

    public boolean onKeyTyped(char characterTyped, int keyPressed) {
        return false;
    }

    public boolean intersectsWith(int mouseX, int mouseY) {
        return mouseX >= this.posX && mouseX <= this.posX + this.sizeX && mouseY >= this.posY && mouseY <= this.posY + this.sizeY;
    }

    public final String getName() {
        return this.name;
    }

    public final GuiBase getContainerScreen() {
        return this.gui;
    }

    public final FontRenderer getFontRenderer() {
        return this.gui.getFontRenderer();
    }

    public final int getPosY() {
        return this.posY;
    }

    public final int getPosX() {
        return this.posX;
    }

    public final int getHeight() {
        return this.sizeY;
    }

    public final int getWidth() {
        return this.sizeX;
    }
}

