/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.inventory;

import com.pahimar.ee3.api.exchange.EnergyValueRegistryProxy;
import com.pahimar.ee3.exchange.EnergyValueRegistry;
import com.pahimar.ee3.inventory.ContainerEE;
import com.pahimar.ee3.inventory.InventoryTransmutationTablet;
import com.pahimar.ee3.inventory.element.IElementButtonHandler;
import com.pahimar.ee3.inventory.element.IElementSliderHandler;
import com.pahimar.ee3.inventory.element.IElementTextFieldHandler;
import com.pahimar.ee3.item.ItemAlchemicalTome;
import com.pahimar.ee3.item.ItemMiniumStone;
import com.pahimar.ee3.item.ItemPhilosophersStone;
import com.pahimar.ee3.knowledge.AbilityRegistry;
import com.pahimar.ee3.knowledge.TransmutationKnowledge;
import com.pahimar.ee3.knowledge.TransmutationKnowledgeRegistry;
import com.pahimar.ee3.network.PacketHandler;
import com.pahimar.ee3.network.message.MessageTransmutationKnowledgeUpdate;
import com.pahimar.ee3.reference.Comparators;
import com.pahimar.ee3.tileentity.TileEntityTransmutationTablet;
import com.pahimar.ee3.util.FilterUtils;
import com.pahimar.ee3.util.ItemHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerTransmutationTablet
extends ContainerEE
implements IElementTextFieldHandler,
IElementSliderHandler,
IElementButtonHandler {
    private InventoryTransmutationTablet inventoryTransmutationTablet;
    public final TileEntityTransmutationTablet tileEntityTransmutationTablet;
    private float energyValue;
    private String searchTerm;
    private int sortOption;
    private int sortOrder;
    private int scrollBarPosition;

    public ContainerTransmutationTablet(InventoryPlayer inventoryPlayer, TileEntityTransmutationTablet tileEntityTransmutationTablet) {
        ItemStack itemStack;
        this.tileEntityTransmutationTablet = tileEntityTransmutationTablet;
        TreeSet<ItemStack> knownTransmutations = new TreeSet<ItemStack>(Comparators.displayNameComparator);
        if (tileEntityTransmutationTablet.func_70301_a(9) != null && (itemStack = tileEntityTransmutationTablet.func_70301_a(9)).func_77973_b() instanceof ItemAlchemicalTome && ItemHelper.hasOwnerUUID(itemStack)) {
            knownTransmutations.addAll(TransmutationKnowledgeRegistry.getInstance().getPlayersKnownTransmutations(ItemHelper.getOwnerUUID(itemStack)));
        }
        this.inventoryTransmutationTablet = new InventoryTransmutationTablet(knownTransmutations);
        this.sortOption = 0;
        this.scrollBarPosition = 0;
        this.energyValue = tileEntityTransmutationTablet.getAvailableEnergyValue().getValue();
        this.func_75146_a(new SlotTabletInput(this, (IInventory)tileEntityTransmutationTablet, 0, 62, 24));
        this.func_75146_a(new SlotTabletInput(this, (IInventory)tileEntityTransmutationTablet, 1, 35, 35));
        this.func_75146_a(new SlotTabletInput(this, (IInventory)tileEntityTransmutationTablet, 2, 26, 61));
        this.func_75146_a(new SlotTabletInput(this, (IInventory)tileEntityTransmutationTablet, 3, 35, 87));
        this.func_75146_a(new SlotTabletInput(this, (IInventory)tileEntityTransmutationTablet, 4, 62, 99));
        this.func_75146_a(new SlotTabletInput(this, (IInventory)tileEntityTransmutationTablet, 5, 89, 87));
        this.func_75146_a(new SlotTabletInput(this, (IInventory)tileEntityTransmutationTablet, 6, 98, 61));
        this.func_75146_a(new SlotTabletInput(this, (IInventory)tileEntityTransmutationTablet, 7, 89, 35));
        this.func_75146_a(new Slot((IInventory)tileEntityTransmutationTablet, 8, 62, 61){

            public int func_75219_a() {
                return 1;
            }

            public boolean func_75214_a(ItemStack itemStack) {
                return itemStack.func_77973_b() instanceof ItemMiniumStone || itemStack.func_77973_b() instanceof ItemPhilosophersStone;
            }
        });
        this.func_75146_a(new SlotAlchemicalTome(this, (IInventory)tileEntityTransmutationTablet, 9, 152, 15));
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a(new SlotTabletOutput(this, this.inventoryTransmutationTablet, i * 3 + j, 175 + j * 20, 38 + i * 20));
            }
        }
        for (int inventoryRowIndex = 0; inventoryRowIndex < 3; ++inventoryRowIndex) {
            for (int inventoryColumnIndex = 0; inventoryColumnIndex < 9; ++inventoryColumnIndex) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, inventoryColumnIndex + inventoryRowIndex * 9 + 9, 8 + inventoryColumnIndex * 18, 164 + inventoryRowIndex * 18));
            }
        }
        for (int actionBarSlotIndex = 0; actionBarSlotIndex < 9; ++actionBarSlotIndex) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, actionBarSlotIndex, 8 + actionBarSlotIndex * 18, 222));
        }
        this.updateInventory();
    }

    @Override
    public boolean func_75145_c(EntityPlayer entityPlayer) {
        return this.tileEntityTransmutationTablet != null && this.tileEntityTransmutationTablet.isStructureValid();
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (Object crafter : this.field_75149_d) {
            ICrafting iCrafting = (ICrafting)crafter;
            if (this.energyValue == this.tileEntityTransmutationTablet.getAvailableEnergyValue().getValue()) continue;
            this.energyValue = this.tileEntityTransmutationTablet.getAvailableEnergyValue().getValue();
            this.updateInventory();
            int energyValueAsInt = Float.floatToRawIntBits(this.tileEntityTransmutationTablet.getAvailableEnergyValue().getValue());
            iCrafting.func_71112_a((Container)this, 0, energyValueAsInt & 0xFFFF);
            iCrafting.func_71112_a((Container)this, 1, energyValueAsInt >>> 16);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int valueType, int updatedValue) {
        if (valueType == 0) {
            int energyValueAsInt = Float.floatToRawIntBits(this.energyValue);
            energyValueAsInt = energyValueAsInt & 0xFFFF0000 | updatedValue;
            this.energyValue = Float.intBitsToFloat(energyValueAsInt);
        } else if (valueType == 1) {
            int energyValueAsInt = Float.floatToRawIntBits(this.energyValue);
            energyValueAsInt = energyValueAsInt & 0xFFFF | updatedValue << 16;
            this.energyValue = Float.intBitsToFloat(energyValueAsInt);
        } else if (valueType == 2) {
            this.sortOption = updatedValue;
        } else if (valueType == 3) {
            this.scrollBarPosition = updatedValue;
        } else if (valueType == 4) {
            this.sortOrder = updatedValue;
        }
        if (valueType >= 0 && valueType <= 4) {
            this.updateInventory();
        }
    }

    @Override
    public void handleElementTextFieldUpdate(String elementName, String updatedText) {
        if (elementName.equalsIgnoreCase("searchField")) {
            this.searchTerm = updatedText;
            this.updateInventory();
        }
    }

    @Override
    public void handleElementSliderUpdate(String elementName, int elementValue) {
        if (elementName.equals("scrollBar")) {
            this.scrollBarPosition = elementValue;
            this.updateInventory();
        }
    }

    public void handleTransmutationKnowledgeUpdate(TransmutationKnowledge transmutationKnowledge) {
        if (transmutationKnowledge != null) {
            this.inventoryTransmutationTablet = new InventoryTransmutationTablet(transmutationKnowledge.getKnownTransmutations());
            this.updateInventory();
        }
    }

    private void updateInventory() {
        ItemStack[] newInventory = new ItemStack[30];
        Set<ItemStack> filteredSet = FilterUtils.filterByNameContains(this.inventoryTransmutationTablet.getKnownTransmutations(), this.searchTerm);
        ArrayList<ItemStack> filteredList = new ArrayList<ItemStack>(FilterUtils.filterByEnergyValue(filteredSet, this.energyValue));
        int adjustedStartIndex = (int)((float)this.scrollBarPosition / 187.0f * (float)filteredList.size());
        if (this.sortOption == 0) {
            if (this.sortOrder == 0) {
                Collections.sort(filteredList, Comparators.displayNameComparator);
            } else {
                Collections.sort(filteredList, Comparators.reverseDisplayNameComparator);
            }
        } else if (this.sortOption == 1) {
            if (this.sortOrder == 0) {
                Collections.sort(filteredList, Comparators.energyValueItemStackComparator);
            } else {
                Collections.sort(filteredList, Comparators.reverseEnergyValueComparator);
            }
        } else if (this.sortOption == 2) {
            if (this.sortOrder == 0) {
                Collections.sort(filteredList, Comparators.idComparator);
            } else {
                Collections.sort(filteredList, Comparators.reverseIdComparator);
            }
        }
        newInventory = filteredList.size() <= 30 ? filteredList.toArray(newInventory) : (adjustedStartIndex + 30 <= filteredList.size() ? filteredList.subList(adjustedStartIndex, adjustedStartIndex + 30).toArray(newInventory) : filteredList.subList(filteredList.size() - 30, filteredList.size()).toArray(newInventory));
        for (int i = 0; i < 30; ++i) {
            this.func_75139_a(i + 10).func_75215_d(newInventory[i]);
        }
    }

    public ItemStack func_82846_b(EntityPlayer entityPlayer, int slotIndex) {
        ItemStack itemStack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotItemStack = slot.func_75211_c();
            itemStack = slotItemStack.func_77946_l();
            if (slotIndex < 10 ? !this.func_75135_a(slotItemStack, 10, this.field_75151_b.size(), false) : (slotIndex >= 10 && slotIndex < 40 ? !this.mergeTransmutatedItemStack(entityPlayer, slot, slotItemStack, 40, this.field_75151_b.size(), false) : (slotItemStack.func_77973_b() instanceof ItemAlchemicalTome ? !this.func_75135_a(slotItemStack, 9, 10, false) : (slotItemStack.func_77973_b() instanceof ItemMiniumStone || slotItemStack.func_77973_b() instanceof ItemPhilosophersStone ? !this.func_75135_a(slotItemStack, 8, 10, false) : !this.func_75135_a(slotItemStack, 0, 10, false))))) {
                return null;
            }
            if (slotItemStack.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
        }
        return itemStack;
    }

    protected boolean mergeTransmutatedItemStack(EntityPlayer entityPlayer, Slot transmutationOutputSlot, ItemStack itemStack, int slotMin, int slotMax, boolean ascending) {
        ItemStack stackInSlot;
        Slot slot;
        int currentSlotIndex;
        if (this.tileEntityTransmutationTablet.getAvailableEnergyValue().compareTo(EnergyValueRegistryProxy.getEnergyValue(itemStack)) < 0) {
            return false;
        }
        transmutationOutputSlot.func_82870_a(entityPlayer, itemStack);
        boolean slotFound = false;
        int n = currentSlotIndex = ascending ? slotMax - 1 : slotMin;
        if (itemStack.func_77985_e()) {
            while (itemStack.field_77994_a > 0 && (!ascending && currentSlotIndex < slotMax || ascending && currentSlotIndex >= slotMin)) {
                slot = (Slot)this.field_75151_b.get(currentSlotIndex);
                stackInSlot = slot.func_75211_c();
                if (slot.func_75214_a(itemStack) && ItemHelper.equalsIgnoreStackSize(itemStack, stackInSlot)) {
                    int combinedStackSize = stackInSlot.field_77994_a + itemStack.field_77994_a;
                    int slotStackSizeLimit = Math.min(stackInSlot.func_77976_d(), slot.func_75219_a());
                    if (combinedStackSize <= slotStackSizeLimit) {
                        itemStack.field_77994_a = 0;
                        stackInSlot.field_77994_a = combinedStackSize;
                        slot.func_75218_e();
                        slotFound = true;
                    } else if (stackInSlot.field_77994_a < slotStackSizeLimit) {
                        itemStack.field_77994_a -= slotStackSizeLimit - stackInSlot.field_77994_a;
                        stackInSlot.field_77994_a = slotStackSizeLimit;
                        slot.func_75218_e();
                        slotFound = true;
                    }
                }
                currentSlotIndex += ascending ? -1 : 1;
            }
        }
        if (itemStack.field_77994_a > 0) {
            int n2 = currentSlotIndex = ascending ? slotMax - 1 : slotMin;
            while (!ascending && currentSlotIndex < slotMax || ascending && currentSlotIndex >= slotMin) {
                slot = (Slot)this.field_75151_b.get(currentSlotIndex);
                stackInSlot = slot.func_75211_c();
                if (slot.func_75214_a(itemStack) && stackInSlot == null) {
                    slot.func_75215_d(ItemHelper.cloneItemStack(itemStack, Math.min(itemStack.field_77994_a, slot.func_75219_a())));
                    slot.func_75218_e();
                    if (slot.func_75211_c() == null) break;
                    itemStack.field_77994_a = 0;
                    slotFound = true;
                    break;
                }
                currentSlotIndex += ascending ? -1 : 1;
            }
        }
        itemStack.field_77994_a = 1;
        return slotFound;
    }

    @Override
    public void handleElementButtonClick(String elementName, int mouseButton) {
        if (elementName.equals("sortOption")) {
            if (mouseButton == 0) {
                if (this.sortOption == 0) {
                    this.sortOption = 1;
                } else if (this.sortOption == 1) {
                    this.sortOption = 2;
                } else if (this.sortOption == 2) {
                    this.sortOption = 0;
                }
            } else if (mouseButton == 1) {
                if (this.sortOption == 0) {
                    this.sortOption = 2;
                } else if (this.sortOption == 1) {
                    this.sortOption = 0;
                } else if (this.sortOption == 2) {
                    this.sortOption = 1;
                }
            }
        } else if (elementName.equals("sortOrder")) {
            if (this.sortOrder == 0) {
                this.sortOrder = 1;
            } else if (this.sortOrder == 1) {
                this.sortOrder = 0;
            }
        }
        for (Object crafter : this.field_75149_d) {
            ICrafting iCrafting = (ICrafting)crafter;
            iCrafting.func_71112_a((Container)this, 2, this.sortOption);
            iCrafting.func_71112_a((Container)this, 4, this.sortOrder);
        }
    }

    private class SlotTabletInput
    extends Slot {
        private ContainerTransmutationTablet containerTransmutationTablet;

        public SlotTabletInput(ContainerTransmutationTablet containerTransmutationTablet2, IInventory iInventory, int slotIndex, int x, int y) {
            super(iInventory, slotIndex, x, y);
            this.containerTransmutationTablet = containerTransmutationTablet2;
        }

        public boolean func_75214_a(ItemStack itemStack) {
            return EnergyValueRegistry.getInstance().hasEnergyValue(itemStack) && AbilityRegistry.getInstance().isRecoverable(itemStack);
        }

        public void func_82870_a(EntityPlayer entityPlayer, ItemStack itemStack) {
            super.func_82870_a(entityPlayer, itemStack);
            this.containerTransmutationTablet.tileEntityTransmutationTablet.updateEnergyValueFromInventory();
            this.containerTransmutationTablet.updateInventory();
        }

        public void func_75215_d(ItemStack itemStack) {
            super.func_75215_d(itemStack);
            this.containerTransmutationTablet.tileEntityTransmutationTablet.updateEnergyValueFromInventory();
            this.containerTransmutationTablet.updateInventory();
        }
    }

    private class SlotTabletOutput
    extends Slot {
        private ContainerTransmutationTablet containerTransmutationTablet;

        public SlotTabletOutput(ContainerTransmutationTablet containerTransmutationTablet2, IInventory iInventory, int slotIndex, int x, int y) {
            super(iInventory, slotIndex, x, y);
            this.containerTransmutationTablet = containerTransmutationTablet2;
        }

        public boolean func_75214_a(ItemStack itemStack) {
            return false;
        }

        public boolean func_82869_a(EntityPlayer entityPlayer) {
            return this.func_75216_d();
        }

        public void func_82870_a(EntityPlayer entityPlayer, ItemStack itemStack) {
            super.func_82870_a(entityPlayer, itemStack);
            if (this.func_75216_d()) {
                this.containerTransmutationTablet.tileEntityTransmutationTablet.consumeInventoryForEnergyValue(itemStack);
            }
        }

        public void func_75218_e() {
            super.func_75218_e();
            if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                this.containerTransmutationTablet.tileEntityTransmutationTablet.updateEnergyValueFromInventory();
            }
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_111238_b() {
            return this.func_75216_d();
        }
    }

    private class SlotAlchemicalTome
    extends Slot {
        private ContainerTransmutationTablet containerTransmutationTablet;
        private TileEntityTransmutationTablet tileEntityTransmutationTablet;

        public SlotAlchemicalTome(ContainerTransmutationTablet containerTransmutationTablet2, IInventory iInventory, int slotIndex, int x, int y) {
            super(iInventory, slotIndex, x, y);
            this.containerTransmutationTablet = containerTransmutationTablet2;
            this.tileEntityTransmutationTablet = containerTransmutationTablet2.tileEntityTransmutationTablet;
        }

        public int func_75219_a() {
            return 1;
        }

        public boolean func_75214_a(ItemStack itemStack) {
            return itemStack.func_77973_b() instanceof ItemAlchemicalTome;
        }

        public void func_82870_a(EntityPlayer entityPlayer, ItemStack itemStack) {
            super.func_82870_a(entityPlayer, itemStack);
            this.containerTransmutationTablet.inventoryTransmutationTablet = new InventoryTransmutationTablet();
            this.containerTransmutationTablet.updateInventory();
            if (!this.tileEntityTransmutationTablet.func_145831_w().field_72995_K && itemStack != null && itemStack.func_77973_b() instanceof ItemAlchemicalTome && ItemHelper.hasOwnerUUID(itemStack)) {
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageTransmutationKnowledgeUpdate(this.containerTransmutationTablet.tileEntityTransmutationTablet, null), new NetworkRegistry.TargetPoint(this.tileEntityTransmutationTablet.func_145831_w().field_73011_w.field_76574_g, (double)this.tileEntityTransmutationTablet.field_145851_c, (double)this.tileEntityTransmutationTablet.field_145848_d, (double)this.tileEntityTransmutationTablet.field_145849_e, 5.0));
            }
        }

        public void func_75215_d(ItemStack itemStack) {
            super.func_75215_d(itemStack);
            if (!this.tileEntityTransmutationTablet.func_145831_w().field_72995_K && itemStack != null && itemStack.func_77973_b() instanceof ItemAlchemicalTome && ItemHelper.hasOwnerUUID(itemStack)) {
                Set<ItemStack> knownTransmutations = TransmutationKnowledgeRegistry.getInstance().getPlayersKnownTransmutations(ItemHelper.getOwnerUUID(itemStack));
                this.containerTransmutationTablet.inventoryTransmutationTablet = new InventoryTransmutationTablet(knownTransmutations);
                this.containerTransmutationTablet.updateInventory();
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageTransmutationKnowledgeUpdate(this.containerTransmutationTablet.tileEntityTransmutationTablet, knownTransmutations), new NetworkRegistry.TargetPoint(this.tileEntityTransmutationTablet.func_145831_w().field_73011_w.field_76574_g, (double)this.tileEntityTransmutationTablet.field_145851_c, (double)this.tileEntityTransmutationTablet.field_145848_d, (double)this.tileEntityTransmutationTablet.field_145849_e, 5.0));
            }
        }
    }
}

