/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.village;

import cpw.mods.fml.common.registry.VillagerRegistry;
import java.util.ArrayList;
import java.util.Random;
import mcjty.rftools.GeneralConfiguration;
import mcjty.rftools.blocks.dimletconstruction.DimletConstructionSetup;
import mcjty.rftools.blocks.dimlets.DimletSetup;
import mcjty.rftools.items.dimlets.DimletEntry;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletRandomizer;
import mcjty.rftools.items.dimlets.KnownDimletConfiguration;
import mcjty.rftools.items.parts.StructureEssenceItem;
import mcjty.varia.WeightedRandomSelector;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;

public class RFToolsTradeHandler
implements VillagerRegistry.IVillageTradeHandler {
    public static RFToolsTradeHandler INSTANCE = new RFToolsTradeHandler();

    public void load() {
        VillagerRegistry.instance().registerVillageTradeHandler(GeneralConfiguration.villagerId, (VillagerRegistry.IVillageTradeHandler)this);
    }

    public void manipulateTradesForVillager(EntityVillager villager, MerchantRecipeList recipeList, Random random) {
        switch (random.nextInt(4)) {
            case 0: {
                this.getRandomBuyEssence(recipeList, random);
                break;
            }
            case 1: {
                this.getRandomSellEssence(recipeList, random);
                break;
            }
            case 2: {
                recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1), new ItemStack((Item)DimletSetup.unknownDimlet, 2 + random.nextInt(3))));
                break;
            }
            case 3: {
                this.getRandomBuyDimlet(villager, recipeList, random, 1);
            }
        }
        switch (random.nextInt(5)) {
            case 0: {
                this.getRandomBuyEssence(recipeList, random);
                break;
            }
            case 1: {
                this.getRandomSellEssence(recipeList, random);
                break;
            }
            case 2: {
                recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1), new ItemStack((Item)DimletSetup.unknownDimlet, 3 + random.nextInt(6))));
                break;
            }
            case 3: {
                this.getRandomBuyDimlet(villager, recipeList, random, 2);
                break;
            }
            case 4: {
                this.getRandomSellDimlet(villager, recipeList, random, 0.15f);
            }
        }
        switch (random.nextInt(2)) {
            case 0: {
                this.getRandomSellDimlet(villager, recipeList, random, 1.0f);
                break;
            }
            case 1: {
                recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 2 + random.nextInt(2)), new ItemStack((Item)DimletSetup.dimensionalShard, 4 + random.nextInt(8))));
            }
        }
    }

    private void getRandomBuyEssence(MerchantRecipeList recipeList, Random random) {
        ArrayList<Integer> keys = new ArrayList<Integer>(StructureEssenceItem.structures.keySet());
        int structureType = (Integer)keys.get(random.nextInt(keys.size()));
        recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1 + random.nextInt(2)), new ItemStack((Item)DimletConstructionSetup.structureEssenceItem, 1, structureType)));
    }

    private void getRandomSellEssence(MerchantRecipeList recipeList, Random random) {
        ArrayList<Integer> keys = new ArrayList<Integer>(StructureEssenceItem.structures.keySet());
        int structureType = (Integer)keys.get(random.nextInt(keys.size()));
        recipeList.add((Object)new MerchantRecipe(new ItemStack((Item)DimletConstructionSetup.structureEssenceItem, 1, structureType), new ItemStack(Items.field_151166_bC, 2 + random.nextInt(3))));
    }

    private void getRandomSellDimlet(EntityVillager villager, MerchantRecipeList recipeList, Random random, float dimletBonus) {
        DimletEntry entry;
        WeightedRandomSelector.Distribution distribution = DimletRandomizer.randomDimlets.createDistribution(dimletBonus);
        DimletKey dimlet = DimletRandomizer.getRandomDimlet((WeightedRandomSelector.Distribution<Integer>)distribution, random);
        if (dimlet != null && (entry = KnownDimletConfiguration.idToDimletEntry.get(dimlet)) != null) {
            int rarity = entry.getRarity();
            ItemStack dimletStack = KnownDimletConfiguration.makeKnownDimlet(dimlet, villager.field_70170_p);
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, (1 + random.nextInt(2)) * (rarity / 2 + 1)), dimletStack));
        }
    }

    private void getRandomBuyDimlet(EntityVillager villager, MerchantRecipeList recipeList, Random random, int bonus) {
        DimletEntry entry;
        DimletKey dimlet = DimletRandomizer.getRandomDimlet(random);
        if (dimlet != null && (entry = KnownDimletConfiguration.idToDimletEntry.get(dimlet)) != null) {
            int rarity = entry.getRarity();
            ItemStack dimletStack = KnownDimletConfiguration.makeKnownDimlet(dimlet, villager.field_70170_p);
            recipeList.add((Object)new MerchantRecipe(dimletStack, new ItemStack(Items.field_151166_bC, (bonus + random.nextInt(2)) * (rarity / 2 + 1))));
        }
    }
}

