/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.playerprops;

import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.blocks.teleporter.TeleportationTools;
import mcjty.varia.GlobalCoordinate;
import mcjty.varia.Logging;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class PorterProperties {
    private int target = -1;
    private int teleportTimeout = -1;
    private Entity entity = null;

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public boolean isTeleporting() {
        return this.target != -1 && this.teleportTimeout >= 0;
    }

    public void startTeleport(int target, int ticks) {
        this.target = target;
        this.teleportTimeout = ticks;
    }

    public void tickTeleport() {
        if (this.teleportTimeout < 0) {
            return;
        }
        --this.teleportTimeout;
        if (this.teleportTimeout <= 0) {
            EntityPlayer player = (EntityPlayer)this.entity;
            TeleportDestinations destinations = TeleportDestinations.getDestinations(this.entity.field_70170_p);
            GlobalCoordinate coordinate = destinations.getCoordinateForId(this.target);
            if (coordinate == null) {
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.RED + "Something went wrong! The target has disappeared!"));
                TeleportationTools.applyEffectForSeverity(player, 3, false);
                return;
            }
            TeleportDestination destination = destinations.getDestination(coordinate);
            TeleportationTools.performTeleport((EntityPlayer)this.entity, destination, 0, 10, false);
            this.teleportTimeout = -1;
            this.target = -1;
        }
    }

    public void saveNBTData(NBTTagCompound compound) {
        compound.func_74768_a("target", this.target);
        compound.func_74768_a("ticks", this.teleportTimeout);
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.target = compound.func_74764_b("target") ? compound.func_74762_e("target") : -1;
        this.teleportTimeout = compound.func_74764_b("ticks") ? compound.func_74762_e("ticks") : -1;
    }
}

