/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.teleportprobe;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mcjty.gui.Scrollable;
import mcjty.gui.Window;
import mcjty.gui.events.DefaultSelectionEvent;
import mcjty.gui.events.SelectionEvent;
import mcjty.gui.layout.HorizontalAlignment;
import mcjty.gui.layout.HorizontalLayout;
import mcjty.gui.layout.Layout;
import mcjty.gui.widgets.AbstractContainerWidget;
import mcjty.gui.widgets.Label;
import mcjty.gui.widgets.Panel;
import mcjty.gui.widgets.Slider;
import mcjty.gui.widgets.Widget;
import mcjty.gui.widgets.WidgetList;
import mcjty.rftools.blocks.teleporter.TeleportDestinationClientInfo;
import mcjty.rftools.items.teleportprobe.PacketForceTeleport;
import mcjty.rftools.items.teleportprobe.PacketGetAllReceivers;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.varia.Coordinate;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Mouse;

public class GuiTeleportProbe
extends GuiScreen {
    private int xSize = 356;
    private int ySize = 180;
    private Window window;
    private WidgetList list;
    private static List<TeleportDestinationClientInfo> serverDestinationList = null;
    private static List<TeleportDestinationClientInfo> destinationList = null;
    private int listDirty = 0;

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int k = (this.field_146294_l - this.xSize) / 2;
        int l = (this.field_146295_m - this.ySize) / 2;
        this.list = new WidgetList(this.field_146297_k, (Gui)this).addSelectionEvent((SelectionEvent)new DefaultSelectionEvent(){

            public void doubleClick(Widget parent, int index) {
                GuiTeleportProbe.this.teleport(index);
            }
        });
        Slider listSlider = ((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredWidth(15)).setVertical().setScrollable((Scrollable)this.list);
        AbstractContainerWidget toplevel = ((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setFilledRectThickness(2)).setLayout((Layout)new HorizontalLayout()).addChild((Widget)this.list)).addChild((Widget)listSlider);
        toplevel.setBounds(new Rectangle(k, l, this.xSize, this.ySize));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        serverDestinationList = null;
        destinationList = null;
        this.requestReceiversFromServer();
    }

    private void teleport(int index) {
        TeleportDestinationClientInfo destination = destinationList.get(index);
        Coordinate c = destination.getCoordinate();
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketForceTeleport(c.getX(), c.getY(), c.getZ(), destination.getDimension()));
    }

    public static void setReceivers(List<TeleportDestinationClientInfo> destinationList) {
        serverDestinationList = new ArrayList<TeleportDestinationClientInfo>(destinationList);
    }

    private void requestReceiversFromServer() {
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetAllReceivers());
    }

    private void populateList() {
        if (serverDestinationList == null) {
            return;
        }
        if (serverDestinationList.equals(destinationList)) {
            return;
        }
        destinationList = new ArrayList<TeleportDestinationClientInfo>(serverDestinationList);
        this.list.removeChildren();
        for (TeleportDestinationClientInfo destination : destinationList) {
            Coordinate coordinate = destination.getCoordinate();
            int dim = destination.getDimension();
            Panel panel = new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout());
            panel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setText(destination.getName()).setDesiredWidth(100));
            panel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setText(coordinate.toString()).setDesiredWidth(75));
            panel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setText("Id " + dim).setDesiredWidth(75));
            this.list.addChild((Widget)panel);
        }
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        this.window.mouseClicked(x, y, button);
    }

    public void func_146274_d() {
        super.func_146274_d();
        this.window.handleMouseInput();
    }

    protected void func_146286_b(int x, int y, int button) {
        super.func_146286_b(x, y, button);
        this.window.mouseMovedOrUp(x, y, button);
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        super.func_73869_a(typedChar, keyCode);
        this.window.keyTyped(typedChar, keyCode);
    }

    public void func_73863_a(int xSize_lo, int ySize_lo, float par3) {
        super.func_73863_a(xSize_lo, ySize_lo, par3);
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.populateList();
            this.listDirty = 10;
        }
        this.window.draw();
        List tooltips = this.window.getTooltips();
        if (tooltips != null) {
            int guiLeft = (this.field_146294_l - this.xSize) / 2;
            int guiTop = (this.field_146295_m - this.ySize) / 2;
            int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            this.drawHoveringText(tooltips, x - guiLeft, y - guiTop, this.field_146297_k.field_71466_p);
        }
    }
}

