/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.teleportprobe;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mcjty.rftools.blocks.teleporter.MatterReceiverTileEntity;
import mcjty.rftools.blocks.teleporter.TeleportConfiguration;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.blocks.teleporter.TeleportationTools;
import mcjty.rftools.playerprops.PlayerExtendedProperties;
import mcjty.varia.Coordinate;
import mcjty.varia.GlobalCoordinate;
import mcjty.varia.Logging;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import org.lwjgl.input.Keyboard;

public class ChargedPorterItem
extends Item
implements IEnergyContainerItem {
    protected int capacity;
    private int maxReceive;
    private int maxExtract;
    private IIcon[] powerLevel = new IIcon[9];

    public ChargedPorterItem() {
        this.func_77625_d(1);
        this.capacity = TeleportConfiguration.CHARGEDPORTER_MAXENERGY;
        this.maxReceive = TeleportConfiguration.CHARGEDPORTER_RECEIVEPERTICK;
        this.maxExtract = 0;
    }

    protected String getIconName() {
        return "chargedPorterItemL";
    }

    protected int getSpeedBonus() {
        return 1;
    }

    public void func_94581_a(IIconRegister iconRegister) {
        for (int i = 0; i <= 8; ++i) {
            this.powerLevel[i] = iconRegister.func_94245_a("rftools:" + this.getIconName() + i);
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        int level;
        NBTTagCompound tagCompound = stack.func_77978_p();
        int energy = 0;
        if (tagCompound != null) {
            energy = tagCompound.func_74762_e("Energy");
        }
        if ((level = 9 * energy / this.capacity) < 0) {
            level = 0;
        } else if (level > 8) {
            level = 8;
        }
        return this.powerLevel[8 - level];
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!player.func_70093_af()) {
            this.startTeleport(stack, player, world);
        } else {
            this.selectReceiver(stack, world, player);
        }
        return super.func_77659_a(stack, world, player);
    }

    protected void selectReceiver(ItemStack stack, World world, EntityPlayer player) {
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float sx, float sy, float sz) {
        if (player.func_70093_af()) {
            TileEntity te = world.func_147438_o(x, y, z);
            this.setTarget(stack, player, world, te);
        } else {
            this.startTeleport(stack, player, world);
        }
        return true;
    }

    private void startTeleport(ItemStack stack, EntityPlayer player, World world) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null || !tagCompound.func_74764_b("target") || tagCompound.func_74762_e("target") == -1) {
            if (world.field_72995_K) {
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.RED + "The charged porter has no target."));
            }
            return;
        }
        if (!world.field_72995_K) {
            IExtendedEntityProperties properties = player.getExtendedProperties("RFToolsPlayerProperties");
            PlayerExtendedProperties playerExtendedProperties = (PlayerExtendedProperties)properties;
            if (playerExtendedProperties.getPorterProperties().isTeleporting()) {
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.RED + "Already teleporting!"));
                return;
            }
            int target = tagCompound.func_74762_e("target");
            TeleportDestinations destinations = TeleportDestinations.getDestinations(world);
            GlobalCoordinate coordinate = destinations.getCoordinateForId(target);
            if (coordinate == null) {
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.RED + "Something went wrong! The target has disappeared!"));
                TeleportationTools.applyEffectForSeverity(player, 3, false);
                return;
            }
            TeleportDestination destination = destinations.getDestination(coordinate);
            if (!TeleportationTools.checkValidTeleport(player, world.field_73011_w.field_76574_g, destination.getDimension())) {
                return;
            }
            Coordinate playerCoordinate = new Coordinate((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            int cost = TeleportationTools.calculateRFCost(world, playerCoordinate, destination);
            int energy = this.getEnergyStored(stack);
            if ((cost = (int)((float)cost * 1.5f)) > energy) {
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.RED + "Not enough energy to start the teleportation!"));
                return;
            }
            this.extractEnergyNoMax(stack, cost, false);
            int ticks = TeleportationTools.calculateTime(world, playerCoordinate, destination);
            playerExtendedProperties.getPorterProperties().startTeleport(target, ticks /= this.getSpeedBonus());
            Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.YELLOW + "Start teleportation!"));
        }
    }

    private void setTarget(ItemStack stack, EntityPlayer player, World world, TileEntity te) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        int id = -1;
        if (te instanceof MatterReceiverTileEntity) {
            MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)te;
            if (!matterReceiverTileEntity.checkAccess(player.getDisplayName())) {
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.RED + "You have no access to target this receiver!"));
                return;
            }
            id = matterReceiverTileEntity.getId();
        }
        if (id != -1) {
            this.selectOnReceiver(player, world, tagCompound, id);
        } else {
            this.selectOnThinAir(player, world, tagCompound, stack);
        }
        stack.func_77982_d(tagCompound);
    }

    protected void selectOnReceiver(EntityPlayer player, World world, NBTTagCompound tagCompound, int id) {
        if (world.field_72995_K) {
            Logging.message((EntityPlayer)player, (String)("Charged porter target is set to " + id + "."));
        }
        tagCompound.func_74768_a("target", id);
    }

    protected void selectOnThinAir(EntityPlayer player, World world, NBTTagCompound tagCompound, ItemStack stack) {
        if (world.field_72995_K) {
            Logging.message((EntityPlayer)player, (String)"Charged porter is cleared.");
        }
        tagCompound.func_82580_o("target");
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            list.add(EnumChatFormatting.BLUE + "Energy: " + tagCompound.func_74762_e("Energy") + " RF");
            if (tagCompound.func_74764_b("target")) {
                list.add(EnumChatFormatting.BLUE + "Target: " + tagCompound.func_74762_e("target"));
            } else {
                list.add(EnumChatFormatting.RED + "No target set! Sneak-Right click on receiver to set.");
            }
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add("This RF/charged item allows you to teleport to a");
            list.add("previously set matter receiver. Sneak-right click");
            list.add("on a receiver to set the destination.");
            list.add("Right click to perform the teleport.");
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyReceived = Math.min(this.capacity - energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public int extractEnergyNoMax(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyExtracted = Math.min(energy, maxExtract);
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        return container.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.capacity;
    }
}

